/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermData {
    private static final Logger log = LoggerFactory.getLogger(PermData.class);
    private final List<Long> adminUsers;
    private final List<Long> editUsers;
    private final List<Long> auditUsers;
    private final List<Long> viewUsers;
    private final List<String> adminRoles;
    private final List<String> editRoles;
    private final List<String> auditRoles;
    private final List<String> viewRoles;

    public PermData(List<Long> adminUsers, List<Long> editUsers, List<Long> auditUsers, List<Long> viewUsers, List<String> adminRoles, List<String> editRoles, List<String> auditRoles, List<String> viewRoles) {
        this.adminUsers = adminUsers;
        this.editUsers = editUsers;
        this.auditUsers = auditUsers;
        this.viewUsers = viewUsers;
        this.adminRoles = adminRoles;
        this.editRoles = editRoles;
        this.auditRoles = auditRoles;
        this.viewRoles = viewRoles;
    }

    public static PermData fromDynamicObject(DynamicObject managerData) {
        return new PermData(PermData.getUserPermissionFromDynamicObj(managerData, "adminuser_tag"), PermData.getUserPermissionFromDynamicObj(managerData, "edituser_tag"), PermData.getUserPermissionFromDynamicObj(managerData, "audituser_tag"), PermData.getUserPermissionFromDynamicObj(managerData, "viewuser_tag"), PermData.getRolePermissionFromDynamicObj(managerData, "adminrole_tag"), PermData.getRolePermissionFromDynamicObj(managerData, "editrole_tag"), PermData.getRolePermissionFromDynamicObj(managerData, "auditrole_tag"), PermData.getRolePermissionFromDynamicObj(managerData, "viewrole_tag"));
    }

    public static PermData fromModel(IDataModel model) {
        return new PermData(PermData.getUserPermissionFromModel(model, "perm_admin_user"), PermData.getUserPermissionFromModel(model, "perm_edit_user"), PermData.getUserPermissionFromModel(model, "perm_audit_user"), PermData.getUserPermissionFromModel(model, "perm_view_user"), PermData.getRolePermissionFromModel(model, "perm_admin_role"), PermData.getRolePermissionFromModel(model, "perm_edit_role"), PermData.getRolePermissionFromModel(model, "perm_audit_role"), PermData.getRolePermissionFromModel(model, "perm_view_role"));
    }

    private static List<Long> getUserPermissionFromDynamicObj(DynamicObject managerData, String sourceField) {
        Object fieldValue = managerData.get(sourceField);
        if (fieldValue == null || StringUtils.isBlank((CharSequence)fieldValue.toString())) {
            return new ArrayList<Long>(1);
        }
        String[] userIds = fieldValue.toString().split(",");
        Long[] convertedIds = new Long[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            try {
                if (userIds[i].trim().isEmpty()) continue;
                convertedIds[i] = Long.parseLong(userIds[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("Failed to convert user ID: {}", (Object)userIds[i]);
            }
        }
        return Arrays.asList(convertedIds);
    }

    private static List<String> getRolePermissionFromDynamicObj(DynamicObject managerData, String sourceField) {
        Object fieldValue = managerData.get(sourceField);
        if (fieldValue == null || StringUtils.isBlank((CharSequence)fieldValue.toString())) {
            return new ArrayList<String>(1);
        }
        String[] roleIds = fieldValue.toString().split(",");
        String[] trimmedRoles = new String[roleIds.length];
        for (int i = 0; i < roleIds.length; ++i) {
            trimmedRoles[i] = roleIds[i].trim();
        }
        return Arrays.asList(trimmedRoles);
    }

    private static List<Long> getUserPermissionFromModel(IDataModel model, String field) {
        DynamicObjectCollection collection = (DynamicObjectCollection)model.getValue(field);
        return collection.stream().map(obj -> Long.valueOf(obj.get("fbasedataid_id").toString())).collect(Collectors.toList());
    }

    private static List<String> getRolePermissionFromModel(IDataModel model, String field) {
        DynamicObjectCollection collection = (DynamicObjectCollection)model.getValue(field);
        return collection.stream().map(obj -> obj.get("fbasedataid_id").toString()).collect(Collectors.toList());
    }

    public static String convertToString(List<?> items) {
        return items.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    public boolean isAllEmpty() {
        return PermData.isEmpty(this.adminUsers) && PermData.isEmpty(this.editUsers) && PermData.isEmpty(this.auditUsers) && PermData.isEmpty(this.viewUsers) && PermData.isEmpty(this.adminRoles) && PermData.isEmpty(this.editRoles) && PermData.isEmpty(this.auditRoles) && PermData.isEmpty(this.viewRoles);
    }

    private static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public List<Long> getAdminUsers() {
        return this.adminUsers;
    }

    public List<Long> getEditUsers() {
        return this.editUsers;
    }

    public List<Long> getAuditUsers() {
        return this.auditUsers;
    }

    public List<Long> getViewUsers() {
        return this.viewUsers;
    }

    public List<String> getAdminRoles() {
        return this.adminRoles;
    }

    public List<String> getEditRoles() {
        return this.editRoles;
    }

    public List<String> getAuditRoles() {
        return this.auditRoles;
    }

    public List<String> getViewRoles() {
        return this.viewRoles;
    }
}

