/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.openapi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.openapi.AIKMAPIService;
import kd.ai.km.openapi.UserFileCacheManager;
import kd.ai.km.openapi.UserFileInfo;
import kd.ai.km.utils.KMManager;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.result.OpenApiFile;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

@ApiController(value="aikmins", desc="\u901a\u7528\u77e5\u8bc6\u5b9e\u4f8b")
public class AIKMInstanceAPIService {
    private static final String SYSTEM_TYPE = "ai-km";
    private static final Log logger = LogFactory.getLog(AIKMAPIService.class);

    @ApiPostMapping(value="aikmins/getuploadfilestatus")
    public CustomApiResult<List<UserFileInfo>> getUploadFileStatus(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber) {
        try {
            CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
            if (fail != null) {
                return fail;
            }
            UserFileCacheManager cacheManager = new UserFileCacheManager(repoId + "_" + groupNumber);
            List<UserFileInfo> cacheUserInfos = cacheManager.get();
            KMManager kmManager = new KMManager(repoId);
            this.checkViewPermission(kmManager.getKMEntityNumber());
            long timeOut = 20L;
            long now = System.currentTimeMillis();
            for (UserFileInfo cacheUserInfo : cacheUserInfos) {
                long diff = now - cacheUserInfo.getCreatedTime();
                if (!"A".equals(cacheUserInfo.getStatus()) || diff < timeOut * 60L * 1000L) continue;
                boolean exists = QueryServiceHelper.exists((String)kmManager.getKMEntityNumber(), (Object)cacheUserInfo.getFileId());
                if (exists) {
                    cacheUserInfo.setStatus("C");
                    cacheManager.remove(cacheUserInfo.getFileId());
                    continue;
                }
                cacheUserInfo.setStatus("E");
                cacheUserInfo.setErrorMsg(String.format(ResManager.loadKDString((String)"\u5df2\u8d85\u65f6\u8fc7%s\u5206\u949f,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AIKMInstanceAPIService_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), timeOut));
                cacheManager.update(cacheUserInfo);
            }
            cacheUserInfos.removeIf(o -> o.getStatus().equals("C"));
            return CustomApiResult.success(cacheUserInfos);
        }
        catch (KDBizException ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="aikmins/removeloadfilestatus")
    public CustomApiResult<String> removeUploadFileStatus(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u6587\u4ef6Id", required=true) @ApiParam(value="\u6587\u4ef6Id", required=true) Long id) {
        try {
            CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
            if (fail != null) {
                return fail;
            }
            KMManager kmManager = new KMManager(repoId);
            this.checkDeletePermission(kmManager.getKMEntityNumber());
            UserFileCacheManager cacheManager = new UserFileCacheManager(repoId + "_" + groupNumber);
            boolean result = cacheManager.remove(id);
            return CustomApiResult.success((Object)String.valueOf(result));
        }
        catch (KDBizException ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="aikmins/uploadfileasync")
    public CustomApiResult<Long> uploadFileAsync(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u6587\u4ef6") @ApiParam(value="\u6587\u4ef6") OpenApiFile file) {
        try {
            CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
            if (fail != null) {
                return fail;
            }
            KMManager kmManager = new KMManager(repoId);
            this.checkNewPermission(kmManager.getKMEntityNumber());
            Long id = ID.genLongId();
            UserFileCacheManager cacheManager = new UserFileCacheManager(repoId + "_" + groupNumber);
            UserFileInfo cacheInfo = UserFileInfo.newCacheUserInfo();
            cacheInfo.setFileId(id);
            cacheInfo.setUserId(groupNumber);
            cacheInfo.setFileName(file.getFileName());
            cacheInfo.setFileSize(file.getFileData().length);
            cacheInfo.setFileType(FilenameUtils.getExtension((String)file.getFileName()));
            cacheInfo.setStatus("A");
            cacheManager.put(cacheInfo);
            ThreadPools.executeOnce((String)("upload-file-async-" + id), () -> {
                try {
                    Long groupId = this.getOrCreateGroup(kmManager, groupNumber);
                    this.checkFileExists(groupId, file, kmManager.getKMEntityNumber());
                    kmManager.save(id, groupId, file.getFileName(), file.getFileData(), (Consumer<DynamicObject>)((Consumer)o -> {}));
                    cacheManager.remove(cacheInfo.getFileId());
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                    cacheInfo.setStatus("E");
                    cacheInfo.setErrorMsg(ex.getMessage());
                    cacheManager.update(cacheInfo);
                }
            });
            return CustomApiResult.success((Object)id);
        }
        catch (KDBizException ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    private void checkViewPermission(String entityNumber) {
        boolean hasCreateRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"gai", (String)entityNumber, (String)"47150e89000000ac");
        if (!hasCreateRight) {
            throw new KDBizException(new ErrorCode("109", ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u77e5\u8bc6\u5e93\u7684\u3010\u67e5\u8be2\u3011\u6743\u9650\u3002", (String)"AIKMInstanceAPI_1", (String)SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
        }
    }

    private void checkNewPermission(String entityNumber) {
        boolean hasCreateRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"gai", (String)entityNumber, (String)"47156aff000000ac");
        if (!hasCreateRight) {
            throw new KDBizException(new ErrorCode("109", ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u77e5\u8bc6\u5e93\u7684\u67e5\u8be2\u6743\u9650\uff0c\u4e0d\u80fd\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"AIKMInstanceAPI_0", (String)SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
        }
    }

    private void checkDeletePermission(String entityNumber) {
        boolean hasCreateRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"gai", (String)entityNumber, (String)"4715e1f1000000ac");
        if (!hasCreateRight) {
            throw new KDBizException(new ErrorCode("109", ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u77e5\u8bc6\u5e93\u7684\u3010\u5220\u9664\u3011\u6743\u9650\u3002", (String)"AIKMInstanceAPI_2", (String)SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
        }
    }

    @ApiPostMapping(value="aikmins/uploadfile")
    public CustomApiResult<Long> uploadFile(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u6587\u4ef6") @ApiParam(value="\u6587\u4ef6") OpenApiFile file) {
        try {
            CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
            if (fail != null) {
                return fail;
            }
            KMManager kmManager = new KMManager(repoId);
            this.checkNewPermission(kmManager.getKMEntityNumber());
            Long groupId = this.getOrCreateGroup(kmManager, groupNumber);
            this.checkFileExists(groupId, file, kmManager.getKMEntityNumber());
            Long id = kmManager.save(groupId, file.getFileName(), file.getFileData(), (Consumer<DynamicObject>)((Consumer)o -> {}));
            return CustomApiResult.success((Object)id);
        }
        catch (KDBizException ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    private void checkFileExists(Long groupId, OpenApiFile file, String entityNumber) {
        String hash = DigestUtils.sha256Hex((byte[])file.getFileData());
        boolean exists = QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)file.getFileName()), new QFilter("filehash", "=", (Object)hash), new QFilter("group.id", "=", (Object)groupId)});
        if (exists) {
            String msg = String.format(ResManager.loadKDString((String)"[%s]\u4e0e\u5185\u5bb9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\u3002", (String)"ImprotKnowledgeFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), file.getFileName());
            throw new KDBizException(new ErrorCode("103", msg), new Object[0]);
        }
    }

    private Long getOrCreateGroup(KMManager kmManager, String groupNumber) {
        String groupEntityNumber = MetadataDao.getNumberById((String)kmManager.getKMGroupEntityId());
        MainEntityType groupEntityType = EntityMetadataCache.getDataEntityType((String)groupEntityNumber);
        Map data = BusinessDataReader.loadFromCache((String)groupEntityNumber, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)groupNumber)});
        if (!data.isEmpty()) {
            return ((DynamicObject)data.values().iterator().next()).getLong("id");
        }
        DynamicObject groupData = new DynamicObject((DynamicObjectType)groupEntityType);
        Long id = ID.genLongId();
        groupData.set("id", (Object)id);
        groupData.set("number", (Object)groupNumber);
        groupData.set("name", (Object)groupNumber);
        groupData.set("longnumber", (Object)groupNumber);
        groupData.set("enable", (Object)"1");
        groupData.set("status", (Object)"C");
        groupData.set("level", (Object)0);
        groupData.set("createorg_id", (Object)RequestContext.get().getOrgId());
        groupData.set("visiblerange", (Object)"public");
        SaveServiceHelper.save((IDataEntityType)groupEntityType, (Object[])new Object[]{groupData});
        return id;
    }

    @Nullable
    private static <T> CustomApiResult<T> check(Long repoId, String groupNumber) {
        if (repoId == null) {
            return CustomApiResult.fail((String)"101", (String)"repoId can't be null");
        }
        if (groupNumber == null || groupNumber.isEmpty()) {
            return CustomApiResult.fail((String)"101", (String)"groupId can't be null");
        }
        return null;
    }

    @ApiPostMapping(value="aikmins/getlist")
    public CustomApiResult<@ApiResponseBody(value="\u8fd4\u56de\u503c id:\u6587\u4ef6ID,number:\u7f16\u7801,name:\u6587\u4ef6\u540d\u79f0,createtime:\u521b\u5efa\u65f6\u95f4,attachsize:\u5bb9\u91cf content:\u5339\u914d\u5757\uff08\u8bbe\u7f6e\u5305\u542b\u5206\u5757\u53ef\u7528)") Map<String, Object>> getList(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u5feb\u6377\u641c\u7d22") @ApiParam(value="\u5feb\u6377\u641c\u7d22") String search, @ApiParam(value="\u5305\u542b\u5206\u5757") @ApiParam(value="\u5305\u542b\u5206\u5757") Boolean includeChunk, @ApiParam(value="\u5f00\u59cb\u884c", required=true) @ApiParam(value="\u5f00\u59cb\u884c", required=true) Long start, @ApiParam(value="\u884c\u6570", required=true) @ApiParam(value="\u884c\u6570", required=true) Long rows, @ApiParam(value="\u5411\u91cf\u72b6\u6001") @ApiParam(value="\u5411\u91cf\u72b6\u6001") String[] status) {
        logger.info("getList {} {} {} {} {} {}", new Object[]{repoId, groupNumber, search, includeChunk, start, rows});
        CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
        if (fail != null) {
            return fail;
        }
        start = start < 0L ? 0L : start;
        rows = rows < 0L ? 0L : rows;
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("group.number", "=", (Object)groupNumber));
            if (status != null) {
                qFilters.add(new QFilter("uploadstatus", "in", (Object)status));
            }
            Boolean bl = includeChunk = includeChunk == null ? Boolean.FALSE : includeChunk;
            if (search != null && !search.isEmpty()) {
                qFilters.add(new QFilter("inputcontent_tag", "like", (Object)("%" + search + "%")).or(new QFilter("name", "like", (Object)("%" + search + "%"))));
            } else {
                includeChunk = false;
            }
            KMManager kmManager = new KMManager(repoId);
            this.checkViewPermission(kmManager.getKMEntityNumber());
            ArrayList list = new ArrayList(16);
            HashMap<Long, Map> mapData = new HashMap<Long, Map>(16);
            int index = 0;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMAPIService_getList", (String)kmManager.getKMEntityNumber(), (String)"id,number,name,createtime,attachsize,uploadstatus", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"createtime desc", (int)((int)(start + rows)));){
                for (Row row : ds) {
                    if ((long)index >= start) {
                        HashMap<String, String> map = new HashMap<String, String>(16);
                        map.put("id", row.getString("id"));
                        map.put("number", row.getString("number"));
                        map.put("name", row.getString("name"));
                        map.put("createtime", row.getString("createtime"));
                        map.put("attachsize", row.getString("attachsize"));
                        map.put("uploadstatus", row.getString("uploadstatus"));
                        mapData.put(row.getLong("id"), map);
                        list.add(map);
                    }
                    ++index;
                }
            }
            if (includeChunk.booleanValue()) {
                ArrayList ids = new ArrayList(mapData.size());
                mapData.forEach((k, v) -> ids.add(k));
                DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMAPIService_getList_Chunk", (String)kmManager.getKMEntityNumber(), (String)"id,segmententity.segment_tag", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("segmententity.segment_tag", "like", (Object)("%" + search + "%"))}, (String)"createtime,segmententity.seq");
                Object object = null;
                try {
                    for (Row row : ds) {
                        Map map = (Map)mapData.get(row.getLong("id"));
                        if (map == null || map.containsKey("content")) continue;
                        map.put("content", row.getString("segmententity.segment_tag"));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
            }
            HashMap<String, Serializable> result = new HashMap<String, Serializable>(16);
            int count = ORM.create().count("AIKMAPIService_getList", kmManager.getKMEntityNumber(), qFilters.toArray(new QFilter[0]));
            result.put("total", Integer.valueOf(count));
            result.put("list", list);
            return CustomApiResult.success(result);
        }
        catch (KDBizException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="aikmins/getattachsize")
    public CustomApiResult<Long> getAttachSize(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber) {
        CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
        if (fail != null) {
            return fail;
        }
        try {
            KMManager kmManager = new KMManager(repoId);
            this.checkViewPermission(kmManager.getKMEntityNumber());
            Long result = 0L;
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AIKMAPIService_getAttachSize", (String)kmManager.getKMEntityNumber(), (String)"attachsize", (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)groupNumber)}, (String)"id");){
                for (Row row : ds) {
                    Long attachsize = row.getLong("attachsize");
                    result = result + attachsize;
                }
            }
            return CustomApiResult.success((Object)result);
        }
        catch (KDBizException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiPostMapping(value="aikmins/delete")
    public CustomApiResult<Integer> delete(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u5f85\u5220\u9664\u7684ID", required=true) @ApiParam(value="\u5f85\u5220\u9664\u7684ID", required=true) List<Long> ids) {
        CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
        if (fail != null) {
            return fail;
        }
        try {
            void var10_19;
            void var10_17;
            DynamicObject[] datas;
            KMManager kmManager = new KMManager(repoId);
            this.checkDeletePermission(kmManager.getKMEntityNumber());
            for (DynamicObject dynamicObject : datas = BusinessDataReader.load((Object[])ids.toArray(), (DynamicObjectType)kmManager.getKMEntityType(), (Boolean)true)) {
                DynamicObject d = dynamicObject;
                DynamicObject group = d.getDynamicObject("group");
                if (group.getString("number").equals(groupNumber)) continue;
                return CustomApiResult.fail((String)"105", (String)"invalid ids.");
            }
            if (datas.length == 0) {
                return CustomApiResult.success((Object)0);
            }
            Object[] newIds = new Object[datas.length];
            ArrayList<Long> auditIds = new ArrayList<Long>(16);
            int i = 0;
            DynamicObject[] dynamicObjectArray = datas;
            int d = dynamicObjectArray.length;
            for (int j = 0; j < d; ++j) {
                DynamicObject data3;
                DynamicObject d2 = data3 = dynamicObjectArray[j];
                newIds[i++] = d2.getLong("id");
                if (!d2.getString("status").equals("C")) continue;
                auditIds.add(d2.getLong("id"));
            }
            OperationResult operationResult = new OperationResult();
            operationResult.setSuccess(true);
            if (!auditIds.isEmpty()) {
                OperationResult operationResult2 = OperationServiceHelper.executeOperate((String)"unaudit", (String)kmManager.getKMEntityNumber(), (Object[])auditIds.toArray(), (OperateOption)OperateOption.create());
            }
            if (var10_17.isSuccess()) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("bindentityid", kmManager.getQAEntityNumber());
                OperationResult operationResult3 = OperationServiceHelper.executeOperate((String)"delete", (String)kmManager.getKMEntityNumber(), (Object[])newIds, (OperateOption)operateOption);
                if (operationResult3.isSuccess()) {
                    return CustomApiResult.success((Object)newIds.length);
                }
            }
            StringBuilder errMsg = new StringBuilder(16);
            for (IOperateInfo operateInfo : var10_19.getAllErrorOrValidateInfo()) {
                errMsg.append(operateInfo.getMessage()).append('\n');
            }
            return CustomApiResult.fail((String)"101", (String)errMsg.toString());
        }
        catch (KDBizException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="aikmins/geturl")
    public CustomApiResult<Map<String, String>> getPreviewUrl(@ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) @ApiParam(value="\u77e5\u8bc6\u5e93ID", required=true) Long repoId, @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) @ApiParam(value="\u5206\u7ec4\u7f16\u7801", required=true) String groupNumber, @ApiParam(value="\u6587\u7ae0Id", required=true) @ApiParam(value="\u6587\u7ae0Id", required=true) Long[] id, @ApiParam(value="\u662f\u5426\u4e0b\u8f7dUrl", required=true) @ApiParam(value="\u662f\u5426\u4e0b\u8f7dUrl", required=true) Boolean isDownload) {
        CustomApiResult fail = AIKMInstanceAPIService.check(repoId, groupNumber);
        if (fail != null) {
            return fail;
        }
        try {
            DynamicObject[] datas;
            KMManager kmManager = new KMManager(repoId);
            this.checkViewPermission(kmManager.getKMEntityNumber());
            for (DynamicObject data : datas = BusinessDataReader.load((Object[])id, (DynamicObjectType)kmManager.getKMEntityType(), (Boolean)true)) {
                DynamicObject group = data.getDynamicObject("group");
                if (group.getString("number").equals(groupNumber)) continue;
                return CustomApiResult.fail((String)"105", (String)"invalid ids.");
            }
            Map map = AttachmentServiceHelper.getAttachments((String)kmManager.getKMEntityNumber(), (Object[])id, (String)"attachmentpanelap", (boolean)true);
            if (!map.isEmpty()) {
                HashMap resultMap = new HashMap(16);
                for (Map.Entry kv : map.entrySet()) {
                    String url = isDownload != false ? (String)((Map)((List)kv.getValue()).get(0)).get("url") : (String)((Map)((List)kv.getValue()).get(0)).get("previewurl");
                    resultMap.put(kv.getKey(), url);
                }
                return CustomApiResult.success(resultMap);
            }
            return CustomApiResult.fail((String)"101", (String)"no files.");
        }
        catch (KDBizException ex) {
            return CustomApiResult.fail((String)ex.getErrorCode().getCode(), (String)ex.getMessage());
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            return CustomApiResult.fail((String)"101", (String)ex.getMessage());
        }
    }
}

