/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.openapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.ai.km.openapi.UserFileInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;

public class UserFileCacheManager {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private final String userId;

    public UserFileCacheManager(String userId) {
        this.userId = userId;
    }

    public void put(UserFileInfo value) {
        String[] list = cache.getList(this.getKey());
        if (list == null || list.length == 0) {
            list = new String[]{value.toJsonString()};
            cache.addList(this.getKey(), list, 7, TimeUnit.DAYS);
        } else {
            long now = System.currentTimeMillis();
            ArrayList<String> newList = new ArrayList<String>(list.length);
            for (int i = list.length - 1; i >= 0; --i) {
                UserFileInfo cacheUserInfo = UserFileInfo.fromJsonString(list[i]);
                if (!this.is7Days(cacheUserInfo.getCreatedTime())) continue;
                newList.add(list[i]);
            }
            newList.add(value.toJsonString());
            cache.resetList(this.getKey(), newList.toArray(new String[0]), 7, TimeUnit.DAYS);
        }
    }

    public boolean remove(Long id) {
        String[] list = cache.getList(this.getKey());
        if (list == null || list.length == 0) {
            return false;
        }
        boolean result = false;
        ArrayList<String> newList = new ArrayList<String>(list.length);
        for (String s : list) {
            UserFileInfo cacheUserInfo1 = UserFileInfo.fromJsonString(s);
            if (!cacheUserInfo1.getFileId().equals(id)) {
                if (!this.is7Days(cacheUserInfo1.getCreatedTime())) continue;
                newList.add(s);
                continue;
            }
            result = true;
        }
        cache.resetList(this.getKey(), newList.toArray(new String[0]), 7, TimeUnit.DAYS);
        return result;
    }

    private boolean is7Days(long createdTime) {
        long now = System.currentTimeMillis();
        long sevenDaysAgo = now - TimeUnit.DAYS.toMillis(7L);
        return createdTime > sevenDaysAgo;
    }

    public void update(UserFileInfo cacheUserInfo) {
        String[] list = cache.getList(this.getKey());
        if (list == null || list.length == 0) {
            return;
        }
        ArrayList<String> newList = new ArrayList<String>(list.length);
        for (String s : list) {
            UserFileInfo cacheUserInfo1 = UserFileInfo.fromJsonString(s);
            if (cacheUserInfo1.getFileId().equals(cacheUserInfo.getFileId())) {
                newList.add(cacheUserInfo.toJsonString());
                continue;
            }
            newList.add(s);
        }
        cache.resetList(this.getKey(), newList.toArray(new String[0]), 7, TimeUnit.DAYS);
    }

    public List<UserFileInfo> get() {
        String[] list = cache.getList(this.getKey());
        if (list == null || list.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(list).map(UserFileInfo::fromJsonString).collect(Collectors.toList());
    }

    private String getKey() {
        return String.format("personalkm_%s_%s", CacheKeyUtil.getAcctId(), this.userId);
    }
}

