/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.search.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.km.search.model.KMSearchResult;
import kd.ai.km.service.KMDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.CollectionUtils;

public class KMSearchUtils {
    public static List<KMSearchResult> getKMSearchResultByVector(List<VectorResult> vectorResults, boolean formatChunk, boolean isRelativeUrl, boolean isQContentOnly) {
        if (CollectionUtils.isEmpty(vectorResults)) {
            return new ArrayList<KMSearchResult>(0);
        }
        List knlIds = vectorResults.stream().map(v -> v.getChunk().getKnowledgeId().toString()).collect(Collectors.toList());
        DynamicObjectCollection attachments = QueryServiceHelper.query((String)"bos_attachment", (String)"fattachmentname,fbilltype,finterid,fextname,ffileid,fattachmentsize", (QFilter[])new QFilter[]{new QFilter("finterid", "in", knlIds)});
        Map<Long, DynamicObject> attachmentMap = attachments.stream().collect(Collectors.toMap(a -> a.getLong("finterid"), a -> a));
        ArrayList<KMSearchResult> results = new ArrayList<KMSearchResult>(vectorResults.size());
        for (VectorResult vectorResult : vectorResults) {
            boolean isQ;
            KMSearchResult result = new KMSearchResult();
            Chunk chunk = vectorResult.getChunk();
            String entityId = chunk.getEntityId();
            result.setBusinessId(0L);
            String chunkType = chunk.getChunkType();
            boolean bl = isQ = "QA".equals(chunkType) || "Q".equals(chunkType);
            if ("Q".equals(chunkType) && isQContentOnly) {
                result.setChunk(chunk.getContent());
            } else if (isQ) {
                result.setChunk(KMSearchUtils.getQAChunkContent(chunk, formatChunk));
            } else if (StringUtils.isNotEmpty((CharSequence)chunk.getExtendContent())) {
                result.setChunk(chunk.getExtendContent());
            } else {
                result.setChunk(chunk.getContent());
            }
            result.setChunkId(chunk.getId());
            Long knlId = chunk.getKnowledgeId();
            result.setFileId(knlId);
            if (isQ) {
                DynamicObject attachment = QueryServiceHelper.queryOne((String)entityId, (String)"attachment.fbasedataid_id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)knlId)});
                String associateKnlName = KMSearchUtils.getAssociateKnlName(entityId, chunk.getKnowledgeId());
                if (null != attachment && 0L != attachment.getLong("attachment.fbasedataid_id")) {
                    KMSearchUtils.setQAResultWithAttachment(result, attachment.getLong("attachment.fbasedataid_id"), isRelativeUrl);
                } else if (StringUtils.isNotBlank((CharSequence)associateKnlName)) {
                    KMSearchUtils.setQAResultWithAssociateKnl(result, entityId, knlId, associateKnlName);
                } else {
                    KMSearchUtils.setQAResultWithoutAttchAndKnl(result, entityId, knlId);
                }
            } else if (attachmentMap.containsKey(knlId)) {
                DynamicObject attachmentInfo = attachmentMap.get(knlId);
                KMSearchUtils.setDocResultWithAttachment(result, attachmentInfo, isRelativeUrl);
            } else {
                KMSearchUtils.setDocResultWithoutAttachment(result, entityId, knlId);
            }
            result.setNeedCached(true);
            result.setOrder(chunk.getChunkSeq());
            result.setPageNum(0);
            result.setRepoId(knlId);
            result.setSimilarity(1.0);
            results.add(result);
        }
        return results;
    }

    public static String getQAChunkContent(Chunk chunk, boolean formatChunk) {
        String chunkContent = chunk.getContent();
        if (StringUtils.isBlank((CharSequence)chunkContent)) {
            return "";
        }
        String extendContent = chunk.getExtendContent();
        if (null == extendContent) {
            extendContent = "";
        }
        try {
            String result;
            JSONObject qaJson = JSON.parseObject((String)chunkContent);
            if (!qaJson.containsKey((Object)"Q") || StringUtils.isBlank((CharSequence)qaJson.getString("Q"))) {
                return "";
            }
            String question = qaJson.getString("Q");
            if (formatChunk) {
                result = "\u95ee\u9898\uff1a" + question + "\n\u7b54\u6848\uff1a" + extendContent;
            } else {
                qaJson.put("A", (Object)extendContent);
                result = qaJson.toJSONString();
            }
            return result;
        }
        catch (Exception ignore) {
            return chunkContent + "-" + extendContent;
        }
    }

    private static String getAssociateKnlName(String qaEntityNumber, Long qaKnlId) {
        DynamicObject qaKnlData = QueryServiceHelper.queryOne((String)qaEntityNumber, (String)"associateknl.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)qaKnlId)});
        if (null == qaKnlData) {
            return "";
        }
        return qaKnlData.getString("associateknl.name");
    }

    private static void setQAResultWithAttachment(KMSearchResult result, Long attachmentId, boolean isRelativeUrl) {
        DynamicObject attachmentInfo = QueryServiceHelper.queryOne((String)"bd_attachment", (String)"name,size,url,type", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)attachmentId)});
        String fileName = attachmentInfo.getString("name");
        String fileSize = attachmentInfo.getString("size");
        String fileUrl = attachmentInfo.getString("url");
        String fileExtName = attachmentInfo.getString("type");
        result.setFileName(fileName);
        result.setFilePath(fileUrl);
        result.setFileType(fileExtName);
        result.setFileSize(fileSize);
        result.setTitle(fileName);
        result.setUrl(isRelativeUrl ? fileUrl : UrlService.getAttachmentPreviewUrl((String)fileUrl));
    }

    private static void setQAResultWithAssociateKnl(KMSearchResult result, String qaEntityNumber, Long qaKnlId, String associateKnlName) {
        DynamicObject qaData = QueryServiceHelper.queryOne((String)qaEntityNumber, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)qaKnlId)});
        if (null != qaData) {
            String qaName = qaData.getString("name");
            result.setFileName(associateKnlName);
            result.setUrl(qaName);
            result.setFilePath(qaName);
            result.setTitle(associateKnlName);
            result.setFileType("bill");
            result.setFileSize("0");
            result.setSource("bill");
        }
    }

    private static void setQAResultWithoutAttchAndKnl(KMSearchResult result, String qaEntityNumber, Long qaKnlId) {
        DynamicObject knlData = QueryServiceHelper.queryOne((String)qaEntityNumber, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)qaKnlId)});
        if (null != knlData) {
            String knlName = knlData.getString("name");
            DynamicObject manager = KMDataService.create().getManagerByQAEntityNumber(qaEntityNumber);
            String kmName = manager.getLocaleString("name").getLocaleValue();
            String title = kmName + "-" + knlName;
            result.setFileName(title);
            result.setUrl(knlName);
            result.setFilePath(knlName);
            result.setTitle(title);
            result.setFileType("bill");
            result.setFileSize("0");
            result.setSource("bill");
        }
    }

    private static void setDocResultWithAttachment(KMSearchResult result, DynamicObject attachmentInfo, boolean isRelativeUrl) {
        result.setFileName(attachmentInfo.getString("fattachmentname"));
        String url = attachmentInfo.getString("ffileid");
        result.setFilePath(url);
        result.setFileType(attachmentInfo.getString("fextname"));
        String attachmentSize = attachmentInfo.getString("fattachmentsize");
        if (StringUtils.isNotBlank((CharSequence)attachmentSize)) {
            result.setFileSize(attachmentSize);
        }
        result.setTitle(attachmentInfo.getString("fattachmentname"));
        result.setUrl(isRelativeUrl ? url : UrlService.getAttachmentPreviewUrl((String)url));
    }

    private static void setDocResultWithoutAttachment(KMSearchResult result, String entityNumber, Long knlId) {
        DynamicObject knlData = QueryServiceHelper.queryOne((String)entityNumber, (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)knlId)});
        if (null != knlData) {
            String knlName = knlData.getString("name");
            result.setFileName(knlName);
            result.setUrl(knlName);
            result.setFilePath(knlName);
            result.setTitle(knlName);
            result.setFileType("bill");
            result.setFileSize("0");
            result.setSource("bill");
        }
    }
}

