/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.tpl;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.utils.EntityUtils;
import kd.ai.km.utils.KMJobTaskUtils;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.km.KMType;
import kd.bos.list.BillList;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class KMBaseFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
SearchEnterListener,
UploadListener,
TabSelectListener {
    private static final String SYSTEM = "ai-km";
    private static final String FIELD_CREATEORG = "org";
    private static final String FIELD_GROUP = "group";
    private static final String PARAM_USEORG = "useOrg";
    private static final String PARAM_GROUP_ID = "groupId";
    private static final String BILLLISTAP = "billlistap";
    private static final String GEN_QA = "genqa";
    private static final String GEN_QA_CALLBACK = "genQACallBack";
    private static final String CALLBACK_TASK_GEN_QA = "taskGenQA";
    private static final String USEORG = "useOrg";
    private static final String CALLBACK_TASK_GEN_INDEX = "CALLBACK_TASK_GENINDEX";
    private static final Map<String, ComboItem> comboItemMap = new HashMap<String, ComboItem>(6);

    public void initialize() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addSetFilterListener(setFilterEvent -> setFilterEvent.addCustomQFilter(new QFilter("associateknl.id", "=", this.getModel().getValue("id"))));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
        this.addClickListeners(new String[]{"addqa"});
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getView().getControl("searchqa");
        search.addEnterListener((SearchEnterListener)this);
        Tab tabap = (Tab)this.getControl("tabap1");
        tabap.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String groupId;
        boolean isFromDb = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!isFromDb) {
            this.getView().setVisible(Boolean.FALSE, new String[]{GEN_QA});
        }
        if (StringUtils.isNotBlank((CharSequence)(groupId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_GROUP_ID)))) {
            this.getModel().setValue(FIELD_GROUP, (Object)groupId);
        }
    }

    public void afterBindData(EventObject e) {
        String userOrgId;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && StringUtils.isNotBlank((CharSequence)(userOrgId = parentView.getPageCache().get("useOrg")))) {
            this.getView().getPageCache().put("useOrg", userOrgId);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (GEN_QA.equals(itemKey) && !this.validatePerm(this.getView().getFormShowParameter().getFormId(), "47156aff000000ac", ResManager.loadKDString((String)"\u65b0\u589e", (String)"KMBaseListPlugin_14", (String)SYSTEM, (Object[])new Object[0]))) {
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (GEN_QA.equals(itemKey)) {
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            String qaEntityNumber = billList.getEntityId();
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (StringUtils.isBlank((CharSequence)qaEntityNumber) || pkValue == null) {
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("aikm_genqa_config");
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
            if (name != null) {
                parameter.setCustomParam("subject", (Object)name.getLocaleValue());
            }
            parameter.setCustomParam("knlIds", Collections.singletonList(pkValue));
            parameter.setCustomParam("entityNumber", (Object)this.getView().getFormShowParameter().getFormId());
            parameter.setCustomParam("qaEntityNumber", (Object)qaEntityNumber);
            parameter.setCustomParam("callBackPlugin", (Object)this.getPluginName());
            parameter.setCustomParam("canBackground", (Object)"false");
            DynamicObject dyn = (DynamicObject)this.getModel().getValue(FIELD_GROUP);
            if (dyn != null) {
                parameter.setCustomParam(PARAM_GROUP_ID, dyn.getPkValue());
            }
            parameter.setCustomParam("pkValue", pkValue);
            parameter.setCustomParam("useOrg", this.getView().getFormShowParameter().getCustomParam("useOrg"));
            this.getPageCache().put("genQAConfigParams_" + this.getView().getPageId(), SerializationUtils.toJsonString((Object)parameter.getCustomParams()));
            this.getView().showForm(parameter);
        }
    }

    public void click(EventObject evt) {
        BillList billList;
        String entityNumber;
        Button button = (Button)evt.getSource();
        if (button != null && "addqa".equals(button.getKey()) && StringUtils.isNotBlank((CharSequence)(entityNumber = (billList = (BillList)this.getControl(BILLLISTAP)).getEntityId()))) {
            Object group = this.getModel().getValue(FIELD_GROUP);
            if (group == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u7ec4\u3002", (String)"KMBaseFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                return;
            }
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.PageDrawer);
            StyleCss css = new StyleCss();
            css.setWidth("30%");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setPlaceholder(false);
            showParameter.setCustomParam(FIELD_GROUP, (Object)FIELD_GROUP);
            String userOrgId = this.getView().getPageCache().get("useOrg");
            if (StringUtils.isNotBlank((CharSequence)userOrgId)) {
                showParameter.setCustomParam("useOrg", (Object)userOrgId);
            }
            showParameter.setFormId(entityNumber);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_billlistap"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (evt instanceof BillListHyperLinkClickEvent) {
            ListSelectedRow selectedRow = ((BillListHyperLinkClickEvent)evt).getCurrentRow();
            if (selectedRow == null) {
                return;
            }
            Object fid = selectedRow.getPrimaryKeyValue();
            String entityNumber = ((BillList)evt.getSource()).getEntityId();
            if (fid != null && StringUtils.isNotBlank((CharSequence)entityNumber)) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.PageDrawer);
                StyleCss css = new StyleCss();
                css.setWidth("30%");
                showParameter.getOpenStyle().setInlineStyleCss(css);
                showParameter.getOpenStyle().setPlaceholder(false);
                showParameter.setFormId(entityNumber);
                showParameter.setPkId(fid);
                showParameter.setCustomParam("lock_associateknl", (Object)true);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh_billlistap"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        Object source = evt.getSource();
        Search searchControl = (Search)source;
        String key = searchControl.getKey();
        String searchText = evt.getText();
        if ("searchqa".equals(key)) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            FilterParameter fp = new FilterParameter();
            QFilter qFilter = new QFilter("associateknl.id", "=", this.getModel().getValue("id"));
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                qFilter = qFilter.and(new QFilter("question", "like", (Object)("%" + searchText + "%")).or(new QFilter("answer", "like", (Object)("%" + searchText + "%"))));
            }
            fp.setFilter(qFilter);
            billList.setClientQueryFilterParameter(fp);
            billList.refresh();
            billList.clearSelection();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "delete": {
                String formId = this.getView().getFormShowParameter().getFormId();
                String bindEntityId = EntityUtils.getBilllistBindEntityId(formId, BILLLISTAP);
                operate.getOption().setVariableValue("bindentityid", bindEntityId);
                break;
            }
            case "save": 
            case "submit": {
                operate.getOption().setVariableValue("pageid", this.getView().getPageId());
                operate.getOption().setVariableValue("pluginname", this.getPluginName());
                break;
            }
            case "regenindex": {
                int[] selectedRows = ((EntryGrid)this.getControl("segmententity")).getSelectRows();
                if (selectedRows.length != 1) break;
                operate.getOption().setVariableValue("segmentseq", String.valueOf(selectedRows[0]));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        switch (actionId = evt.getActionId()) {
            case "refresh_billlistap": {
                this.getView().updateView(BILLLISTAP);
                break;
            }
            case "genQACallBack": {
                if (evt.getReturnData() == null) break;
                BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
                billList.refresh();
                break;
            }
            case "taskGenQA": {
                if (evt.getReturnData() == null) break;
                Object returnData = evt.getReturnData();
                String success = KMJobTaskUtils.getJobTaskParam(returnData, "success");
                String errorInfos = KMJobTaskUtils.getJobTaskParam(returnData, "errorInfos");
                if (!"true".equals(success)) {
                    if (StringUtils.isBlank((CharSequence)errorInfos)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMBaseListPlugin_16", (String)SYSTEM, (Object[])new Object[0]));
                    } else {
                        List errorInfoList = (List)SerializationUtils.fromJsonString((String)errorInfos, List.class);
                        String title = ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff1a", (String)"KMBaseFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]);
                        this.getView().showTipNotification(title + (String)errorInfoList.get(0));
                    }
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("aikm_genqa_result");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam("pageId", (Object)this.getView().getPageId());
                fsp.setCustomParam("fileCount", (Object)1);
                fsp.setCustomParam("kmEntityNumber", (Object)this.getView().getFormShowParameter().getFormId());
                fsp.setCustomParam("useOrg", (Object)this.getView().getPageCache().get("useOrg"));
                fsp.setCustomParam("prompt", (Object)KMJobTaskUtils.getJobTaskParam(evt.getReturnData(), "prompt"));
                fsp.setCustomParam("lastConfigs", (Object)KMJobTaskUtils.getJobTaskParam(evt.getReturnData(), "lastConfigs"));
                fsp.setCustomParam("genCount", (Object)KMJobTaskUtils.getJobTaskParam(evt.getReturnData(), "genCount"));
                this.getView().showForm(fsp);
                break;
            }
            case "CALLBACK_TASK_GENINDEX": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private boolean validatePerm(String entityNumber, String permItem, String permName) {
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityNumber, (String)permItem);
        if (!hasPerm) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KMBaseListPlugin_13", (String)SYSTEM, (Object[])new Object[0]);
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return true;
            }
            QFilter filter = new QFilter("kmentityid", "=", (Object)entityId);
            filter.or("kmqaentityid", "=", (Object)entityId);
            DynamicObject manager = QueryServiceHelper.queryOne((String)"aikm_knl_manager", (String)"name", (QFilter[])new QFilter[]{filter});
            if (null == manager) {
                return true;
            }
            this.getView().showErrorNotification(String.format(msg, manager.getString("name"), permName));
            return false;
        }
        return true;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tableKey = tabSelectEvent.getTabKey();
        if ("segmentdetailtab".equals(tableKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap3"});
        } else if ("segmentindextab".equals(tableKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap3"});
        }
    }

    static {
        comboItemMap.put("auto", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u81ea\u52a8\u5339\u914d", (String)"KMTemplateFormPlugin_10", (String)SYSTEM, (Object[])new Object[0])), "auto"));
        comboItemMap.put("common", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u901a\u7528\u6587\u4ef6", (String)"KMTemplateFormPlugin_11", (String)SYSTEM, (Object[])new Object[0])), KMType.common.getName()));
        comboItemMap.put("excel", new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8868\u683c\u6587\u4ef6", (String)"KMTemplateFormPlugin_12", (String)SYSTEM, (Object[])new Object[0])), KMType.excel.getName()));
        comboItemMap.put("java", new ComboItem(new LocaleString(ResManager.loadKDString((String)"JAVA\u4ee3\u7801", (String)"KMTemplateFormPlugin_14", (String)SYSTEM, (Object[])new Object[0])), KMType.java.getName()));
        comboItemMap.put("kingscript", new ComboItem(new LocaleString(ResManager.loadKDString((String)"KingScript\u4ee3\u7801", (String)"KMTemplateFormPlugin_15", (String)SYSTEM, (Object[])new Object[0])), KMType.kingscript.getName()));
    }
}

