/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class CorpusLibsListPlugin
extends AbstractListPlugin {
    private static final String ENTITY_KNL_CORPUS = "knl_corpus";
    private static final String ENTITY_CORPUS_LIBS = "corpus_libs";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_KNL_COUNT = "knlcount";
    private static final String BTN_KNL_MANAGEMENT = "knl_mgmt";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_KNL_MANAGEMENT});
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object pkId;
        String opKey;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_KNL_MANAGEMENT.equalsIgnoreCase(opKey = ((Button)source).getKey()) && (pkId = ((IListView)this.getView()).getFocusRowPkId()) != null) {
            this.cacheFields(pkId);
        }
    }

    public void click(EventObject evt) {
        String opKey;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_KNL_MANAGEMENT.equalsIgnoreCase(opKey = ((Button)source).getKey())) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(ENTITY_KNL_CORPUS);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String assistantNum = this.getPageCache().get("type");
            String dataSource = this.getPageCache().get("datasource");
            String repoId = this.getPageCache().get("repoid");
            String assistantType = this.getPageCache().get("assistanttype");
            showParameter.setCustomParam("type", (Object)assistantNum);
            showParameter.setCustomParam("repoid", (Object)repoId);
            showParameter.setCustomParam("assistanttype", (Object)assistantType);
            showParameter.setCustomParam("datasource", (Object)dataSource);
            showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("type", "=", (Object)assistantNum));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CorpusLibsDataProvider());
    }

    private boolean cacheFields(Object pkId) {
        String dataSource;
        String type;
        DynamicObject dynamicObject = BusinessDataReader.loadSingle((Object)pkId, (String)ENTITY_CORPUS_LIBS, (String)"number,type,productline,indexmethod,status,datasource");
        if (null == dynamicObject) {
            return false;
        }
        if (dynamicObject.containsProperty(PROP_NUMBER) && StringUtils.isNotBlank((CharSequence)(type = dynamicObject.getString(PROP_NUMBER)))) {
            this.getView().getPageCache().put("type", type);
        }
        if (dynamicObject.containsProperty("datasource") && StringUtils.isNotBlank((CharSequence)(dataSource = dynamicObject.getString("datasource")))) {
            this.getView().getPageCache().put("datasource", dataSource);
        }
        String repoIdStr = "";
        String indexMethod = dynamicObject.getString("indexmethod");
        if (StringUtils.isNotBlank((CharSequence)indexMethod)) {
            repoIdStr = indexMethod;
        }
        if (StringUtils.isBlank((CharSequence)repoIdStr)) {
            this.getView().getPageCache().put("assistanttype", "");
            return false;
        }
        this.getView().getPageCache().put("repoid", repoIdStr);
        String assistantType = dynamicObject.getDynamicObject("type").getString(PROP_NUMBER);
        this.getView().getPageCache().put("assistanttype", assistantType);
        return true;
    }

    static class CorpusLibsDataProvider
    extends ListDataProvider {
        CorpusLibsDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return rows;
            }
            DataEntityPropertyCollection properties = ((DynamicObject)rows.get(0)).getDataEntityType().getProperties();
            if (!properties.containsKey((Object)CorpusLibsListPlugin.PROP_KNL_COUNT)) {
                return rows;
            }
            DynamicObjectCollection knowledges = QueryServiceHelper.query((String)CorpusLibsListPlugin.ENTITY_KNL_CORPUS, (String)"id,group.type", null);
            if (knowledges.isEmpty()) {
                return rows;
            }
            Map<String, List<DynamicObject>> typeKnowledgeMap = knowledges.stream().filter(e -> null != e.get("group.type")).collect(Collectors.groupingBy(e -> e.getString("group.type")));
            for (DynamicObject row : rows) {
                String libNumber = row.getString(CorpusLibsListPlugin.PROP_NUMBER);
                if (!typeKnowledgeMap.containsKey(libNumber)) continue;
                row.set(CorpusLibsListPlugin.PROP_KNL_COUNT, (Object)typeKnowledgeMap.get(libNumber).size());
            }
            return rows;
        }
    }
}

