/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.utils.KnowledgeUtils;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportKnowledgeFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final Logger log = LoggerFactory.getLogger(ImportKnowledgeFormPlugin.class);
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final String BTN_OK = "btnok";
    private static final String PROP_CREATE_ORG = "createorg";
    private static final String PROP_FILE_HASH = "filehash";
    private static final String OPTION_ENABLE_OCR = "enableocr";
    private static final String PARAM_USEORG = "useOrg";
    private static final String PARAM_ENTITY_NUMBER = "entityNumber";
    private static final String CONTAINER_CREATE_ORG = "createorgap";
    private static final String CALLBACK_TASK_IMPORT_KNL = "taskImportKnl";
    private static final int UPLOAD_FILE_MAX_SIZE = 0x6400000;
    private List<String> fileTypeList = new ArrayList<String>(10);
    private final Set<String> existFileNames = new HashSet<String>(16);
    private int nameMaxLenth = 200;
    private static final TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
    private final List<String> importErrorInfos = new ArrayList<String>(10);
    private Map<String, String> zipFileUrlNameMap = new HashMap<String, String>(16);
    private Map<String, Set<String>> existFileHashNameMap = new HashMap<String, Set<String>>(16);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        Button btnUpload = (Button)this.getControl("btn_upload");
        btnUpload.addUploadListener((UploadListener)this);
        Button btnUploadQA = (Button)this.getControl("btn_upload_qa");
        btnUploadQA.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        Object isQAKnl = this.getView().getFormShowParameter().getCustomParam("isQAKnl");
        if ("true".equals(isQAKnl)) {
            this.getModel().setValue("uploadtips", (Object)ResManager.loadKDString((String)"\u652f\u6301\u4e0a\u4f20\u4ee5\u4e0b\u6587\u4ef6\u7c7b\u578b\uff1aXLS\u3001XLSX\uff0c\u4ee5\u53caZIP\u6587\u4ef6\u3002", (String)"ImprotKnowledgeFormPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        } else {
            this.getModel().setValue("uploadtips", (Object)ResManager.loadKDString((String)"\u652f\u6301\u4e0a\u4f20\u4ee5\u4e0b\u6587\u4ef6\u7c7b\u578b\uff1aPDF\u3001TXT\u3001DOCX\u3001DOC\u3001XLS\u3001XLSX\u3001JAVA\u3001TS\u4ee5\u53caZIP\u6587\u4ef6\u3002", (String)"ImprotKnowledgeFormPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String useOrg = (String)fsp.getCustomParam(PARAM_USEORG);
        if (StringUtils.isNotBlank((CharSequence)useOrg)) {
            this.getModel().setValue(PROP_CREATE_ORG, (Object)Long.parseLong(useOrg));
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object isQAKnl = fsp.getCustomParam("isQAKnl");
        if ("true".equals(isQAKnl)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_upload_qa"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_upload"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_upload"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_upload_qa"});
        }
        String entityNumber = (String)fsp.getCustomParam(PARAM_ENTITY_NUMBER);
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CONTAINER_CREATE_ORG});
        } else {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            boolean isOrgKM = entityType.getProperties().containsKey((Object)"org");
            this.getView().setVisible(Boolean.valueOf(isOrgKM), new String[]{CONTAINER_CREATE_ORG});
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(PARAM_ENTITY_NUMBER);
        this.setEnableOCRVisible(entityNumber);
    }

    public void beforeClick(BeforeClickEvent evt) {
        DynamicObjectCollection entryEntity;
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals(key = (button = (Button)source).getKey()) && (entryEntity = this.getModel().getEntryEntity("entryentity")).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImprotKnowledgeFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterUpload(UploadEvent evt) {
        if (evt == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImprotKnowledgeFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        Object[] urls = evt.getUrls();
        Object[] fileNames = evt.getNames();
        if (urls == null || fileNames == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u6587\u4ef6\u670d\u52a1\u5668zk\u914d\u7f6e\u662f\u5426\u6b63\u786e\u3002", (String)"ImprotKnowledgeFormPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> fileUrlNameMap = new HashMap<String, String>(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            if (!StringUtils.isNotBlank((Object)urls[i]) || !StringUtils.isNotBlank((Object)fileNames[i])) continue;
            fileUrlNameMap.put(urls[i].toString(), fileNames[i].toString());
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(PARAM_ENTITY_NUMBER);
        this.nameMaxLenth = this.getEntityNameMaxLenth(entityNumber);
        Object isQAKnl = fsp.getCustomParam("isQAKnl");
        this.fileTypeList = "true".equals(isQAKnl) ? Arrays.asList("xls", "xlsx") : Arrays.asList("pdf", "PDF", "txt", "TXT", "docx", "DOCX", "doc", "DOC", "xls", "XLS", "xlsx", "XLSX", "java", "JAVA", "ts", "TS");
        this.existFileHashNameMap = this.getExistFileHashNameMap(entityNumber);
        this.batchFillFileInfoEntry(fileUrlNameMap);
        if (!this.importErrorInfos.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u5b58\u5728\u4e0a\u4f20\u5931\u8d25\u7684\u77e5\u8bc6\u3002", (String)"ImprotKnowledgeFormPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showMessage(title, String.join((CharSequence)"\n", this.importErrorInfos), MessageTypes.Default);
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6709\u6548\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"ImprotKnowledgeFormPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Button button;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_OK.equals(key = (button = (Button)source).getKey())) {
            this.dispatchImportKnlTask();
        }
    }

    private void batchFillFileInfoEntry(Map<String, String> fileUrlNameMap) {
        for (Map.Entry<String, String> entry : fileUrlNameMap.entrySet()) {
            String fileUrl = entry.getKey();
            String fileName = entry.getValue();
            int suffixIndex = fileName.lastIndexOf(".");
            if (suffixIndex <= 0) continue;
            String fileType = fileName.substring(suffixIndex + 1);
            try {
                if ("zip".equalsIgnoreCase(fileType)) {
                    this.loadZipFileInfos(fileName, fileUrl);
                    continue;
                }
                if (!this.fileTypeList.contains(fileType.toLowerCase())) continue;
                this.loadSingleFileInfo(fileName, fileType, fileUrl);
            }
            catch (IOException e) {
                log.error(fileName, (Throwable)e);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u4fe1\u606f\u5931\u8d25\uff1a%s", (String)"ImprotKnowledgeFormPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]), e.getMessage()));
            }
        }
    }

    private void dispatchImportKnlTask() {
        Object createOrg;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ImprotKnowledgeFormPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam(PARAM_ENTITY_NUMBER);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = entityType.getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        LocaleString jobName = new LocaleString(entityType.getDisplayName().getLocaleValue() + "-" + fsp.getFormConfig().getCaption().getLocaleValue());
        jobInfo.setName(jobName.toString());
        jobInfo.setNumber(entityNumber + "_importKnlJob");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.bos.gptas.kmbase.knowledge.ImportKnowledgeTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("enableOcr", this.getModel().getValue(OPTION_ENABLE_OCR));
        params.put("isQAKnl", fsp.getCustomParam("isQAKnl"));
        params.put("fileInfos", this.getAllUploadFileInfos(entryEntity));
        if (!this.zipFileUrlNameMap.isEmpty()) {
            params.put("zipFileNames", this.zipFileUrlNameMap);
        }
        params.put(PARAM_ENTITY_NUMBER, entityNumber);
        Object groupId = fsp.getCustomParam("groupId");
        if (null != groupId) {
            params.put("groupId", groupId);
        }
        if (null != (createOrg = this.getModel().getValue(PROP_CREATE_ORG))) {
            params.put(PARAM_USEORG, ((DynamicObject)createOrg).getPkValue());
        } else {
            Object useOrg = fsp.getCustomParam(PARAM_USEORG);
            if (StringUtils.isNotBlank((Object)useOrg)) {
                params.put(PARAM_USEORG, useOrg);
            }
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack("kd.bos.gptas.kmbase.knowledge.KMTemplateListPlugin", CALLBACK_TASK_IMPORT_KNL);
        IFormView parentView = this.getView().getParentView();
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"ImprotKnowledgeFormPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.bos.gptas.kmbase.knowledge.ImportKnowledgeTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)parentView);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private List<Map<String, String>> getAllUploadFileInfos(DynamicObjectCollection doc) {
        ArrayList<Map<String, String>> fileInfos = new ArrayList<Map<String, String>>(doc.size());
        for (DynamicObject obj : doc) {
            HashMap<String, String> fileInfo = new HashMap<String, String>(6);
            fileInfo.put("filename", obj.getString("filename"));
            fileInfo.put("url", obj.getString("url"));
            fileInfo.put("filetype", obj.getString("filetype"));
            fileInfo.put("filesize", obj.getString("filesize"));
            fileInfo.put("uploadtype", obj.getString("uploadtype"));
            fileInfo.put("relativepath", obj.getString("relativepath"));
            fileInfo.put(PROP_FILE_HASH, obj.getString(PROP_FILE_HASH));
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    private void loadZipFileInfos(String zipFileName, String zipUrl) {
        int availableFileCount = 0;
        try (InputStream inputStream = tempFileCache.getInputStream(zipUrl);
             ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream);){
            ZipArchiveEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextZipEntry()) != null) {
                String fileType;
                int suffixIndex;
                String relativePath;
                if (zipEntry.isDirectory() || (relativePath = zipEntry.getName().contains("?") ? new String(zipEntry.getRawName(), "GBK") : zipEntry.getName()).startsWith("__MACOSX") || (suffixIndex = relativePath.lastIndexOf(".")) < 0 || !this.fileTypeList.contains((fileType = relativePath.substring(relativePath.lastIndexOf(".") + 1)).toLowerCase())) continue;
                String fileName = this.getFileNameByRelativePath(relativePath, fileType);
                InputStream copyInputStream = KnowledgeUtils.copyInputStream((InputStream)zipInputStream);
                String fileHash = this.getFileHashByInputStream(copyInputStream);
                if (!this.validateDuplicateFile(fileHash, fileName)) {
                    this.importErrorInfos.add(String.format(ResManager.loadKDString((String)"[%s]\u4e0e\u5185\u5bb9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\u3002", (String)"ImprotKnowledgeFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), fileName));
                    continue;
                }
                int fileSize = this.getFileSize(copyInputStream);
                if (fileSize > 0x6400000) {
                    this.importErrorInfos.add(relativePath + ResManager.loadKDString((String)"\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7100M\u3002", (String)"ImprotKnowledgeFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    continue;
                }
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                fileName = this.getFileNameWithoutDuplicate(fileName, fileType);
                this.getModel().setValue("filename", (Object)fileName, rowIndex);
                this.getModel().setValue("filetype", (Object)fileType, rowIndex);
                this.getModel().setValue("relativepath", (Object)relativePath, rowIndex);
                this.getModel().setValue("formatsize", (Object)KnowledgeUtils.getFileSizeFormat(fileSize), rowIndex);
                this.getModel().setValue("filesize", (Object)fileSize, rowIndex);
                this.getModel().setValue("url", (Object)zipUrl, rowIndex);
                this.getModel().setValue("uploadtype", (Object)"zip", rowIndex);
                this.getModel().setValue("uploaddate", (Object)new Date(), rowIndex);
                this.getModel().setValue(PROP_FILE_HASH, (Object)fileHash, rowIndex);
                this.existFileHashNameMap.computeIfAbsent(fileHash, k -> new HashSet()).add(fileName);
                ++availableFileCount;
            }
        }
        catch (IOException e) {
            log.error(zipFileName + "\uff1a" + e);
        }
        if (availableFileCount > 0) {
            this.zipFileUrlNameMap.put(zipUrl, zipFileName);
        }
    }

    private void loadSingleFileInfo(String fileName, String fileType, String fileUrl) throws IOException {
        InputStream inputStream = KnowledgeUtils.copyInputStream(tempFileCache.getInputStream(fileUrl));
        int fileSize = this.getFileSize(inputStream);
        if (fileSize > 0x6400000) {
            this.importErrorInfos.add(fileName + ResManager.loadKDString((String)"\uff1a\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7100M\u3002", (String)"ImprotKnowledgeFormPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        inputStream.reset();
        String fileHash = this.getFileHashByInputStream(inputStream);
        if (!this.validateDuplicateFile(fileHash, fileName)) {
            this.importErrorInfos.add(String.format(ResManager.loadKDString((String)"[%s]\u4e0e\u5185\u5bb9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0a\u4f20\u3002", (String)"ImprotKnowledgeFormPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), fileName));
            return;
        }
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("filename", (Object)this.getFileNameWithoutDuplicate(fileName, fileType), rowIndex);
        this.getModel().setValue("filetype", (Object)fileType, rowIndex);
        this.getModel().setValue("formatsize", (Object)KnowledgeUtils.getFileSizeFormat(fileSize), rowIndex);
        this.getModel().setValue("filesize", (Object)fileSize, rowIndex);
        this.getModel().setValue("url", (Object)fileUrl, rowIndex);
        this.getModel().setValue("uploadtype", (Object)"common", rowIndex);
        this.getModel().setValue("relativepath", (Object)fileName, rowIndex);
        this.getModel().setValue("uploaddate", (Object)new Date(), rowIndex);
        this.getModel().setValue(PROP_FILE_HASH, (Object)fileHash, rowIndex);
        this.existFileHashNameMap.computeIfAbsent(fileHash, k -> new HashSet()).add(fileName);
    }

    private int getEntityNameMaxLenth(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty nameProp = entityType.getProperty("name");
        int nameMaxLenth = 200;
        if (nameProp instanceof MuliLangTextProp) {
            nameMaxLenth = ((MuliLangTextProp)nameProp).getMaxLenth();
        }
        return nameMaxLenth;
    }

    private String getFileNameByRelativePath(String fileName, String fileType) {
        String result = fileName.substring(0, fileName.length() - fileType.length() - 1);
        if ((result = result.replace("/", File.separator).replace("\\", File.separator)).contains(File.separator)) {
            result = result.substring(result.lastIndexOf(File.separator) + 1);
        }
        if (result.length() > this.nameMaxLenth - fileType.length() - 5) {
            result = result.substring(0, this.nameMaxLenth - fileType.length() - 5);
        }
        return result + "." + fileType;
    }

    private String getFileNameWithoutDuplicate(String fileName, String fileType) {
        if (this.existFileNames.add(fileName)) {
            return fileName;
        }
        int count = 1;
        String fileNameWithoutSuffix = fileName.substring(0, fileName.length() - fileType.length() - 1);
        String tempFileName = fileName;
        while (this.existFileNames.contains(tempFileName)) {
            tempFileName = fileNameWithoutSuffix + "(" + count + ")." + fileType;
            ++count;
        }
        this.existFileNames.add(tempFileName);
        return tempFileName;
    }

    private int getFileSize(InputStream inputStream) throws IOException {
        int index;
        byte[] buffer = new byte[1024];
        int fileSize = 0;
        while ((index = inputStream.read(buffer)) != -1) {
            fileSize += index;
        }
        return fileSize;
    }

    private Map<String, Set<String>> getExistFileHashNameMap(String entityNumber) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashMap<String, Set<String>>(0);
        }
        QFilter knlFilter = new QFilter(PROP_FILE_HASH, "is not null", (Object)0);
        knlFilter.and(PROP_FILE_HASH, "!=", (Object)" ");
        knlFilter.and(PROP_FILE_HASH, "!=", (Object)"");
        DynamicObjectCollection knlDatas = QueryServiceHelper.query((String)entityNumber, (String)"id,filehash", (QFilter[])new QFilter[]{knlFilter});
        if (null == knlDatas || knlDatas.isEmpty()) {
            return new HashMap<String, Set<String>>(0);
        }
        Map<String, String> knlIdHashMap = knlDatas.stream().collect(Collectors.toMap(k -> k.getString("id"), k -> k.getString(PROP_FILE_HASH)));
        QFilter attachmentFilter = new QFilter("fbilltype", "=", (Object)entityNumber);
        attachmentFilter.and("finterid", "in", knlIdHashMap.keySet());
        DynamicObjectCollection attachmentInfos = QueryServiceHelper.query((String)"bos_attachment", (String)"finterid,fattachmentname", (QFilter[])new QFilter[]{attachmentFilter});
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>(attachmentInfos.size());
        for (DynamicObject attachmentInfo : attachmentInfos) {
            String knlId = attachmentInfo.getString("finterid");
            String fileHash = knlIdHashMap.get(knlId);
            String fileName = attachmentInfo.getString("fattachmentname");
            resultMap.computeIfAbsent(fileHash, k -> new HashSet()).add(fileName);
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.isEmpty()) {
            return resultMap;
        }
        for (DynamicObject obj : entryEntity) {
            resultMap.computeIfAbsent(obj.getString(PROP_FILE_HASH), k -> new HashSet()).add(obj.getString("filename"));
        }
        return resultMap;
    }

    private boolean validateDuplicateFile(String fileHash, String fileName) {
        if (this.existFileHashNameMap.isEmpty()) {
            return true;
        }
        if (this.existFileHashNameMap.containsKey(fileHash)) {
            Set<String> existFileNames = this.existFileHashNameMap.get(fileHash);
            return !existFileNames.contains(fileName);
        }
        return true;
    }

    private String getFileHashByInputStream(InputStream in) {
        String fileHash = "";
        try {
            fileHash = DigestUtils.sha256Hex((InputStream)in);
            in.reset();
        }
        catch (IOException e) {
            log.error("calculate file hash failed: " + e.getMessage());
        }
        return fileHash;
    }

    private void setEnableOCRVisible(String entityNumber) {
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        boolean enableOCR = splitConfig.isEnableOCR();
        List fileTypes = splitConfig.getFileTypes();
        if (enableOCR && fileTypes != null && !fileTypes.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{OPTION_ENABLE_OCR});
            this.getModel().setValue(OPTION_ENABLE_OCR, (Object)true);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OPTION_ENABLE_OCR});
            this.getModel().setValue(OPTION_ENABLE_OCR, (Object)false);
        }
    }
}

