/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.DocParser;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.parser.FileParseFactory;
import kd.bos.gptas.kmbase.utils.KnowledgeUtils;
import kd.bos.id.ID;
import kd.bos.mvc.base.BaseModel;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportKnowledgeTask
extends AbstractTask
implements ParseListener {
    private static final Logger log = LoggerFactory.getLogger(ImportKnowledgeTask.class);
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private String groupId = "";
    private Long useOrgId = 0L;
    private String entityNumber = "";
    private boolean isQAKnl = false;
    private boolean enableOcr = false;
    private List<String> fileTypes = new ArrayList<String>(10);
    private static final FileService fileService;
    private static final List<String> forbiddenExtensions;
    private static final TempFileCache cache;
    private static final OperateOption option;
    private final List<String> errorInfos = new ArrayList<String>(10);
    private final List<String> warnInfos = new ArrayList<String>(10);
    private Map<String, String> zipFileUrlNameMap = new HashMap<String, String>(16);
    private int progressPercent = 0;
    private int fileCount = 0;
    private int progressCount = 1;
    private int successCount = 0;
    private long currentUserId = 0L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, Object> returnData = new HashMap<String, Object>(3);
        this.entityNumber = (String)map.get("entityNumber");
        if (!this.validateBeforeExecute(map, returnData)) {
            return;
        }
        this.checkIsStop();
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"ImportKnowledgeTask_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
        this.currentUserId = requestContext.getCurrUserId();
        this.isQAKnl = "true".equals(map.get("isQAKnl"));
        this.enableOcr = Boolean.TRUE.equals(map.get("enableOcr"));
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(this.entityNumber);
        this.fileTypes = KnowledgeUtils.getExtByFileType(splitConfig.getFileTypes());
        List fileInfos = (List)map.get("fileInfos");
        this.fileCount = fileInfos.size();
        if (map.containsKey("zipFileNames")) {
            this.zipFileUrlNameMap = (Map)map.get("zipFileNames");
        }
        HashMap<String, List<Map<String, String>>> zipFileInfos = new HashMap<String, List<Map<String, String>>>(16);
        ArrayList<Map<String, String>> commonFileInfos = new ArrayList<Map<String, String>>(10);
        this.classifyFileInfos(fileInfos, zipFileInfos, commonFileInfos);
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\u4efd\u6587\u6863\uff1a%3$s", (String)"ImportKnowledgeTask_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        for (Map map2 : commonFileInfos) {
            if (this.getStop()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u4e2d\u6b62\u3002", (String)"ImportKnowledgeTask_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            String url = (String)map2.get("url");
            if (StringUtils.isBlank((CharSequence)url) || !cache.exists(url)) {
                this.errorInfos.add((String)map2.get("filename") + "\uff1a" + ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6587\u4ef6\u3002", (String)"", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                ++this.progressCount;
                continue;
            }
            InputStream in = cache.getInputStream(url);
            this.handleFileImport(map2, KnowledgeUtils.copyInputStream(in), msg);
        }
        this.handleZipFileImport(zipFileInfos, msg);
        if (this.successCount == this.fileCount && this.errorInfos.isEmpty()) {
            returnData.put("success", "true");
        } else {
            returnData.put("success", "false");
        }
        returnData.put("importFileCount", this.fileCount);
        returnData.put("successCount", this.successCount);
        returnData.put("errorInfos", this.errorInfos);
        returnData.put("warnInfos", this.warnInfos);
        this.feedbackCustomdata(returnData);
    }

    private boolean validateBeforeExecute(Map<String, Object> dataMap, Map<String, Object> returnData) {
        if (null == dataMap || dataMap.isEmpty() || !dataMap.containsKey("fileInfos")) {
            returnData.put("success", "false");
            String message = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6587\u6863\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ImportKnowledgeTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.error(message);
            returnData.put("message", message);
            this.feedbackCustomdata(returnData);
            return false;
        }
        List fileInfos = (List)dataMap.get("fileInfos");
        if (fileInfos.isEmpty()) {
            returnData.put("success", "false");
            String message = ResManager.loadKDString((String)"\u5f85\u4e0a\u4f20\u6587\u6863\u4e3a\u7a7a\u3002", (String)"ImportKnowledgeTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.error(message);
            returnData.put("message", message);
            this.feedbackCustomdata(returnData);
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.entityNumber)) {
            returnData.put("success", "false");
            returnData.put("message", ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u77e5\u8bc6\u5e93\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"ImportKnowledgeTask_19", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.feedbackCustomdata(returnData);
            return false;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        boolean isGroupKM = properties.containsKey((Object)"group");
        this.groupId = (String)dataMap.get("groupId");
        if (isGroupKM && StringUtils.isBlank((CharSequence)this.groupId)) {
            returnData.put("success", "false");
            returnData.put("message", ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u9009\u62e9\u5206\u7ec4\u3002", (String)"ImportKnowledgeTask_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            this.feedbackCustomdata(returnData);
            return false;
        }
        boolean isOrgKM = properties.containsKey((Object)"org");
        if (isOrgKM && dataMap.containsKey("useOrg")) {
            Object useOrg = dataMap.get("useOrg");
            if (null == useOrg) {
                returnData.put("success", "false");
                returnData.put("message", ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ImportKnowledgeTask_22", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                this.feedbackCustomdata(returnData);
                return false;
            }
            this.useOrgId = Long.parseLong(useOrg.toString());
        }
        return true;
    }

    private void classifyFileInfos(List<Map<String, String>> fileInfos, Map<String, List<Map<String, String>>> zipFileInfos, List<Map<String, String>> commonFileInfos) {
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u5f85\u4e0a\u4f20\u6587\u6863\u5217\u8868", (String)"ImportKnowledgeTask_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
        for (Map<String, String> fileInfo : fileInfos) {
            String uploadType = fileInfo.get("uploadtype");
            if ("zip".equals(uploadType)) {
                zipFileInfos.computeIfAbsent(fileInfo.get("url"), k -> new ArrayList()).add(fileInfo);
                continue;
            }
            if (!"common".equals(uploadType)) continue;
            commonFileInfos.add(fileInfo);
        }
    }

    private void handleFileImport(Map<String, String> fileInfo, InputStream in, String msg) {
        this.checkIsStop();
        this.progressPercent = 10 + 80 * this.progressCount / this.fileCount;
        this.feedbackProgress(this.progressPercent, String.format(msg, this.progressCount, this.fileCount, ResManager.loadKDString((String)"\u6587\u6863\u4fe1\u606f\u8bfb\u53d6", (String)"ImportKnowledgeTask_5", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
        long knlId = ID.genLongId();
        String fileName = fileInfo.get("filename");
        String fileType = fileInfo.get("filetype");
        if (StringUtils.isNotBlank((CharSequence)fileType)) {
            fileType = fileType.toLowerCase();
        }
        String fileSize = fileInfo.get("filesize");
        String fileHash = fileInfo.get("filehash");
        try {
            this.feedbackProgress(this.progressPercent, String.format(msg, this.progressCount, this.fileCount, ResManager.loadKDString((String)"\u6587\u6863\u4e0a\u4f20", (String)"ImportKnowledgeTask_6", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
            String url = this.uploadAttachmentFile(fileName, fileType, in);
            this.saveAttachmentInfo(this.entityNumber, fileName, knlId, url, Integer.parseInt(fileSize));
            this.feedbackProgress(this.progressPercent, String.format(msg, this.progressCount, this.fileCount, ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790", (String)"ImportKnowledgeTask_7", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
            boolean[] ocrParse = new boolean[]{false};
            String content = this.parseFileContent(fileType, in, url, this.entityNumber, this.isQAKnl, ocrParse);
            this.feedbackProgress(this.progressPercent, ResManager.loadKDString((String)"\u4fdd\u5b58\u77e5\u8bc6", (String)"ImportKnowledgeTask_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
            this.createKnlObj(knlId, fileName, fileType, this.isQAKnl, content, this.entityNumber, this.currentUserId, fileHash, ocrParse[0]);
        }
        catch (Exception e) {
            this.errorInfos.add(fileName + ":" + e.getMessage());
            log.error(fileName + " parse error:", (Throwable)e);
        }
        ++this.progressCount;
    }

    private void handleZipFileImport(Map<String, List<Map<String, String>>> zipFileInfos, String msg) {
        for (Map.Entry<String, List<Map<String, String>>> entry : zipFileInfos.entrySet()) {
            if (this.getStop()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u4e2d\u6b62\u3002", (String)"ImportKnowledgeTask_21", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            String zipUrl = entry.getKey();
            String zipName = this.zipFileUrlNameMap.getOrDefault(zipUrl, "");
            List<Map<String, String>> singleZipFileInfos = entry.getValue();
            Map<String, Map> filePathInfoMap = singleZipFileInfos.stream().collect(Collectors.toMap(k -> (String)k.get("relativepath"), v -> v));
            try {
                InputStream inputStream = cache.getInputStream(zipUrl);
                Throwable throwable = null;
                try {
                    ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream(inputStream);
                    Throwable throwable2 = null;
                    try {
                        ZipArchiveEntry zipEntry;
                        while ((zipEntry = zipInputStream.getNextZipEntry()) != null) {
                            String relativePath;
                            String string = relativePath = zipEntry.getName().contains("?") ? new String(zipEntry.getRawName(), "GBK") : zipEntry.getName();
                            if (!filePathInfoMap.containsKey(relativePath)) continue;
                            Map fileInfo = filePathInfoMap.get(relativePath);
                            InputStream in = KnowledgeUtils.copyInputStream((InputStream)zipInputStream);
                            this.handleFileImport(fileInfo, in, msg);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (zipInputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                zipInputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        zipInputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                log.error(zipName + " import error:", (Throwable)e);
                this.errorInfos.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u4e0a\u4f20\u6587\u4ef6\u5b58\u5728\u95ee\u9898\uff1a%2$s", (String)"ImportKnowledgeTask_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), zipName, e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                log.error(zipName + " parse file error:", (Throwable)e);
                this.errorInfos.add(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6587\u4ef6\u89e3\u6790\u5b58\u5728\u95ee\u9898\uff1a%2$s", (String)"ImportKnowledgeTask_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), zipName, e.getMessage()));
            }
        }
    }

    private void createKnlObj(Long knlId, String fileName, String fileType, boolean isQAKnl, String content, String entityNumber, Long currUserId, String fileHash, boolean ocrParse) {
        OperationResult result;
        boolean success;
        BaseModel baseModel = new BaseModel(entityNumber, "", new HashMap(0));
        DynamicObject knlObj = (DynamicObject)baseModel.createNewData();
        knlObj.set("id", (Object)knlId);
        knlObj.set("name", (Object)fileName);
        knlObj.set("number", (Object)this.generateKnlNumber(fileType, knlId));
        knlObj.set("status", (Object)"A");
        knlObj.set("uploadstatus", (Object)"I");
        String type = KnowledgeUtils.getSplitTypeByExtention(fileType, isQAKnl);
        knlObj.set("type", (Object)type);
        knlObj.set("filehash", (Object)fileHash);
        knlObj.set("creator_id", (Object)currUserId);
        knlObj.set("enableocr", (Object)ocrParse);
        if (StringUtils.isNotBlank((CharSequence)this.groupId)) {
            knlObj.set("group_id", (Object)this.groupId);
        }
        if (null != this.useOrgId && 0L != this.useOrgId) {
            knlObj.set("org_id", (Object)this.useOrgId);
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            knlObj.set("inputcontent_tag", (Object)content);
        }
        if (success = (result = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])new DynamicObject[]{knlObj}, (OperateOption)option)).isSuccess()) {
            ++this.successCount;
        } else {
            List infos = result.getAllErrorOrValidateInfo();
            if (!infos.isEmpty()) {
                this.errorInfos.add(((IOperateInfo)infos.get(0)).getMessage());
            }
        }
    }

    private String generateKnlNumber(String fileType, Long knlId) {
        StringBuilder preffix = new StringBuilder();
        if ("java".equalsIgnoreCase(fileType)) {
            preffix.append("jv-");
            preffix.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("-").append(String.format("%07d", new SecureRandom().nextInt(10000000)));
        } else if ("ts".equalsIgnoreCase(fileType)) {
            preffix.append("ks-");
            preffix.append(LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append("-").append(String.format("%07d", new SecureRandom().nextInt(10000000)));
        } else {
            preffix.append("doc-").append(knlId);
        }
        return preffix.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream copyInputStream(InputStream in) {
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int len;
            while ((len = in.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String uploadAttachmentFile(String fileName, String fileType, InputStream in) throws IOException {
        if (!forbiddenExtensions.contains(fileType)) {
            String uploadPath = ImportKnowledgeTask.getKnlFileUploadPath(fileName);
            FileItem fileItem = new FileItem(fileName, uploadPath, in);
            if (StringUtils.isBlank((CharSequence)(uploadPath = fileService.upload(fileItem)))) {
                String message = fileName + "\uff1a" + ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u670d\u52a1\u540e\u91cd\u8bd5\u3002", (String)"ImportKnowledgeTask_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.errorInfos.add(message);
                log.error(message);
                return "";
            }
            in.reset();
            return uploadPath;
        }
        return "";
    }

    private void saveAttachmentInfo(String entityNumber, String fileName, Long knlPkId, String filePath, long size) {
        HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
        attachmentMap.put("name", fileName);
        attachmentMap.put("entityNum", entityNumber);
        attachmentMap.put("billPkId", knlPkId);
        attachmentMap.put("size", size);
        attachmentMap.put("status", "success");
        attachmentMap.put("lastModified", new Date().getTime());
        attachmentMap.put("url", filePath);
        AttachmentServiceHelper.upload((String)entityNumber, (Object)knlPkId, (String)"attachmentpanelap", Collections.singletonList(attachmentMap));
    }

    private static String getKnlFileUploadPath(String fileName) {
        String tenantId;
        RequestContext requestContext = RequestContext.get();
        if (null == requestContext) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25\u3002", (String)"ImportKnowledgeTask_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)(tenantId = requestContext.getTenantId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u79df\u6237ID\u3002", (String)"ImportKnowledgeTask_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String accountId = requestContext.getAccountId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"ImportKnowledgeTask_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        return rootPath + String.format("/%s/%s/%s/%s", tenantId, accountId, formatDate, fileName);
    }

    private String parseFileContent(String fileType, InputStream in, String url, String entityNumber, boolean isQAKnl, boolean[] ocrParse) {
        String content;
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return "";
        }
        DocParser parser = FileParseFactory.getParser(fileType, StringUtils.isBlank((CharSequence)entityNumber) ? "" : entityNumber);
        parser.setSplitType(KnowledgeUtils.getSplitTypeByExtention(fileType, isQAKnl));
        ocrParse[0] = this.enableOcr && this.fileTypes.contains(fileType);
        parser.setEnableOCR(ocrParse[0]);
        try {
            content = parser.parse(in, url, (ParseListener)this);
        }
        catch (IOException e) {
            throw new KDBizException(e.toString());
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportKnowledgeTask_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String warnMsg = parser.getWarnMsg();
        if (StringUtils.isNotBlank((CharSequence)warnMsg)) {
            this.warnInfos.add(warnMsg);
        }
        return content;
    }

    public boolean getStop() {
        return this.isStop();
    }

    public void updateProgress(String progress) {
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\u4efd\u6587\u6863\uff1a%3$s", (String)"ImportKnowledgeTask_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        this.feedbackProgress(this.progressPercent, String.format(msg, this.progressCount, this.fileCount, progress), null);
    }

    static {
        cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        fileService = FileServiceFactory.getAttachmentFileService();
        forbiddenExtensions = fileService.getForbiddenExtensions();
        forbiddenExtensions.add("java");
        forbiddenExtensions.add("ts");
        option = OperateOption.create();
        option.setVariableValue("isNeedSplit", "true");
    }
}

