/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.commonutils.ChunkUtils;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.knowledge.KMTemplateOpPlugin;
import kd.bos.gptas.kmbase.progress.KnlProgress;
import kd.bos.gptas.kmbase.progress.KnlProgressBuilder;
import kd.bos.gptas.kmbase.service.KMVectorSaveTask;
import kd.bos.gptas.kmbase.service.KnowledgeVectorService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMTemplateAuditOpPlugin
extends KMTemplateOpPlugin {
    private static final Log log = LogFactory.getLog(KMTemplateAuditOpPlugin.class);
    private KnowledgeVectorService vectorService;

    public void initialize(InitOperationArgs e) {
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(this.billEntityType.getName());
        this.vectorService = KnowledgeVectorService.create(splitConfig.getEmbeddingModel());
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("inputcontent_tag");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("group.id");
        e.getFieldKeys().add("segmententity");
        e.getFieldKeys().add("segmententity.id");
        e.getFieldKeys().add("segmententity.segment_tag");
        e.getFieldKeys().add("segmententity.segmenttype");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        this.insert2VectorLib(e.getDataEntities(), this.billEntityType.getName());
    }

    private void insert2VectorLib(DynamicObject[] dynamicObjects, String entityNumber) {
        ArrayList list = new ArrayList(16);
        Map variables = this.getOption().getVariables();
        for (Map.Entry kv : variables.entrySet()) {
            if (!((String)kv.getKey()).startsWith("handlerclass")) continue;
            list.add(kv.getValue());
        }
        KMVectorSaveTask.start(entityNumber, dynamicObjects, list.toArray(new String[0]));
        if (variables.containsKey("pageId")) {
            String pageId = (String)variables.get("pageId");
            new KnlProgressBuilder().start(pageId);
        }
    }

    private void insert2VectorLib_Bak(DynamicObject[] dynamicObjects, String entityNumber) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(dynamicObjects.length);
        boolean isGroupKM = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties().containsKey((Object)"group");
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long groupId = 0L;
            if (isGroupKM) {
                groupId = dynamicObject.getLong("group.id");
            }
            DynamicObjectCollection segmentEntities = dynamicObject.getDynamicObjectCollection("segmententity");
            for (DynamicObject segmentRow : segmentEntities) {
                Chunk chunk = new Chunk();
                chunk.setId(Long.valueOf(segmentRow.getLong("id")));
                chunk.setEntityId(entityNumber);
                chunk.setKnowledgeId(Long.valueOf(dynamicObject.getLong("id")));
                chunk.setContent(segmentRow.getString("segment_tag"));
                chunk.setChunkType(segmentRow.getString("segmenttype"));
                chunk.setGroupId(groupId);
                chunks.add(chunk);
            }
        }
        String taskId = null;
        try {
            taskId = this.vectorService.submitSaveTaskForKnl(chunks, vectorKnowledgeModels -> ChunkUtils.batchSaveCallBack(this.vectorService, entityNumber, vectorKnowledgeModels));
            new KnlProgress(entityNumber).putTaskIdToCache(taskId);
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("pageId")) {
                String pageId = (String)variables.get("pageId");
                new KnlProgressBuilder().start(pageId);
            }
        }
        catch (Exception e) {
            Map objectMap = BusinessDataReader.loadFromCache((Object[])chunks.stream().map(Chunk::getKnowledgeId).toArray(Long[]::new), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(objectMap.size());
            for (Map.Entry entry : objectMap.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                value.set("uploadstatus", (Object)"F");
                String msg = "traceId is :" + RequestContext.get().getTraceId() + "," + e.getMessage();
                value.set("failmsg", (Object)(msg.length() > 200 ? msg.substring(0, 200) : msg));
                dynamicObjectList.add(value);
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        }
    }
}

