/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.progress.KnlProgress;
import kd.bos.gptas.kmbase.progress.KnlProgressBuilder;
import kd.bos.gptas.kmbase.service.KnowledgeVectorService;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class KMTemplateListPlugin
extends AbstractListPlugin {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final String FILTER_COLUMN_USEORG_FIELD = "org.id";
    private static final String USEORG = "useOrg";
    private static final String CALLBACK_TASK_IMPORT_KNL = "taskImportKnl";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"importknl", "importqa", "kmconfig"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterColumn filterColumn = args.getFilterColumn(FILTER_COLUMN_USEORG_FIELD);
        if (null != filterColumn) {
            Object defaultOrgId;
            List defaultValues = filterColumn.getDefaultValues();
            if (null != defaultValues && !defaultValues.isEmpty() && StringUtils.isNotBlank(defaultOrgId = defaultValues.get(0))) {
                this.getPageCache().put(USEORG, defaultOrgId.toString());
                return;
            }
            filterColumn.setDefaultValue(String.valueOf(RequestContext.get().getOrgId()));
        }
        this.getPageCache().put(USEORG, String.valueOf(RequestContext.get().getOrgId()));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Object filterValue = args.getFilterValue(FILTER_COLUMN_USEORG_FIELD);
        if (StringUtils.isNotBlank((Object)filterValue)) {
            this.getPageCache().put(USEORG, filterValue.toString());
        } else {
            this.getPageCache().put(USEORG, String.valueOf(RequestContext.get().getOrgId()));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "tblnew": 
            case "importknl": 
            case "importqa": {
                Map focusNode;
                TreeView treeView = (TreeView)this.getControl("treeview");
                if (null != treeView && (null == (focusNode = treeView.getTreeState().getFocusNode()) || !focusNode.containsKey("parentid") || StringUtils.isBlank((CharSequence)focusNode.get("parentid").toString()))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u975e\u6839\u8282\u70b9\u3002", (String)"KMTemplateListPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String entityNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                boolean isKmInitialized = QueryServiceHelper.exists((String)"bos_knl_kmconfig", (QFilter[])new QFilter[]{new QFilter("kmformid.number", "=", (Object)entityNumber)});
                if (isKmInitialized) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u77e5\u8bc6\u5e93\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u6267\u884c\u201c\u521d\u59cb\u5316\u77e5\u8bc6\u5e93\u201d\u3002", (String)"KMTemplateListPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "importqa": {
                this.openImportKnowledgeForm(true);
                break;
            }
            case "importknl": {
                this.openImportKnowledgeForm(false);
                break;
            }
            case "kmconfig": {
                this.openKMConfigForm();
                break;
            }
            case "btnprogressinquiry": {
                this.progressInquiry();
                break;
            }
            case "hittest": {
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("bos_km_hittest");
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                String entityNumber = ((ListView)this.getView()).getBillFormId();
                if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                    fsp.setCustomParam("entityid", (Object)entityNumber);
                }
                fsp.setCustomParam("source", (Object)"entity");
                this.getView().showForm(fsp);
                break;
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        String useOrg = this.getPageCache().get(USEORG);
        if (StringUtils.isNotBlank((CharSequence)useOrg)) {
            parameter.setCustomParam(USEORG, (Object)useOrg);
        }
    }

    private void progressInquiry() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(formShowParameter.getBillFormId());
        KnowledgeVectorService vectorService = KnowledgeVectorService.create(splitConfig.getEmbeddingModel());
        KnlProgress knlProgress = new KnlProgress(formShowParameter.getBillFormId());
        if (knlProgress.getAliveTaskInfo().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u4e0a\u4f20\u6570\u636e\u3002", (String)"KMTemplateListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            ((ListView)this.getView()).refresh();
            return;
        }
        new KnlProgressBuilder().showPage(this.getView());
    }

    public void afterBindData(EventObject e) {
        this.updateKMConfigButtonMetadata();
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if (operationKey.equals("audit")) {
            OperateOption option = operate.getOption();
            option.setVariableValue("pageId", this.getView().getPageId());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("importknl".equals(operateKey) || "importqa".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String callBackId = evt.getActionId();
        if ("kmconfig".equals(callBackId)) {
            this.updateKMConfigButtonMetadata();
        } else if (CALLBACK_TASK_IMPORT_KNL.equals(callBackId)) {
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map) {
                Map returnDataMap = (Map)returnData;
                if (!returnDataMap.containsKey("taskinfo")) {
                    return;
                }
                String taskInfoStr = (String)returnDataMap.get("taskinfo");
                TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
                if (!taskInfo.isTaskEnd()) {
                    return;
                }
                String data = taskInfo.getData();
                if (StringUtils.isBlank((CharSequence)data)) {
                    return;
                }
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                Object isSuccess = dataMap.get("success");
                List errorInfos = dataMap.getOrDefault("errorInfos", new ArrayList(0));
                List warnInfos = dataMap.getOrDefault("warnInfos", new ArrayList(0));
                int fileCount = dataMap.getOrDefault("importFileCount", 0);
                int successCount = dataMap.getOrDefault("successCount", 0);
                if ("true".equals(isSuccess)) {
                    String title = ResManager.loadKDString((String)"\u77e5\u8bc6\u5bfc\u5165\u5b8c\u6210\u3002", (String)"KMTemplateListPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                    if (warnInfos.isEmpty()) {
                        this.getView().showSuccessNotification(title);
                    } else {
                        this.getView().showMessage(title, String.join((CharSequence)"\n", warnInfos), MessageTypes.Default);
                    }
                } else {
                    String titile = String.format(ResManager.loadKDString((String)"\u77e5\u8bc6\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5931\u8d25%2$s\u6761\u3002", (String)"KMTemplateListPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), successCount, fileCount - successCount);
                    this.getView().showMessage(titile, String.join((CharSequence)"\n", CollectionUtils.union((Iterable)errorInfos, (Iterable)warnInfos)), MessageTypes.Default);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void openImportKnowledgeForm(boolean isQAKnl) {
        String focusNodeId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("import_knowledge");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        showParameter.setCustomParam("isQAKnl", (Object)(isQAKnl ? "true" : "false"));
        showParameter.setCustomParam("entityNumber", (Object)entityNumber);
        if (isQAKnl) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u95ee\u7b54\u5bf9", (String)"KMTemplateListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = entityType.getProperties();
        TreeView treeView = (TreeView)this.getControl("treeview");
        boolean isGroupKM = properties.containsKey((Object)"group");
        if (isGroupKM && null != treeView && StringUtils.isNotBlank((CharSequence)(focusNodeId = treeView.getTreeState().getFocusNodeId()))) {
            showParameter.setCustomParam("groupId", (Object)focusNodeId);
        }
        boolean isOrgKM = properties.containsKey((Object)"org");
        String useOrg = this.getPageCache().get(USEORG);
        if (isOrgKM && StringUtils.isNotBlank((CharSequence)useOrg)) {
            showParameter.setCustomParam(USEORG, (Object)useOrg);
        }
        this.getView().showForm(showParameter);
    }

    private void openKMConfigForm() {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        DynamicObject kmConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_knl_kmconfig", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        BillShowParameter bsp = new BillShowParameter();
        bsp.setFormId("bos_knl_kmconfig");
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        if (null != kmConfig) {
            bsp.setPkId(kmConfig.getPkValue());
            bsp.setBillStatus(BillOperationStatus.EDIT);
            bsp.setStatus(OperationStatus.EDIT);
        } else {
            bsp.setBillStatus(BillOperationStatus.ADDNEW);
            bsp.setStatus(OperationStatus.ADDNEW);
        }
        bsp.setCustomParam("entityNumber", (Object)formId);
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "kmconfig"));
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void updateKMConfigButtonMetadata() {
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        DynamicObject knlConfig = QueryServiceHelper.queryOne((String)"bos_knl_kmconfig", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)});
        if (null != knlConfig) {
            HashMap<String, String> nameMap = new HashMap<String, String>(1);
            nameMap.put("zh_CN", "\u77e5\u8bc6\u5e93\u914d\u7f6e");
            HashMap<String, HashMap<String, String>> metadataMap = new HashMap<String, HashMap<String, String>>(1);
            metadataMap.put("text", nameMap);
            this.getView().updateControlMetadata("kmconfig", metadataMap);
        }
    }
}

