/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.knowledge;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.service.KnowledgeVectorService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMTemplateUnauditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(KMTemplateUnauditOpPlugin.class);
    private KnowledgeVectorService vectorService;

    public void initialize(InitOperationArgs e) {
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(this.billEntityType.getName());
        this.vectorService = KnowledgeVectorService.create(splitConfig.getEmbeddingModel());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("failmsg");
        e.getFieldKeys().add("uploadstatus");
        e.getFieldKeys().add("segmententity");
        e.getFieldKeys().add("segmententity.id");
        e.getFieldKeys().add("segmententity.hasgenindex");
        e.getFieldKeys().add("segmententity.segment_tag");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.deleteKnlFromMilvus(e.getDataEntities());
    }

    private void deleteKnlFromMilvus(DynamicObject[] dyObjs) {
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<DynamicObject> delObject = new ArrayList<DynamicObject>();
        for (DynamicObject dy : dyObjs) {
            try {
                boolean hasGenIndex = false;
                DynamicObjectCollection segmengEntities = dy.getDynamicObjectCollection("segmententity");
                for (DynamicObject segmentRow : segmengEntities) {
                    idList.add(segmentRow.getLong("id"));
                    boolean contains = segmentRow.containsProperty("hasgenindex");
                    if (hasGenIndex || !contains || !segmentRow.getBoolean("hasgenindex")) continue;
                    hasGenIndex = true;
                }
                this.initField(dy, hasGenIndex);
                delObject.add(dy);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        this.vectorService.delete(this.billEntityType.getName(), idList);
        SaveServiceHelper.update((DynamicObject[])delObject.toArray(new DynamicObject[0]));
    }

    private void initField(DynamicObject dyObj, boolean hasGenIndex) {
        dyObj.set("failmsg", (Object)"");
        if (hasGenIndex) {
            dyObj.set("uploadstatus", (Object)"G");
        } else {
            dyObj.set("uploadstatus", (Object)"I");
        }
    }
}

