/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.newsplitter.ISplitterService;
import kd.bos.gptas.kmbase.newsplitter.result.SplitResult;
import kd.bos.gptas.kmbase.newsplitter.utils.ExcelSplitter;

public class ExcelSplitterServiceImpl
implements ISplitterService {
    @Override
    public List<Object> split(String content, int chunkSize) {
        return Collections.emptyList();
    }

    @Override
    public List<Object> split(String content, int chunkSize, SplitConfig config) {
        config.setSeparators("\\|," + config.getSeparators());
        ExcelSplitter excelSplitter = new ExcelSplitter(config);
        List<LinkedHashMap<String, String>> qaArray = excelSplitter.parseArray(content);
        if (qaArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        for (LinkedHashMap<String, String> map : qaArray) {
            StringBuilder buffer = new StringBuilder();
            int index = 0;
            int size = map.entrySet().size();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value = entry.getValue();
                buffer.append(value);
                if (index != size - 1) {
                    buffer.append("|");
                }
                ++index;
            }
            if (buffer.toString().length() > config.getChunkSize()) {
                List<Object> objects = excelSplitter.doTextSplit(buffer.toString(), 0);
                for (Object object : objects) {
                    SplitResult excelSplitResult = new SplitResult();
                    excelSplitResult.setContent((String)object);
                    excelSplitResult.setExtendContent(buffer.toString());
                    results.add(excelSplitResult);
                }
                continue;
            }
            SplitResult excelSplitResult = new SplitResult();
            excelSplitResult.setContent(buffer.toString());
            excelSplitResult.setExtendContent(buffer.toString());
            results.add(excelSplitResult);
        }
        return results;
    }
}

