/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.newsplitter.ISplitterService;
import kd.bos.gptas.kmbase.newsplitter.result.SplitResult;
import kd.bos.gptas.kmbase.newsplitter.utils.ExcelSplitter;
import org.apache.commons.lang3.StringUtils;

public class QASplitterServiceImpl
implements ISplitterService {
    private static final String SYSTEM = "bos-gptas-km";

    @Override
    public List<Object> split(String content, int chunkSize) {
        return Collections.emptyList();
    }

    @Override
    public List<Object> split(String content, int chunkSize, SplitConfig config) {
        ExcelSplitter excelSplitter = new ExcelSplitter(config);
        List<LinkedHashMap<String, String>> qaArray = excelSplitter.parseArray(content);
        if (qaArray == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> objects = new ArrayList<Object>(qaArray.size());
        for (int i = 0; i < qaArray.size(); ++i) {
            LinkedHashMap<String, String> map = qaArray.get(i);
            String question = map.get("Q");
            String answer = map.get("A");
            if (StringUtils.isBlank((CharSequence)question)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u95ee\u7b54\u5bf9\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u3002key\u503c\uff1a%s\u3002", (String)"QASplitterServiceImpl_0", (String)SYSTEM, (Object[])new Object[0]), map.keySet()));
            }
            if (question.length() >= config.getChunkSize()) continue;
            if (config.isSplitByQ()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Q", (Object)question);
                objects.add(this.createSplitResult(jsonObject.toJSONString(), answer, "Q"));
            }
            if (!config.isSplitByQA()) continue;
            String builder = question + answer;
            if (builder.length() <= config.getChunkSize()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Q", (Object)question);
                jsonObject.put("A", (Object)answer);
                objects.add(this.createSplitResult(jsonObject.toJSONString(), answer, "QA"));
                continue;
            }
            List<Object> split = excelSplitter.doTextSplit(answer, question.length());
            for (Object object : split) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Q", (Object)question);
                jsonObject.put("A", object);
                objects.add(this.createSplitResult(jsonObject.toJSONString(), answer, "QA"));
            }
        }
        return objects;
    }

    private SplitResult createSplitResult(String content, String answer, String segmentType) {
        SplitResult result = new SplitResult();
        result.setContent(content);
        result.setExtendContent(answer);
        result.setSegmentType(segmentType);
        return result;
    }
}

