/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.newsplitter.utils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.newsplitter.impl.TextSplitterServiceImpl;
import kd.bos.gptas.kmbase.newsplitter.utils.RecursiveCharacterTextSplitter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ExcelSplitter {
    private static final Log logger = LogFactory.getLog(ExcelSplitter.class);
    private final SplitConfig config;

    public ExcelSplitter(SplitConfig config) {
        this.config = config;
    }

    public List<Object> doTextSplit(String content, int length) {
        RecursiveCharacterTextSplitter recursiveCharacterTextSplitter = new RecursiveCharacterTextSplitter();
        recursiveCharacterTextSplitter.setChunkSize(this.config.getChunkSize() != 0 ? this.config.getChunkSize() - length : 300);
        recursiveCharacterTextSplitter.setChunkOverlap(this.config.getChunkover());
        recursiveCharacterTextSplitter.setSeparators(Arrays.asList(this.config.getSeparators().split(",")));
        recursiveCharacterTextSplitter.setKeepSeparator(false);
        return new TextSplitterServiceImpl(recursiveCharacterTextSplitter).split(content, 0);
    }

    public List<LinkedHashMap<String, String>> parseArray(String content) {
        try {
            return (List)SerializationUtils.fromJsonString((String)content, List.class);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u683c\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"ExcelSplitter_0", (String)"bos-gptas-km", (Object[])new Object[0]));
        }
    }
}

