/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import java.io.IOException;
import java.io.InputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.DocParser;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.gptas.kmbase.service.OCRService;
import kd.bos.gptas.utils.SystemPropertyUtils;

public abstract class AbstractParser
implements DocParser {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    protected boolean enableOcr = false;

    public AbstractParser() {
        String tenantId = RequestContext.get().getTenantId();
        this.enableOcr = "true".equals(SystemPropertyUtils.getProptyByTenant((String)"bos.gptas.parser.enableOcr", (String)tenantId));
    }

    public void setEnableOCR(boolean enableOcr) {
        this.enableOcr = enableOcr;
    }

    public boolean isEnableOCR() {
        return this.enableOcr;
    }

    public String parse(InputStream in, String url, ParseListener listener) throws IOException {
        if (this.enableOcr) {
            OCRService ocrService = OCRService.create();
            if (ocrService.checkOCRAvailable()) {
                return ocrService.ocrParse(url, listener);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6eOCR\u670d\u52a1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u3002", (String)"AbstractParser_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        return this.parseText(in);
    }

    public abstract String parseText(InputStream var1) throws IOException;
}

