/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.gptas.kmbase.parser.PDFDocumentSplitter;
import kd.bos.gptas.kmbase.parser.WordDocumentSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentSplitter {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final Logger log = LoggerFactory.getLogger(DocumentSplitter.class);
    private static final FileService fileService = FileServiceFactory.getAttachmentFileService();
    private final int splitPages;
    private final String url;
    private final List<String> splitUrls = new ArrayList<String>(16);
    private final PushbackInputStream inputStream;

    public DocumentSplitter(String url, PushbackInputStream pushbackInputStream, int splitPages) {
        this.url = url;
        this.inputStream = pushbackInputStream;
        if (splitPages < 1) {
            throw new IllegalArgumentException();
        }
        this.splitPages = splitPages;
    }

    private static PushbackInputStream getInputStream(String url) {
        if (fileService.exists(url)) {
            return new PushbackInputStream(fileService.getInputStream(url), 8);
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        if (tempFileCache.exists(url)) {
            return new PushbackInputStream(tempFileCache.getInputStream(url), 8);
        }
        return null;
    }

    public List<String> split() {
        try {
            if (this.inputStream == null) {
                return Collections.singletonList(this.url);
            }
            List<InputStream> list = this.doSplit(this.inputStream);
            if (list.size() <= 1) {
                return Collections.singletonList(this.url);
            }
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (InputStream inputStreamSplit : list) {
                long k = System.currentTimeMillis();
                String newUrl = this.uploadAttachmentFile("DocuemtSplitter_" + k + "." + this.getFileType(), this.getFileType(), inputStreamSplit);
                if (newUrl.isEmpty()) {
                    return Collections.singletonList(this.url);
                }
                result.add(newUrl);
            }
            this.splitUrls.addAll(result);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract List<InputStream> doSplit(PushbackInputStream var1) throws Exception;

    protected abstract String getFileType();

    private static String getKnlFileUploadPath(String fileName) {
        String tenantId;
        RequestContext requestContext = RequestContext.get();
        if (null == requestContext) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25\u3002", (String)"ImportKnowledgeTask_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)(tenantId = requestContext.getTenantId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u79df\u6237ID\u3002", (String)"ImportKnowledgeTask_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String accountId = requestContext.getAccountId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"ImportKnowledgeTask_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        return rootPath + String.format("/%s/%s/%s/%s", tenantId, accountId, formatDate, fileName);
    }

    protected String uploadAttachmentFile(String fileName, String fileType, InputStream in) throws IOException {
        String uploadPath = DocumentSplitter.getKnlFileUploadPath(fileName);
        FileItem fileItem = new FileItem(fileName, uploadPath, in);
        if (StringUtils.isBlank((CharSequence)(uploadPath = fileService.upload(fileItem)))) {
            String message = fileName + "\uff1a" + ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u670d\u52a1\u540e\u91cd\u8bd5\u3002", (String)"ImportKnowledgeTask_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            log.error(message);
            return "";
        }
        in.reset();
        return uploadPath;
    }

    public void close() {
        for (String splitUrl : this.splitUrls) {
            fileService.delete(splitUrl);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public int getSplitPages() {
        return this.splitPages;
    }

    public static DocumentSplitter create(String url, int splitPages) throws IOException {
        PushbackInputStream inputStream = DocumentSplitter.getInputStream(url);
        if (inputStream == null) {
            return null;
        }
        if (DocumentSplitter.isPDF(inputStream)) {
            return new PDFDocumentSplitter(url, inputStream, splitPages);
        }
        if (DocumentSplitter.isDocHeader(inputStream)) {
            return new WordDocumentSplitter(url, inputStream, splitPages);
        }
        if (DocumentSplitter.isDocxHeader(inputStream)) {
            return new WordDocumentSplitter(url, inputStream, splitPages);
        }
        return null;
    }

    private static boolean isDocxHeader(PushbackInputStream inputStream) throws IOException {
        byte[] header = new byte[2];
        int bytesRead = inputStream.read(header);
        if (bytesRead != 2) {
            inputStream.close();
            return false;
        }
        inputStream.unread(header);
        return header[0] == 80 && header[1] == 75;
    }

    private static boolean isDocHeader(PushbackInputStream inputStream) throws IOException {
        byte[] header = new byte[8];
        int bytesRead = inputStream.read(header);
        if (bytesRead != 8) {
            inputStream.close();
            return false;
        }
        inputStream.unread(header);
        return header[0] == -48 && header[1] == -49 && header[2] == 17 && header[3] == -32 && header[4] == -95 && header[5] == -79 && header[6] == 26 && header[7] == -31;
    }

    private static boolean isPDF(PushbackInputStream inputStream) throws IOException {
        byte[] header = new byte[4];
        int bytesRead = inputStream.read(header);
        if (bytesRead != 4) {
            inputStream.close();
            return false;
        }
        inputStream.unread(header);
        return new String(header).equals("%PDF");
    }

    static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        MyByteArrayOutputStream() {
        }

        public InputStream newInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

