/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.parser;

import com.aspose.words.Document;
import com.aspose.words.License;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.kmbase.parser.DocumentSplitter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

class WordDocumentSplitter
extends DocumentSplitter {
    private static final Log logger;

    static String decrypt(String base64Content, String encryptPass) {
        try {
            byte[] content = Base64.getDecoder().decode(base64Content);
            if (content.length < 28) {
                throw new IllegalArgumentException();
            }
            GCMParameterSpec params = new GCMParameterSpec(128, content, 0, 12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)WordDocumentSplitter.getSecretKey(encryptPass), params);
            byte[] decryptData = cipher.doFinal(content, 12, content.length - 12);
            return new String(decryptData, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return "";
        }
    }

    private static SecretKeySpec getSecretKey(String encryptPass) throws NoSuchAlgorithmException {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptPass.getBytes());
        kg.init(128, secureRandom);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), "AES");
    }

    static String decodeDefault(String text) {
        return WordDocumentSplitter.decrypt(Encrypters.decode((String)text), Encrypters.decode((String)"d@f*g:SGVsbG8===AOR3umRGun+8y3j2mPZejSvj4HD9Dv3J3zlBr5de/DdwbZty1qEqESRa2RwYXNzd29yZA=="));
    }

    public WordDocumentSplitter(String url, PushbackInputStream inputStream, int splitPages) {
        super(url, inputStream, splitPages);
    }

    @Override
    protected List<InputStream> doSplit(PushbackInputStream inputStream) throws Exception {
        Document sourceDoc = new Document((InputStream)inputStream);
        int pageCount = sourceDoc.getPageCount();
        if (pageCount <= this.getSplitPages()) {
            return Collections.singletonList(inputStream);
        }
        ArrayList<InputStream> list = new ArrayList<InputStream>(16);
        for (int i = 0; i < pageCount; i += this.getSplitPages()) {
            Document newPage = sourceDoc.extractPages(i, Math.min(pageCount - i, this.getSplitPages()));
            DocumentSplitter.MyByteArrayOutputStream myByteArrayOutputStream = new DocumentSplitter.MyByteArrayOutputStream();
            newPage.save((OutputStream)myByteArrayOutputStream, sourceDoc.getOriginalLoadFormat());
            list.add(myByteArrayOutputStream.newInputStream());
        }
        return list;
    }

    @Override
    protected String getFileType() {
        return "docx";
    }

    static {
        block48: {
            logger = LogFactory.getLog(WordDocumentSplitter.class);
            ByteArrayInputStream inputStream = null;
            try (InputStream resourceAsStream = WordDocumentSplitter.class.getResourceAsStream("/Aspose.Words.Product.Family.lic");
                 InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line;
                StringBuilder stringBuilder = new StringBuilder();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
                String licStr = WordDocumentSplitter.decodeDefault(stringBuilder.toString());
                if (StringUtils.isNotEmpty((String)licStr)) {
                    inputStream = new ByteArrayInputStream(licStr.getBytes(StandardCharsets.UTF_8));
                    License license = new License();
                    license.setLicense((InputStream)inputStream);
                    break block48;
                }
                throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u3001wps\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpWordUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("aspose \u8bb8\u53ef\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"doc\u3001docx\u3001wps\u6587\u6863\u5904\u7406\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CvpWordUtils_001", (String)"ai-cvp-common", (Object[])new Object[0]));
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error("aspose \u8bb8\u53ef\u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
    }
}

