/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.progress;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.gptas.api.vector.VectorTask;
import kd.bos.gptas.kmbase.service.KMVectorSaveTask;
import kd.bos.gptas.kmbase.service.KnowledgeVectorService;
import kd.bos.gptas.kmbase.service.VectorSaveTaskInfo;
import org.apache.commons.lang3.StringUtils;

public class KnlProgress {
    public static final String PROGRESS_TASK_ID = "progress_task_Key";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private final String formId;

    public KnlProgress(String formId) {
        this.formId = formId;
    }

    public void putTaskIdToCache(String taskId) {
        String taskFromCache = this.getTaskFromCache();
        if (StringUtils.isNotBlank((CharSequence)taskFromCache)) {
            taskId = taskFromCache + "," + taskId;
        }
        cache.put(this.getCacheKey(PROGRESS_TASK_ID), (Object)taskId);
    }

    public String[] getTaskArray() {
        String taskStr = this.getTaskFromCache();
        if (StringUtils.isNotBlank((CharSequence)taskStr)) {
            return taskStr.split(",");
        }
        return new String[0];
    }

    public void updateTaskId(List<String> taskIds) {
        if (!taskIds.isEmpty()) {
            CharSequence[] array = taskIds.toArray(new String[0]);
            String joinedTask = String.join((CharSequence)",", array);
            cache.put(this.getCacheKey(PROGRESS_TASK_ID), (Object)joinedTask);
        }
    }

    public Map<String, VectorSaveTaskInfo> getAliveTaskInfo() {
        return KMVectorSaveTask.getTaskInfo(this.formId);
    }

    public String[] getAliveTask(KnowledgeVectorService vectorService) {
        String[] taskArray = this.getTaskArray();
        ArrayList<String> unfinishedTask = new ArrayList<String>();
        boolean changed = false;
        for (String taskId : taskArray) {
            int completedKnowledgeCount;
            VectorTask vectorTask = vectorService.getSaveTask(taskId);
            int knowledgeCount = vectorTask.getKnowledgeCount();
            if (knowledgeCount != (completedKnowledgeCount = vectorTask.getCompletedKnowledgeCount())) {
                unfinishedTask.add(taskId);
                continue;
            }
            changed = true;
        }
        if (changed) {
            this.updateTaskId(unfinishedTask);
        }
        return unfinishedTask.toArray(new String[0]);
    }

    public String getTaskFromCache() {
        return (String)cache.get(this.getCacheKey(PROGRESS_TASK_ID));
    }

    private String getCacheKey(String key) {
        return RequestContext.get().getGlobalSessionId() + this.formId + key;
    }

    public static int computeProgress(int completedKnowledgeIdSize, int knowledgeIdSize) {
        return new BigDecimal(completedKnowledgeIdSize).divide(new BigDecimal(knowledgeIdSize), 3, RoundingMode.FLOOR).multiply(new BigDecimal(100)).intValue();
    }
}

