/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.progress.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.kmbase.progress.KnlProgress;
import kd.bos.gptas.kmbase.service.VectorSaveTaskInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import org.apache.commons.lang3.StringUtils;

public class KnlProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(KnlProgressPlugin.class);
    private KnlProgress knlProgress;
    private String formId;
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String TOBACKGROUD = "tobackgroud";
    private static final String BTN_SUCCESS = "btnsuccess";

    public void initialize() {
        super.initialize();
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("formId")))) {
            this.getView().showErrorNotification("initialize failed,formId is empty");
            return;
        }
        this.formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        this.knlProgress = new KnlProgress(this.formId);
    }

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressbar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{BTN_SUCCESS, TOBACKGROUD});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buttonSetUnVisible(BTN_SUCCESS);
        Map<String, VectorSaveTaskInfo> taskInfo = this.knlProgress.getAliveTaskInfo();
        if (!taskInfo.isEmpty()) {
            this.startBar();
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            int progress = this.getProgress(taskInfo);
            bar.setPercent(progress);
            if (progress >= 100) {
                this.closeAndUpdateView();
            }
        } else {
            this.startBar();
        }
    }

    private void buttonSetUnVisible(String ... keys) {
        this.getView().setVisible(Boolean.valueOf(false), keys);
    }

    public void click(EventObject evt) {
        Button button;
        Object source = evt.getSource();
        if (source instanceof Button && (TOBACKGROUD.equals((button = (Button)source).getKey()) || BTN_SUCCESS.equals(button.getKey()))) {
            this.closeAndUpdateView();
        }
    }

    private void closeAndUpdateView() {
        this.getView().close();
        if (this.getView().getParentView() == null) {
            return;
        }
        if (this.getView().getParentView() instanceof ListView) {
            ((ListView)this.getView().getParentView()).refresh();
        } else {
            this.getView().getParentView().invokeOperation("refresh");
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.start();
    }

    public void onProgress(ProgressEvent evt) {
        Map<String, VectorSaveTaskInfo> taskInfo = this.knlProgress.getAliveTaskInfo();
        if (taskInfo.isEmpty()) {
            String s = this.getPageCache().get("emptycnt");
            int cnt = StringUtils.isBlank((CharSequence)s) ? 1 : Integer.parseInt(s) + 1;
            this.getView().getPageCache().put("emptycnt", String.valueOf(cnt));
            if (cnt > 1200) {
                this.closeAndUpdateView();
            }
            return;
        }
        int progress = this.getProgress(taskInfo);
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        if (progress >= 100) {
            evt.setProgress(100);
            bar.stop();
            this.getView().addClientCallBack("closeupdateview", Integer.valueOf(200));
        } else {
            evt.setProgress(progress);
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equals("closeupdateview")) {
            this.closeAndUpdateView();
        }
    }

    private int getProgress(Map<String, VectorSaveTaskInfo> map) {
        int knowledgeIdSize = 0;
        int completedKnowledgeIdSize = 0;
        int totalsegment = 0;
        int completeseg = 0;
        for (Map.Entry<String, VectorSaveTaskInfo> kv : map.entrySet()) {
            int knowledgeCount = kv.getValue().getBillCount();
            int completedKnowledgeCount = kv.getValue().getFinishBillCount();
            int totalChunkCount = kv.getValue().getChunkCount();
            int completedChunkCount = kv.getValue().getFinishChunkCount();
            knowledgeIdSize += knowledgeCount;
            completedKnowledgeIdSize += completedKnowledgeCount;
            totalsegment += totalChunkCount;
            completeseg += completedChunkCount;
        }
        this.setCountValue(knowledgeIdSize, completedKnowledgeIdSize, totalsegment, completeseg);
        int value = KnlProgress.computeProgress(completeseg, totalsegment);
        return knowledgeIdSize == completedKnowledgeIdSize ? 100 : (value == 100 ? 99 : value);
    }

    private void setCountValue(int knowledgeIdSize, int completedKnowledgeIdSize, int totalsegment, int completeseg) {
        Label total = (Label)this.getControl("total");
        total.setText(knowledgeIdSize + "");
        Label complete = (Label)this.getControl("complete");
        complete.setText(completedKnowledgeIdSize + "");
        Label totalsegmentLabel = (Label)this.getControl("totalsegment");
        totalsegmentLabel.setText(totalsegment + "");
        Label completesegLabel = (Label)this.getControl("completeseg");
        completesegLabel.setText(completeseg + "");
    }
}

