/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;
import kd.bos.gptas.kmbase.service.EmbeddingTransactionHandler;
import kd.bos.gptas.kmbase.service.KMChunkEmbeddingHandler;
import kd.bos.gptas.kmbase.service.VectorSaveTaskInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMVectorSaveTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(KMVectorSaveTask.class);
    private static final ThreadPool threadPools = ThreadPools.newFixedThreadPool((String)KMVectorSaveTask.class.getName(), (int)10);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final Logger log = LoggerFactory.getLogger(KMVectorSaveTask.class);
    private VectorSaveTaskInfo currentTaskInfo;

    public static void start(String entityNumber, DynamicObject[] dynamicObjects, String[] handlersclass) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(new LocaleString("KMVectorSaveTask").toString());
        jobInfo.setNumber("KMVectorSaveTask_" + entityNumber);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(KMVectorSaveTask.class.getName());
        jobInfo.setCanStop(Boolean.FALSE);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("entityid", entityNumber);
        params.put("ids", Arrays.stream(dynamicObjects).map(o -> o.getLong("id")).collect(Collectors.toList()));
        params.put("handlerclass", Arrays.stream(handlersclass).collect(Collectors.toList()));
        params.put("globalsessionid", RequestContext.get().getGlobalSessionId());
        jobInfo.setParams(params);
        KMVectorSaveTask.clearFinishTaskInfo(entityNumber);
        ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
    }

    private void updateTaskInfo(String sessionid, String taskId) {
        this.currentTaskInfo.setUpdateTime(System.currentTimeMillis());
        String cacheKey = KMVectorSaveTask.getCacheKey(this.currentTaskInfo.getEntityNumber(), sessionid);
        logger.info("KMVectorSaveTask updateTaskInfo, cacheKey: {},vectorSaveTaskInfo: {}", (Object)cacheKey, (Object)this.currentTaskInfo.toString());
        cache.put(cacheKey, taskId, SerializationUtils.toJsonString((Object)this.currentTaskInfo), 2, TimeUnit.HOURS);
    }

    private static void clearFinishTaskInfo(String entityNumber) {
        String key = KMVectorSaveTask.getCacheKey(entityNumber, RequestContext.get().getGlobalSessionId());
        cache.remove(key);
    }

    public static Map<String, VectorSaveTaskInfo> getTaskInfo(String entityNumber) {
        String key = KMVectorSaveTask.getCacheKey(entityNumber, RequestContext.get().getGlobalSessionId());
        Map map = cache.getAll(key);
        logger.info("KMVectorSaveTask getTaskInfo,map\uff1a{} ,key {}: ", (Object)SerializationUtils.toJsonString((Object)map), (Object)key);
        HashMap<String, VectorSaveTaskInfo> mapResult = new HashMap<String, VectorSaveTaskInfo>(16);
        for (Map.Entry kv : map.entrySet()) {
            VectorSaveTaskInfo vectorSaveTaskInfo = (VectorSaveTaskInfo)SerializationUtils.fromJsonString((String)((String)kv.getValue()), VectorSaveTaskInfo.class);
            mapResult.put((String)kv.getKey(), vectorSaveTaskInfo);
        }
        logger.info("KMVectorSaveTask getTaskInfo, result: {}", (Object)SerializationUtils.toJsonString(mapResult));
        return mapResult;
    }

    private static String getCacheKey(String entityNumber, String sessionid) {
        return String.format("VectorSaveTask.%s.%s", entityNumber, sessionid);
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("KMVectorSaveTask,map\uff1a{}", (Object)SerializationUtils.toJsonString(map));
        String entityid = (String)map.get("entityid");
        List ids = (List)map.get("ids");
        String sessionid = (String)map.get("globalsessionid");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityid);
        Object[] datas = BusinessDataReader.load((Object[])ids.toArray(), (IDataEntityType)dataEntityType);
        List clsz = (List)map.get("handlerclass");
        ArrayList<EmbeddingTransactionHandler> list = new ArrayList<EmbeddingTransactionHandler>(16);
        list.add(new KMChunkEmbeddingHandler());
        if (clsz != null) {
            for (String s : clsz) {
                try {
                    logger.info("load handler class:" + s);
                    EmbeddingTransactionHandler saver = (EmbeddingTransactionHandler)Class.forName(s).newInstance();
                    list.add(saver);
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                }
            }
        }
        SplitConfig splitConfig = KMConfigReader.getSplitConfig(dataEntityType.getName());
        this.currentTaskInfo = new VectorSaveTaskInfo();
        this.currentTaskInfo.setBillCount(ids.size());
        this.currentTaskInfo.setEntityNumber(entityid);
        int chunkCount = 0;
        for (Object data : datas) {
            for (EmbeddingTransactionHandler handler : list) {
                chunkCount += handler.getChunkCount((DynamicObject)data);
            }
        }
        logger.info("chunkCount:{},taskInfo:{}", (Object)chunkCount, (Object)SerializationUtils.toJsonString((Object)this.currentTaskInfo));
        this.currentTaskInfo.setChunkCount(chunkCount);
        this.updateTaskInfo(sessionid, this.taskId);
        ArrayList<Future> futures = new ArrayList<Future>(16);
        for (Object o : datas) {
            Future f = threadPools.submit(() -> {
                block7: {
                    ArrayList<EmbeddingTransactionHandler> successList = new ArrayList<EmbeddingTransactionHandler>();
                    DynamicObject data = (DynamicObject)o;
                    try {
                        data.set("failmsg", (Object)("start:" + RequestContext.get().getTraceId()));
                        SaveServiceHelper.update((DynamicObject)data);
                        for (EmbeddingTransactionHandler handler : list) {
                            successList.add(handler);
                            logger.info("start handler  {} {}", (Object)handler.getClass().getName(), (Object)sessionid);
                            handler.save(entityid, splitConfig, data, count -> this.updateFinishChunkCount(sessionid, (int)count));
                            logger.info("finished handler  {} {}", (Object)handler.getClass().getName(), (Object)sessionid);
                        }
                        data.set("uploadstatus", (Object)"S");
                        data.set("failmsg", (Object)"");
                        SaveServiceHelper.update((DynamicObject)data);
                        logger.info("finished bill number: {} {}", (Object)data.getString("number"), (Object)sessionid);
                    }
                    catch (Exception ex) {
                        logger.error((Throwable)ex);
                        String msg = "";
                        try {
                            for (EmbeddingTransactionHandler handler : successList) {
                                handler.deleteAll(entityid, splitConfig, data);
                            }
                            data.set("uploadstatus", (Object)"F");
                            msg = "traceid:" + RequestContext.get().getTraceId() + ":" + this.getErrorMsg(ex);
                            if (msg.length() > 200) {
                                msg = msg.substring(0, 200);
                            }
                            data.set("failmsg", (Object)msg);
                            SaveServiceHelper.update((DynamicObject)data);
                        }
                        catch (Exception ex2) {
                            logger.error("KMVectorSaveTask error ", (Throwable)ex2);
                            if (msg.length() <= 0) break block7;
                            log.error(msg);
                        }
                    }
                }
                this.currentTaskInfo.updateFinishBillCount(1);
                logger.info("taskInfo:{}", (Object)this.currentTaskInfo.toString());
                this.updateTaskInfo(sessionid, this.taskId);
                return "OK";
            });
            futures.add(f);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("KMVectorSaveTask error ", (Throwable)e);
            }
        }
    }

    private synchronized void updateFinishChunkCount(String sessionId, int count) {
        this.currentTaskInfo.updateFinishChunkCount(count);
        this.updateTaskInfo(sessionId, this.taskId);
    }

    private String getErrorMsg(Exception ex) {
        Throwable th = ex;
        while (th.getMessage() == null && th.getCause() != null) {
            th = th.getCause();
        }
        return th.getMessage();
    }

    private void feedbackMsg(int progress, String msg) {
        this.feedbackProgress(progress);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("msg", msg);
        this.feedbackCustomdata(map);
    }
}

