/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.service;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.gptas.kmbase.service.OCRService;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCRServiceImpl
implements OCRService {
    private static final Logger log = LoggerFactory.getLogger(OCRServiceImpl.class);
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final String PROP_OCR_SERVICE_HOST = "cvp.ocr.service.host";

    @Override
    public String ocrParse(String url, ParseListener listener) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("bizTaskId", "");
        params.put("fileUrl", url);
        params.put("extractTable", true);
        params.put("extractImageInDoc", true);
        params.put("docWithSiteAndPage", false);
        params.put("tableOutType", "markdown");
        String result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"complexDocExtract", (Object[])new Object[]{params, new HashMap()});
        if (StringUtils.isBlank((CharSequence)result)) {
            throw new KDBizException(ResManager.loadKDString((String)"OCR\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff1a\u521b\u5efa\u4efb\u52a1\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"PDFParser_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        log.info("Parse file url:" + url);
        log.info("OcrService result:" + result);
        OCRService.DocExtractResult doeExtractResult = (OCRService.DocExtractResult)SerializationUtils.fromJsonString((String)result, OCRService.DocExtractResult.class);
        if (doeExtractResult.getErrorCode() != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"OCR\u4efb\u52a1\u521b\u5efa\u5931\u8d25\uff1a%s", (String)"PDFParser_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), doeExtractResult.getDescription()));
        }
        String taskId = doeExtractResult.getData();
        int timeoutMillis = 600000;
        long currentTime = System.currentTimeMillis();
        while (true) {
            if (listener.getStop()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u624b\u52a8\u4e2d\u6b62\u3002", (String)"PDFParser_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            String queryResult = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"cvp", (String)"OcrService", (String)"queryComplexDocExtractInfo", (Object[])new Object[]{taskId});
            log.info("Query Progress:" + queryResult);
            OCRService.QueryExtractInfoResult queryExtractInfoResult = (OCRService.QueryExtractInfoResult)SerializationUtils.fromJsonString((String)queryResult, OCRService.QueryExtractInfoResult.class);
            if (doeExtractResult.getErrorCode() != 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"OCR\u89e3\u6790\u5f02\u5e38\uff1a%s", (String)"PDFParser_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), queryExtractInfoResult.getDescription()));
            }
            OCRService.DocContent data = queryExtractInfoResult.getData();
            if (null == data) {
                throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u89e3\u6790\u7ed3\u679c\u5931\u8d25\uff1a\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"PDFParser_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if ("success".equals(data.getStatus())) {
                return data.getDocContent();
            }
            String progress = data.getProgress();
            if (!"success".equals(data.getStatus()) && !"running".equals(data.getStatus())) {
                throw new KDBizException(progress);
            }
            if (System.currentTimeMillis() - (long)timeoutMillis > currentTime) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4efb\u52a1\u8d85\u65f6\u3002", (String)"PDFParser_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            if (StringUtils.isNotBlank((CharSequence)progress)) {
                listener.updateProgress(progress);
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                log.warn(e.getMessage());
                continue;
            }
            break;
        }
    }

    @Override
    public boolean checkOCRAvailable() {
        String ocrServiceProp = System.getProperty(PROP_OCR_SERVICE_HOST);
        return StringUtils.isNotBlank((CharSequence)ocrServiceProp);
    }
}

