/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.vectortask;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorTaskItem;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.embedding.service.EmbeddingService;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.gptas.common.vectortask.VectorTaskManager;
import kd.bos.gptas.common.vectortask.processor.VectorBatchProcessor;
import kd.bos.gptas.common.vectortask.storage.VectorTaskStorage;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorTaskManager;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorTaskStorage;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorCache;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorModel;
import kd.bos.util.Pair;

public class KnowledgeVectorBatchProcessor
extends VectorBatchProcessor {
    private final KnowledgeVectorTaskStorage knowledgeVectorTaskStorage;
    private final KnowledgeVectorTaskManager knowledgeVectorTaskManager;

    public KnowledgeVectorBatchProcessor(KnowledgeVectorTaskManager knowledgeVectorTaskManager, EmbeddingService embeddingService, VectorStoreService vectorStoreService, KnowledgeVectorTaskStorage knowledgeVectorTaskStorage, List<VectorStorePlugin> vectorStorePlugins) {
        super((VectorTaskManager)knowledgeVectorTaskManager, embeddingService, vectorStoreService, (VectorTaskStorage)knowledgeVectorTaskStorage, vectorStorePlugins);
        this.knowledgeVectorTaskManager = knowledgeVectorTaskManager;
        this.knowledgeVectorTaskStorage = knowledgeVectorTaskStorage;
    }

    protected void processBatchWithNotify(String taskId, List<Chunk> chunks) {
        try {
            Pair processBatchResult = this.processBatch(taskId, chunks);
            List successChunks = (List)processBatchResult.getKey();
            List failedChunks = (List)processBatchResult.getValue();
            logger.info("Task {} batch processed - Success: {}, Failed: {}, Total: {}", new Object[]{taskId, successChunks.size(), failedChunks.size(), chunks.size()});
            this.knowledgeVectorTaskStorage.updateTaskProcessed(taskId, successChunks.size(), failedChunks.size(), chunks.size(), this.knowledgeVectorTaskManager.getTaskLock());
            logger.info("Updating knowledge base progress for task: {}", (Object)taskId);
            this.knowledgeVectorTaskManager.updateProcessed(taskId, successChunks, chunks);
            logger.info("Checking for completed knowledge bases in task: {}", (Object)taskId);
            List<KnowledgeVectorModel> completedVectorKnowledges = this.knowledgeVectorTaskManager.tryNotifyCompleted(taskId, chunks);
            Set<Long> completedKnowledgeIds = completedVectorKnowledges.stream().map(KnowledgeVectorModel::getKnowledgeId).collect(Collectors.toSet());
            Set<Long> successedKnowledgeIds = completedVectorKnowledges.stream().filter(vectorKnowledge -> vectorKnowledge.getCompletedChunkIds().size() == vectorKnowledge.getSuccessedChunkIds().size()).map(KnowledgeVectorModel::getKnowledgeId).collect(Collectors.toSet());
            logger.info("Task {} - Completed knowledge bases: {}, Fully successful: {}", new Object[]{taskId, completedKnowledgeIds.size(), successedKnowledgeIds.size()});
            this.knowledgeVectorTaskStorage.updateTaskProcessedForKnl(taskId, successedKnowledgeIds, completedKnowledgeIds, this.knowledgeVectorTaskManager.getTaskLock());
            if (!successChunks.isEmpty()) {
                this.knowledgeVectorTaskStorage.updateVectorTaskItemStatus(taskId, successChunks, VectorTaskItem.VectorTaskItemStatus.SUCCESS);
                logger.info("Executing success callback for task {} with {} chunks", (Object)taskId, (Object)successChunks.size());
                if (this.knowledgeVectorTaskManager.getChunkResultCallback() != null) {
                    this.knowledgeVectorTaskManager.getChunkResultCallback().accept(successChunks);
                }
            }
        }
        catch (Throwable e) {
            logger.error("Failed to process batch for task: " + taskId, e);
            this.markBatchFailed(taskId, chunks, e.getMessage());
            this.knowledgeVectorTaskStorage.updateVectorTaskItemStatus(taskId, chunks, VectorTaskItem.VectorTaskItemStatus.FAILED);
            Set knowledgeIds = chunks.stream().filter(chunk -> chunk.getKnowledgeId() != null).map(Chunk::getKnowledgeId).collect(Collectors.toSet());
            logger.info("Updating failed status for knowledge bases in task: {}, affected bases: {}", (Object)taskId, (Object)knowledgeIds.size());
            List<Long> completedKnowledgeIds = KnowledgeVectorCache.isCompleted(taskId, new ArrayList<Long>(knowledgeIds));
            this.knowledgeVectorTaskStorage.updateTaskProcessedForKnl(taskId, new HashSet<Long>(1), new HashSet<Long>(completedKnowledgeIds), this.knowledgeVectorTaskManager.getTaskLock());
        }
    }

    protected void markBatchFailed(String taskId, List<Chunk> chunks, String errorMsg) {
        String traceId = RequestContext.get().getTraceId();
        logger.info("Marking batch failed for task: {}, chunks: {}, traceId: {}", new Object[]{taskId, chunks.size(), traceId});
        this.knowledgeVectorTaskStorage.updateVectorTaskItemError(taskId, chunks, traceId);
        Set knowledgeIds = chunks.stream().filter(chunk -> chunk.getKnowledgeId() != null).map(Chunk::getKnowledgeId).collect(Collectors.toSet());
        logger.info("Updating error status for {} knowledge bases in task: {}", (Object)knowledgeIds.size(), (Object)taskId);
        for (Long knowledgeId : knowledgeIds) {
            this.knowledgeVectorTaskManager.updateKnowledgeError(taskId, knowledgeId, traceId, errorMsg);
        }
    }
}

