/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.vectortask;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorTask;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.embedding.service.EmbeddingService;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.gptas.common.vectortask.VectorTaskManager;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorBatchProcessor;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorTaskStorage;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorCache;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorModel;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public class KnowledgeVectorTaskManager
extends VectorTaskManager {
    private static final Log log = LogFactory.getLog(KnowledgeVectorTaskManager.class);
    private final KnowledgeVectorTaskStorage knowledgeVectorTaskStorage = new KnowledgeVectorTaskStorage();
    private final KnowledgeVectorCache vectorKnowledgeCache;
    private final KnowledgeVectorBatchProcessor processor;
    private Consumer<List<KnowledgeVectorModel>> knowledgeResultCallback;
    private final Map<Long, KnowledgeLock> knowledgeLocks;

    public KnowledgeVectorTaskManager(EmbeddingService embeddingService, VectorStoreService vectorStoreService, List<VectorStorePlugin> vectorStorePlugins) {
        super(embeddingService, vectorStoreService, vectorStorePlugins);
        this.processor = new KnowledgeVectorBatchProcessor(this, embeddingService, vectorStoreService, this.knowledgeVectorTaskStorage, vectorStorePlugins);
        this.knowledgeLocks = new ConcurrentHashMap<Long, KnowledgeLock>();
        this.vectorKnowledgeCache = new KnowledgeVectorCache();
    }

    public String submitForKnowledge(List<Chunk> chunks, Consumer<List<KnowledgeVectorModel>> knowledgeResultCallback) {
        String taskId = ID.genStringId();
        Set knowledgeIds = chunks.stream().filter(chunk -> chunk.getKnowledgeId() != null).map(Chunk::getKnowledgeId).collect(Collectors.toSet());
        VectorTask vectorTask = new VectorTask();
        vectorTask.setTaskId(taskId);
        vectorTask.setStatus(VectorTask.VectorTaskStatus.INIT);
        vectorTask.setTotalChunkCount(chunks.size());
        vectorTask.setKnowledgeCount(knowledgeIds.size());
        this.knowledgeVectorTaskStorage.saveVectorTask(vectorTask);
        this.knowledgeVectorTaskStorage.saveVectorTaskChunks(taskId, chunks);
        this.createKnowledgeModels(taskId, chunks, knowledgeResultCallback);
        this.processor.process(taskId, chunks);
        return taskId;
    }

    public static KnowledgeVectorModel getVectorKnowledge(String taskId, Long knowledgeId) {
        return KnowledgeVectorCache.getVectorKnowledgeModel(taskId, knowledgeId);
    }

    public static List<KnowledgeVectorModel> getVectorKnowledges(String taskId) {
        return KnowledgeVectorCache.getVectorKnowledgeModels(taskId);
    }

    public void createKnowledgeModels(String taskId, List<Chunk> chunks, Consumer<List<KnowledgeVectorModel>> knowledgeResultCallback) {
        this.knowledgeResultCallback = knowledgeResultCallback;
        Map<Long, List<Chunk>> chunkGroupByKnow = this.extractKnowledgeGroup(chunks);
        ArrayList<KnowledgeVectorModel> models = new ArrayList<KnowledgeVectorModel>(chunkGroupByKnow.size());
        for (Map.Entry<Long, List<Chunk>> entry : chunkGroupByKnow.entrySet()) {
            Long knowledgeId = entry.getKey();
            List<Chunk> chunksByKnowledge = entry.getValue();
            KnowledgeVectorModel model = new KnowledgeVectorModel(knowledgeId, chunksByKnowledge.stream().map(Chunk::getId).collect(Collectors.toSet()));
            models.add(model);
            this.knowledgeLocks.put(model.getKnowledgeId(), new KnowledgeLock());
        }
        this.vectorKnowledgeCache.saveKnowledgeModels(taskId, models);
    }

    public void updateProcessed(String taskId, List<Chunk> successedChunks, List<Chunk> completedChunks) {
        if (taskId == null || successedChunks == null || completedChunks == null) {
            throw new IllegalArgumentException("Required parameters cannot be null");
        }
        Map<Long, List<Chunk>> successChunksGroup = this.extractKnowledgeGroup(successedChunks);
        Map<Long, List<Chunk>> completedChunksGroup = this.extractKnowledgeGroup(completedChunks);
        for (Map.Entry<Long, List<Chunk>> entry : completedChunksGroup.entrySet()) {
            Long knowledgeId = entry.getKey();
            List<Chunk> completedChunksByKnow = entry.getValue();
            KnowledgeVectorModel vectorKnowledgeModel = new KnowledgeVectorModel();
            vectorKnowledgeModel.setKnowledgeId(knowledgeId);
            vectorKnowledgeModel.setCompletedChunkIds(completedChunksByKnow.stream().map(Chunk::getId).collect(Collectors.toSet()));
            List<Chunk> successedChunksByKnow = successChunksGroup.get(knowledgeId);
            if (CollectionUtils.isNotEmpty(successedChunksByKnow)) {
                vectorKnowledgeModel.setSuccessedChunkIds(successedChunksByKnow.stream().map(Chunk::getId).collect(Collectors.toSet()));
            }
            KnowledgeLock knowledgeThrealLock = this.knowledgeLocks.get(knowledgeId);
            KnowledgeVectorCache.updateKnowledgeProcessing(taskId, vectorKnowledgeModel, knowledgeThrealLock);
        }
    }

    public List<KnowledgeVectorModel> tryNotifyCompleted(String taskId, List<Chunk> completedChunks) {
        ArrayList<KnowledgeVectorModel> vectorKnowledges = new ArrayList<KnowledgeVectorModel>();
        Consumer<List> safeCallback = knowledge -> {
            try {
                if (this.knowledgeResultCallback != null) {
                    this.knowledgeResultCallback.accept((List<KnowledgeVectorModel>)knowledge);
                }
            }
            catch (Exception e) {
                log.error("Error executing callback", (Throwable)e);
            }
        };
        Set<Long> knowledgeIds = this.extractKnowledgeIds(completedChunks);
        for (Long knowledgeId : knowledgeIds) {
            KnowledgeLock lock = this.knowledgeLocks.get(knowledgeId);
            KnowledgeVectorCache.notifyCompleted(taskId, knowledgeId, lock, vectorKnowledgeModel -> {
                vectorKnowledges.add((KnowledgeVectorModel)vectorKnowledgeModel);
                safeCallback.accept(Collections.singletonList(vectorKnowledgeModel));
            });
        }
        return vectorKnowledges;
    }

    public void updateKnowledgeError(String taskId, Long knowledgeId, String traceId, String errorMsg) {
        KnowledgeLock lock = this.knowledgeLocks.get(knowledgeId);
        KnowledgeVectorCache.updateKnowledgeError(lock, taskId, knowledgeId, traceId, errorMsg);
    }

    private Set<Long> extractKnowledgeIds(List<Chunk> chunks) {
        return chunks.stream().filter(chunk -> chunk.getKnowledgeId() != null).map(Chunk::getKnowledgeId).collect(Collectors.toSet());
    }

    private Map<Long, List<Chunk>> extractKnowledgeGroup(List<Chunk> chunks) {
        return chunks.stream().filter(chunk -> chunk.getKnowledgeId() != null).collect(Collectors.groupingBy(Chunk::getKnowledgeId));
    }

    public static class KnowledgeLock {
    }
}

