/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.vectortask.model;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.gptas.kmbase.vectortask.KnowledgeVectorTaskManager;
import kd.bos.gptas.kmbase.vectortask.model.KnowledgeVectorModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class KnowledgeVectorCache {
    private static Log logger = LogFactory.getLog(KnowledgeVectorCache.class);
    protected static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("vectortask-knowledge", new DistributeCacheHAPolicy(true, true));
    private static final String KNOWLEDGE_KEY_PREFIX = "vector:tasks:knowledge";
    private static final int NUM_OF_TIMEOUT = 2;
    private static final TimeUnit UNITS_OF_TIMEOUT = TimeUnit.HOURS;

    private static String getKnowledgePrefixKey(String taskId) {
        return RequestContext.get().getAccountId() + KNOWLEDGE_KEY_PREFIX + taskId;
    }

    public void saveKnowledgeModels(String taskId, List<KnowledgeVectorModel> vectorKnowledges) {
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new IllegalArgumentException("TaskId cannot be empty");
        }
        if (CollectionUtils.isEmpty(vectorKnowledges)) {
            throw new IllegalArgumentException("Models cannot be empty");
        }
        Map<String, String> map = vectorKnowledges.stream().collect(Collectors.toMap(model -> String.valueOf(model.getKnowledgeId()), JSON::toJSONString));
        cache.put(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), map, 2, UNITS_OF_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateKnowledgeProcessing(String taskId, KnowledgeVectorModel changeModel, KnowledgeVectorTaskManager.KnowledgeLock lock) {
        KnowledgeVectorTaskManager.KnowledgeLock knowledgeLock = lock;
        synchronized (knowledgeLock) {
            KnowledgeVectorModel model = KnowledgeVectorCache.getVectorKnowledgeModel(taskId, changeModel.getKnowledgeId());
            if (model == null) {
                return;
            }
            model.addCompletedChunks(changeModel.getCompletedChunkIds());
            model.addSuccessedChunks(changeModel.getSuccessedChunkIds());
            cache.put(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), String.valueOf(changeModel.getKnowledgeId()), JSON.toJSONString((Object)model), 2, UNITS_OF_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateKnowledgeError(KnowledgeVectorTaskManager.KnowledgeLock lock, String taskId, Long knowledgeId, String traceId, String errorMsg) {
        KnowledgeVectorTaskManager.KnowledgeLock knowledgeLock = lock;
        synchronized (knowledgeLock) {
            KnowledgeVectorModel model = KnowledgeVectorCache.getVectorKnowledgeModel(taskId, knowledgeId);
            if (model == null) {
                return;
            }
            model.setTraceId(traceId);
            model.setErrorMessage(errorMsg);
            cache.put(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), String.valueOf(knowledgeId), JSON.toJSONString((Object)model), 2, UNITS_OF_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyCompleted(String taskId, Long knowledgeId, KnowledgeVectorTaskManager.KnowledgeLock lock, Consumer<KnowledgeVectorModel> consumer) {
        KnowledgeVectorTaskManager.KnowledgeLock knowledgeLock = lock;
        synchronized (knowledgeLock) {
            int completedCount;
            int totalCount;
            KnowledgeVectorModel model = KnowledgeVectorCache.getVectorKnowledgeModel(taskId, knowledgeId);
            if (model == null) {
                return;
            }
            boolean completed = KnowledgeVectorCache.isCompleted(model);
            if (completed && !model.isNotified() && (totalCount = model.getChunkIds().size()) == (completedCount = model.getCompletedChunkIds().size())) {
                consumer.accept(model);
                model.setNotified(true);
                cache.put(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), String.valueOf(knowledgeId), JSON.toJSONString((Object)model), 2, UNITS_OF_TIMEOUT);
            }
        }
    }

    public static List<Long> isCompleted(String taskId, List<Long> knowledgeIds) {
        List<KnowledgeVectorModel> models = KnowledgeVectorCache.getVectorKnowledgeModels(taskId, knowledgeIds);
        return models.stream().filter(KnowledgeVectorCache::isCompleted).map(KnowledgeVectorModel::getKnowledgeId).collect(Collectors.toList());
    }

    private static boolean isCompleted(KnowledgeVectorModel model) {
        int completedCount;
        int totalCount = model.getChunkIds().size();
        return totalCount == (completedCount = model.getCompletedChunkIds().size());
    }

    public static KnowledgeVectorModel getVectorKnowledgeModel(String taskId, Long knowledgeId) {
        try {
            String modelStr = (String)cache.get(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), String.valueOf(knowledgeId));
            if (modelStr == null) {
                logger.warn("Knowledge model not found - taskId: {}, knowledgeId: {}", (Object)taskId, (Object)knowledgeId);
                return null;
            }
            return (KnowledgeVectorModel)JSON.parseObject((String)modelStr, KnowledgeVectorModel.class);
        }
        catch (Exception e) {
            logger.error("Failed to get knowledge model", (Throwable)e);
            throw new RuntimeException("Cache operation failed", e);
        }
    }

    private static List<KnowledgeVectorModel> getVectorKnowledgeModels(String taskId, List<Long> knowledgeIds) {
        String[] knowledgeIdArr = (String[])knowledgeIds.stream().map(String::valueOf).toArray(String[]::new);
        List modelStrArr = cache.get(KnowledgeVectorCache.getKnowledgePrefixKey(taskId), knowledgeIdArr);
        return modelStrArr.stream().map(modelStr -> (KnowledgeVectorModel)JSON.parseObject((String)modelStr, KnowledgeVectorModel.class)).collect(Collectors.toList());
    }

    public static List<KnowledgeVectorModel> getVectorKnowledgeModels(String taskId) {
        Map modelStrArr = cache.getAll(KnowledgeVectorCache.getKnowledgePrefixKey(taskId));
        return modelStrArr.values().stream().map(modelStr -> (KnowledgeVectorModel)JSON.parseObject((String)modelStr, KnowledgeVectorModel.class)).collect(Collectors.toList());
    }
}

