/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BatchRunnerUtil {
    public static final String DEFAULT_GAI_PROMPT_NUMBER = "gptas-default";
    private static String oldLLMModelId = "";
    private static final Pattern NodeName_Pattern = Pattern.compile("\"nodeName\":\"([^\"]*)\"");
    private static final Pattern PromptType_Pattern = Pattern.compile("\"promptType\":(-?\\d+)?");

    public static void showEvaluationResult(IFormView formView, TaskInfo taskInfo) {
        String data = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        Long id = Long.parseLong(String.valueOf(dataMap.get("id")));
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)id);
        billShowParameter.setFormId("aikm_evaluationlayout");
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        formView.showForm((FormShowParameter)billShowParameter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] writeFile(Object[] headers, Object[][] datas) {
        Object[][] cell;
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet();
        Row headerRow = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            cell = headerRow.createCell(i);
            cell.setCellValue((String)headers[i]);
        }
        int rowNum = 1;
        cell = datas;
        int n = cell.length;
        int n2 = 0;
        while (true) {
            int n3;
            Object[] objectArray;
            int colNum;
            Row row;
            if (n2 < n) {
                Object[] aBook = cell[n2];
                row = sheet.createRow(rowNum++);
                colNum = 0;
                objectArray = aBook;
                n3 = objectArray.length;
            } else {
                if (datas.length > 0) {
                    for (int i = 0; i < headers.length; ++i) {
                        sheet.autoSizeColumn(i);
                    }
                } else {
                    sheet.setColumnWidth(0, 12500);
                    sheet.setColumnWidth(1, 12500);
                }
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    workbook.write((OutputStream)outputStream);
                    workbook.close();
                    workbook = null;
                    outputStream.flush();
                    byte[] data = outputStream.toByteArray();
                    outputStream.close();
                    byte[] byArray = data;
                    return byArray;
                }
                catch (IOException e) {
                    if (workbook == null) throw new RuntimeException(e);
                    try {
                        workbook.close();
                        throw new RuntimeException(e);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new RuntimeException(e);
                }
            }
            for (int i = 0; i < n3; ++i) {
                Object field = objectArray[i];
                Cell cell2 = row.createCell(colNum++);
                if (field == null) {
                    cell2.setCellValue((String)null);
                    break;
                }
                if (field instanceof String) {
                    cell2.setCellValue((String)field);
                    continue;
                }
                if (field instanceof Integer) {
                    cell2.setCellValue((double)((Integer)field).intValue());
                    continue;
                }
                if (field instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)field;
                    cell2.setCellValue(bigDecimal.doubleValue());
                    continue;
                }
                cell2.setCellValue(String.valueOf(field));
            }
            ++n2;
        }
    }

    public static List<ComboItem> createLlmComboItem() {
        List serviceList = (List)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"getLlmList", (Object[])new Object[0]);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        for (Map service : serviceList) {
            if (!Boolean.TRUE.equals(service.get("active"))) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(service.get("name").toString()));
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public static String updatePrompt(String llmModelId) {
        if (llmModelId == "") {
            llmModelId = oldLLMModelId;
            oldLLMModelId = "";
        }
        String result = "";
        if (llmModelId != "") {
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)DEFAULT_GAI_PROMPT_NUMBER)};
            Map prompt = BusinessDataReader.loadFromCache((String)"gai_prompt", (QFilter[])qFilters);
            Optional first = prompt.values().stream().findFirst();
            if (!first.isPresent()) {
                throw new RuntimeException("prompt not exists. number:=gptas-default");
            }
            String promptId = ((DynamicObject)first.get()).get("id").toString();
            oldLLMModelId = ((DynamicObject)first.get()).get("language_model").toString();
            JSONObject requiredParamsJo = new JSONObject();
            requiredParamsJo.put("requestId", (Object)RequestContext.get().getRequestId());
            JSONObject bizParamsJo = new JSONObject();
            bizParamsJo.put("promptId", (Object)promptId);
            bizParamsJo.put("llmNumber", (Object)llmModelId);
            result = (String)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"updatePrompt", (Object[])new Object[]{requiredParamsJo.toJSONString(), bizParamsJo.toJSONString()});
        }
        return result;
    }

    public static String getNodeName(String json) {
        Matcher matcher = NodeName_Pattern.matcher(json);
        if (matcher.find()) {
            String nodeName = matcher.group(1);
            return nodeName;
        }
        return "";
    }

    public static String getPromptType(String json) {
        Matcher matcher = PromptType_Pattern.matcher(json);
        if (matcher.find()) {
            String nodeName = matcher.group(1);
            return nodeName;
        }
        return "";
    }

    public static String leftSubstr(String str, int leftCount) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)str) && str.length() > leftCount) {
            return str.substring(0, leftCount);
        }
        return str;
    }
}

