/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.gptas.qa.batchrun.RunnerTaskClick;
import kd.bos.gptas.qa.batchrun.runner.AIKMRunner;
import kd.bos.gptas.qa.batchrun.runner.RunnerData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.Pair;
import kd.bos.util.StringUtils;

public class RunnerTask
extends AbstractTask {
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";
    private static final Log logger = LogFactory.getLog(RunnerTask.class);
    public static final String CACHEID = "cacheid";
    public static final String RUNDATA = "rundata";
    public static final String RUNDATAMULTI = "rundatamulti";
    public static final String SKILLID = "skillid";
    public static final String LLMMODEL_ID = "llmmodelid";
    public static final String PROMPT_TEMPLATE = "promptTemplate";
    public static final String FINISH_COUNT = "finishCount";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        logger.info("\u5f00\u59cb\u8bc4\u6d4b");
        Long skillId = (Long)params.get(SKILLID);
        String llmModelId = params.get(LLMMODEL_ID).toString();
        AIKMRunner batchTestRunner = new AIKMRunner();
        String billId = (String)params.get(CACHEID);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        if (taskInfo != null) {
            DynamicObject data = RunnerTask.loadData(Long.parseLong(billId));
            data.set("jobid", (Object)taskInfo.getJobId());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            logger.info(String.format("\u8bb0\u5f55\u4efb\u52a1id%s", taskInfo.getJobId()));
        }
        String promptTemplate = params.get(PROMPT_TEMPLATE).toString();
        batchTestRunner.setSkillId(skillId);
        batchTestRunner.setPromptTemplate(promptTemplate);
        long now = System.currentTimeMillis();
        try {
            String runnerDataStr;
            BatchRunnerUtil.updatePrompt(llmModelId);
            if (params.containsKey(RUNDATA)) {
                runnerDataStr = (String)params.get(RUNDATA);
                List listRunnerData = SerializationUtils.fromJsonStringToList((String)runnerDataStr, RunnerData.class);
                logger.info(String.format("\u5f00\u59cb\u6267\u884c\u5355\u6761\u6570\u636e\u8bc4\u6d4b,\u6570\u91cf\uff1a%s", listRunnerData.size()));
                RunnerDataConsumer runnerDataConsumer = new RunnerDataConsumer(listRunnerData.size(), billId, (arg_0, arg_1, arg_2) -> ((RunnerTask)this).feedbackProgress(arg_0, arg_1, arg_2));
                batchTestRunner.batchStart(listRunnerData, () -> ((RunnerTask)this).isStop(), runnerDataConsumer::accept);
            } else {
                runnerDataStr = (String)params.get(RUNDATAMULTI);
                List list = SerializationUtils.fromJsonStringToList((String)runnerDataStr, String.class);
                ArrayList<List<RunnerData>> listRunnerData = new ArrayList<List<RunnerData>>(16);
                for (Object s : list) {
                    listRunnerData.add(SerializationUtils.fromJsonStringToList((String)s, RunnerData.class));
                }
                int size = 0;
                for (List list2 : listRunnerData) {
                    size += list2.size();
                }
                logger.info(String.format("\u5f00\u59cb\u6267\u884c\u6279\u6b21\u6570\u636e\u8bc4\u6d4b,\u6570\u91cf\uff1a%s", size));
                RunnerDataConsumer runnerDataConsumer = new RunnerDataConsumer(size, billId, (arg_0, arg_1, arg_2) -> ((RunnerTask)this).feedbackProgress(arg_0, arg_1, arg_2));
                batchTestRunner.batchMultiStart(listRunnerData, () -> ((RunnerTask)this).isStop(), runnerDataConsumer::accept);
            }
            DynamicObject data = RunnerTask.loadData(Long.parseLong(billId));
            if (this.isStop()) {
                this.calcRunInfoCancel(data, now);
            } else {
                this.calcRunInfo(data, now);
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("id", billId);
                this.feedbackCustomdata(map);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            BatchRunnerUtil.updatePrompt("");
            if (this.isStop()) {
                this.stop();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            DynamicObject data = RunnerTask.loadData(Long.parseLong(billId));
            this.calcRunInfo(data, now);
            data.set("runstatus", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            BatchRunnerUtil.updatePrompt("");
            throw new KDException((Throwable)e, new ErrorCode("101", e.getMessage()), new Object[0]);
        }
    }

    private void calcRunInfo(DynamicObject data, long now) {
        data.set("runstatus", (Object)"B");
        long l = System.currentTimeMillis() - now;
        data.set("totaltime", (Object)l);
        data.set("totaltimedisp", (Object)RunnerTask.convertSecondsToTime(l / 1000L));
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        Pair[] entryDurations = new Pair[entryentity.size()];
        int i = 0;
        for (Object row : entryentity) {
            long l2 = row.getLong("duration");
            entryDurations[i++] = new Pair((Object)l2, row);
        }
        List<Pair<Long, DynamicObject>> list = this.extractOutliersUsingZScore(entryDurations);
        for (Pair pair : list) {
            ((DynamicObject)pair.getValue()).set("follow", (Object)Boolean.TRUE);
            ((DynamicObject)pair.getValue()).set("timeout", (Object)Boolean.TRUE);
        }
        int badCaseSum = 0;
        for (DynamicObject row : entryentity) {
            boolean isFollow = row.getBoolean("follow");
            if (!isFollow) continue;
            ++badCaseSum;
        }
        double d = (double)(entryentity.size() - badCaseSum) / (double)entryentity.size();
        data.set("rate", (Object)d);
        data.set("type", (Object)"D");
    }

    private void calcRunInfoCancel(DynamicObject data, long now) {
        data.set("runstatus", (Object)"D");
        data.set("type", (Object)"D");
        long l = System.currentTimeMillis() - now;
        data.set("totaltime", (Object)l);
        data.set("totaltimedisp", (Object)RunnerTask.convertSecondsToTime(l / 1000L));
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        Pair[] entryDurations = new Pair[entryentity.size()];
        int i = 0;
        for (Object row : entryentity) {
            long l2 = row.getLong("duration");
            entryDurations[i++] = new Pair((Object)l2, row);
        }
        List<Pair<Long, DynamicObject>> list = this.extractOutliersUsingZScore(entryDurations);
        for (Pair pair : list) {
            ((DynamicObject)pair.getValue()).set("follow", (Object)Boolean.TRUE);
            ((DynamicObject)pair.getValue()).set("timeout", (Object)Boolean.TRUE);
        }
        int badCaseSum = 0;
        for (DynamicObject row : entryentity) {
            boolean isFollow = row.getBoolean("follow");
            if (!isFollow) continue;
            ++badCaseSum;
        }
        double d = (double)(entryentity.size() - badCaseSum) / (double)entryentity.size();
        data.set("rate", (Object)d);
    }

    private double calculateMean(Pair<Long, DynamicObject>[] data) {
        double sum = 0.0;
        for (Pair<Long, DynamicObject> value : data) {
            sum += (double)((Long)value.getKey()).longValue();
        }
        return sum / (double)data.length;
    }

    private double calculateStandardDeviation(Pair<Long, DynamicObject>[] data, double mean) {
        double sum = 0.0;
        for (Pair<Long, DynamicObject> value : data) {
            sum += Math.pow((double)((Long)value.getKey()).longValue() - mean, 2.0);
        }
        return Math.sqrt(sum / (double)(data.length - 1));
    }

    private List<Pair<Long, DynamicObject>> extractOutliersUsingZScore(Pair<Long, DynamicObject>[] data) {
        double mean = this.calculateMean(data);
        double stdDev = this.calculateStandardDeviation(data, mean);
        ArrayList<Pair<Long, DynamicObject>> outliers = new ArrayList<Pair<Long, DynamicObject>>();
        for (Pair<Long, DynamicObject> value : data) {
            double zScore = ((double)((Long)value.getKey()).longValue() - mean) / stdDev;
            if (!(Math.abs(zScore) > 3.0)) continue;
            outliers.add(value);
        }
        return outliers;
    }

    public static String convertSecondsToTime(long seconds) {
        long days = seconds / 86400L;
        long remainder = seconds % 86400L;
        long hours = remainder / 3600L;
        long minutes = (remainder %= 3600L) / 60L;
        long secs = remainder % 60L;
        if (days > 0L) {
            return String.format("%dd%02d:%02d:%02d", days, hours, minutes, secs);
        }
        if (hours > 0L) {
            return String.format("%02d:%02d:%02d", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%02d:%02d", minutes, secs);
        }
        return String.format("%2ds", secs);
    }

    public static void startTask(AbstractFormPlugin plugin, String actionId, String cacheId, Long skillId, List<List<RunnerData>> listRunnerData, String llmModelId, String promptTemplate) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("bos");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(new LocaleString("BatchRunnerTask").toString());
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(RunnerTask.class.getName());
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(SKILLID, skillId);
        params.put(CACHEID, cacheId);
        params.put(LLMMODEL_ID, llmModelId);
        params.put(PROMPT_TEMPLATE, promptTemplate);
        if (listRunnerData.size() > 0) {
            boolean isMulti = listRunnerData.get(0).stream().anyMatch(runnerData -> StringUtils.isNotEmpty((String)runnerData.getBatchId()));
            if (!isMulti) {
                params.put(RUNDATA, SerializationUtils.toJsonString(listRunnerData.get(0)));
            } else {
                ArrayList<String> list = new ArrayList<String>(16);
                for (List<RunnerData> multiRunnerDatum : listRunnerData) {
                    list.add(SerializationUtils.toJsonString(multiRunnerDatum));
                }
                params.put(RUNDATAMULTI, SerializationUtils.toJsonString(list));
            }
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8bc4\u6d4b\u4e2d", (String)"RunnerTask_0", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName(RunnerTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)plugin.getView());
    }

    private static DynamicObject loadData(long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"aikm_evaluationbill");
        return BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)type);
    }

    static interface ProgressListener {
        public void progress(int var1, String var2, Map<String, Object> var3);
    }

    static class RunnerDataConsumer
    implements Consumer<RunnerData> {
        private final AtomicInteger finished = new AtomicInteger(0);
        private final String cacheId;
        private final int size;
        private final ProgressListener progressListener;

        public RunnerDataConsumer(int size, String cacheId, ProgressListener progressListener) {
            this.cacheId = cacheId;
            this.progressListener = progressListener;
            this.size = size;
        }

        public void accept(RunnerData runnerData) {
            int i = this.finished.incrementAndGet();
            if (!runnerData.getFinish()) {
                DynamicObject data = RunnerTask.loadData(Long.parseLong(this.cacheId));
                DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
                int seq = runnerData.getSeq();
                DynamicObject entryRow = (DynamicObject)entryentity.get(seq - 1);
                entryRow.set("a", (Object)BatchRunnerUtil.leftSubstr(runnerData.getA(), 2000));
                entryRow.set("a_tag", (Object)runnerData.getA());
                entryRow.set("score", (Object)runnerData.getScore());
                entryRow.set("duration", (Object)((double)runnerData.getDurations() / 1000.0));
                entryRow.set("reason", (Object)runnerData.getReason());
                entryRow.set("chatsessionid", (Object)runnerData.getChatSessionId());
                entryRow.set("chattraceid", (Object)runnerData.getChatTraceId());
                entryRow.set("timeout", (Object)Boolean.FALSE);
                if (runnerData.getScore() < 80.0) {
                    entryRow.set("follow", (Object)Boolean.TRUE);
                } else {
                    entryRow.set("bugtype", (Object)"A");
                    entryRow.set("follow", (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
            }
            this.progressListener.progress(i * 100 / this.size, String.format(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210%s\u4e2a\uff0c\u5171%s\u4e2a\u3002", (String)"RunnerTask_1", (String)RunnerTask.BOS_GTPAS_QA, (Object[])new Object[0]), i, this.size), new HashMap<String, Object>());
        }
    }
}

