/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.gptas.qa.batchrun.BatchRunnerUtil;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.event.ClickEventArgs;

public class RunnerTaskClick
extends AbstractTaskClick {
    public void click(ClickEventArgs e) {
        TaskInfo taskInfo = this.queryTask();
        if (taskInfo.isFailure()) {
            e.setClearTask(true);
            return;
        }
        IFormView parentView = this.getParentView();
        if (taskInfo.isTaskEnd()) {
            if (parentView == null) {
                BatchRunnerUtil.showEvaluationResult(this.getMainView(), taskInfo);
            } else {
                BatchRunnerUtil.showEvaluationResult(parentView, taskInfo);
                this.getMainView().sendFormAction(parentView);
            }
            e.setClearTask(true);
        } else if (parentView != null) {
            this.showProgressForm(parentView);
        }
    }

    private void showProgressForm(IFormView view) {
        if (this.isExistProgressForm()) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sch_taskprogress");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
            showParameter.setCaption(this.getJobFormInfo().getCaption());
        }
        showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
        String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
        showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
        showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
        showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
        view.showForm(showParameter);
        this.getMainView().sendFormAction(view);
        this.setProgressPageId(showParameter.getPageId());
    }
}

