/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.batchrun.runner;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class StackCache {
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final Log log = LogFactory.getLog(StackCache.class);
    private final String chatSessionId;
    private static final int MAX_ATTEMPTS = 50;
    private AtomicInteger i = new AtomicInteger(0);

    public StackCache(String chatSessionId) {
        this.chatSessionId = chatSessionId;
    }

    private static String buildCacheKey(String chatSessionId) {
        return "AIKM_BatchTestRunner_" + chatSessionId;
    }

    public void clear() {
        String key = StackCache.buildCacheKey(this.chatSessionId);
        CACHE.remove(key);
    }

    public String pop() {
        String key = StackCache.buildCacheKey(this.chatSessionId);
        String s = this.getFromCache(key);
        boolean attempt = false;
        while (s == null || s.isEmpty()) {
            if (this.i.incrementAndGet() >= 50) {
                return s;
            }
            try {
                Thread.sleep(50L * (long)(this.i.get() + 1));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            s = this.getFromCache(key);
        }
        this.removeFromCache(key);
        return s;
    }

    public String popWithStop(Supplier<Boolean> stopSupplier) {
        String key = StackCache.buildCacheKey(this.chatSessionId);
        String s = this.getFromCache(key);
        while (s == null || s.isEmpty()) {
            if (stopSupplier != null && stopSupplier.get().booleanValue()) {
                this.removeFromCache(key);
                return null;
            }
            if (this.i.incrementAndGet() >= 50) {
                return s;
            }
            try {
                Thread.sleep(50L * (long)(this.i.get() + 1));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            s = this.getFromCache(key);
        }
        this.removeFromCache(key);
        return s;
    }

    private String getFromCache(String key) {
        if (CACHE.getListLength(key) > 0) {
            return CACHE.getListObject(key, 0);
        }
        return "";
    }

    private void removeFromCache(String key) {
        if (CACHE.getListLength(key) > 0) {
            CACHE.removeListObject(key, 0);
        }
    }

    public String[] popAll() {
        String key = StackCache.buildCacheKey(this.chatSessionId);
        String[] list = CACHE.getList(key);
        CACHE.removeListObjects(key, 0, list.length);
        return list;
    }

    public void push(String s) {
        CACHE.addList(StackCache.buildCacheKey(this.chatSessionId), new String[]{s}, 600);
    }
}

