/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.chat;

import com.alibaba.fastjson.JSON;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.message.PushMessage;
import kd.bos.dataentity.message.PushMessageRange;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.gptas.qa.chat.pojo.ChatMessage;
import kd.bos.gptas.qa.chat.pojo.ChatType;
import kd.bos.gptas.qa.chat.pojo.UserMetaData;
import kd.bos.gptas.utils.AssistantCorpusUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.pushMessage.PushServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ChatAiUtils {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final Random random = new SecureRandom();
    private static final String PHOTOURL_DEFAULT = "/images/pc/emotion/default_person_82_82.png";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public static void beginChat(String requestId) {
        if (requestId != null) {
            cache.put(RequestContext.get().getAccountId() + "_bos_chat_" + requestId, (Object)"true");
        }
    }

    public static void stopChat(String requestId) {
        if (requestId != null) {
            cache.remove(RequestContext.get().getAccountId() + "_bos_chat_" + requestId);
        }
    }

    public static boolean isChatting(String requestId) {
        String s = (String)cache.get(RequestContext.get().getAccountId() + "_bos_chat_" + requestId);
        return Boolean.parseBoolean(s);
    }

    public static UserMetaData getUserMetaData(long userId) {
        DynamicObject userInfo = ChatAiUtils.getUserInfo(userId);
        if (userInfo == null) {
            return null;
        }
        return new UserMetaData(userInfo.getString("picturefield"), userInfo.getString("name"));
    }

    private static DynamicObject getUserInfo(long userId) {
        QFilter filterUser = new QFilter("id", "=", (Object)userId);
        String selectFileds = "id,fuid,number,name,phone,email,picturefield";
        QFilter[] filterUsers = new QFilter[]{filterUser};
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFileds, (QFilter[])filterUsers);
        if (userMap != null) {
            DynamicObject dynamicObject = (DynamicObject)userMap.get(userId);
            String picturefield = ChatAiUtils.getCurrentUserAvatarPath(userId, true);
            dynamicObject.set("picturefield", (Object)picturefield);
            return dynamicObject;
        }
        return null;
    }

    private static String getCurrentUserAvatarPath(long userId, boolean isGetFullPath) {
        Map userAvatarPathMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)isGetFullPath);
        if (!CollectionUtils.isEmpty((Map)userAvatarPathMap)) {
            String imgURL = (String)userAvatarPathMap.get(userId);
            String url = AssistantCorpusUtils.checkKdcdc((String)imgURL);
            return StringUtils.isBlank((CharSequence)url) ? PHOTOURL_DEFAULT : url;
        }
        return PHOTOURL_DEFAULT;
    }

    public static Map<String, Object> buildChatMessage(List<ChatMessage> messages, boolean isEnd) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis());
        dataMap.put("messages", messages);
        dataMap.put("end", isEnd);
        return dataMap;
    }

    public static Map<String, Object> buildChatMessage(ChatType type, String msg, boolean isEnd) {
        return ChatAiUtils.buildChatMessage(type, msg, "", isEnd, false);
    }

    public static Map<String, Object> buildChatMessage(ChatType type, String msg, String style, boolean isEnd, boolean isNewLine) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("time", System.currentTimeMillis());
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>(2);
        ChatMessage chatMessage = new ChatMessage(type, msg);
        chatMessage.setStyle(style);
        chatMessage.setNewMsg(isNewLine);
        if (ChatType.iframe == type) {
            chatMessage.setUrl(msg);
        }
        chatMessages.add(chatMessage);
        dataMap.put("messages", chatMessages);
        dataMap.put("end", isEnd);
        return dataMap;
    }

    public static Map<String, Object> buildChatMessage(ChatMessage message, boolean isEnd) {
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>(2);
        chatMessages.add(message);
        return ChatAiUtils.buildChatMessage(chatMessages, isEnd);
    }

    public static List<String> getCommonQuestions() {
        ArrayList<String> qList = new ArrayList<String>(3);
        String[] questions = ChatAiUtils.getQuestions();
        boolean[] usedNumbers = new boolean[12];
        for (int i = 0; i < 3; ++i) {
            int num;
            while (usedNumbers[num = random.nextInt(12)]) {
            }
            usedNumbers[num] = true;
            qList.add(ChatAiUtils.getQuestionsByIndex(num, questions));
        }
        return qList;
    }

    private static String getQuestionsByIndex(int randomNum, String[] questions) {
        return questions[randomNum];
    }

    public static void sendFormActionByWS(IFormView rootView, IFormView formView) {
        rootView.sendFormAction(formView);
        PushMessage message = new PushMessage(PushMessageRange.RootPage, rootView.getPageId(), (Object)JSON.toJSONString((Object)rootView.getActionResult()));
        PushServiceHelper.push((PushMessage)message);
    }

    private static String[] getQuestions() {
        return new String[]{ResManager.loadKDString((String)"\u5982\u4f55\u5728\u5355\u636e\u4e2d\u5173\u8054\u53e6\u4e00\u5f20\u5355\u636e\uff1f", (String)"ChatAiUtils_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u4f55\u7533\u8bf7\u5f00\u53d1\u5546\u6807\u8bc6\uff1f", (String)"ChatAiUtils_1", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u4f55\u7ed9\u591a\u9009\u57fa\u7840\u8d44\u6599\u8d4b\u503c\uff1f", (String)"ChatAiUtils_2", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f01\u4e1a\u5fae\u4fe1\u5982\u4f55\u96c6\u6210\u82cd\u7a79\uff1f", (String)"ChatAiUtils_3", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u4f55\u67e5\u770b\u5143\u6570\u636e\u5386\u53f2\u7248\u672c\uff1f", (String)"ChatAiUtils_4", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5982\u4f55\u914d\u7f6e\u6c34\u5e73\u5206\u8868\uff1f", (String)"ChatAiUtils_5", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u8c03\u5ea6\u81ea\u52a8\u68c0\u6d4b\uff0c\u5728\u54ea\u4e2a\u7248\u672c\u53d1\u5e03\uff1f", (String)"ChatAiUtils_6", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"6.0\u7248\u672c\u7528\u6237\u6388\u6743\u9875\u9762\u5728\u54ea\u91cc\uff1f", (String)"ChatAiUtils_7", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5143\u6570\u636e\u5bfc\u51fa\u62a5\u9519\u5982\u4f55\u6392\u67e5\uff1f", (String)"ChatAiUtils_8", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u65e0\u6cd5\u6267\u884c\uff0c\u53ef\u80fd\u662f\u54ea\u4e9b\u65b9\u9762\u7684\u539f\u56e0\uff1f", (String)"ChatAiUtils_9", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"destroy\u548cbeforeclosed\u4e8b\u4ef6\u533a\u522b\uff1f", (String)"ChatAiUtils_10", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u53cd\u5199\u8fc7\u7a0b\u4e2d\uff0c\u5982\u4f55\u8bbe\u7f6e\u8d85\u989d\u68c0\u67e5\uff1f", (String)"ChatAiUtils_11", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0])};
    }
}

