/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.formplugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.qa.model.QAAnswer;
import kd.bos.gptas.qa.model.QAChatHistory;
import kd.bos.gptas.qa.model.QAChunk;
import kd.bos.gptas.qa.model.QAPrompt;
import kd.bos.gptas.qa.service.QAService;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class QABatchTestFormPlugin
extends AbstractFormPlugin
implements UploadListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit kmformid = (BasedataEdit)this.getControl("kmformid");
        kmformid.addBeforeF7SelectListener(evt -> {
            evt.getFormShowParameter().setCustomParam("modeltype", (Object)"KMModel");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            qFilters.add(new QFilter("bizappid.number", "!=", (Object)"tpl"));
            evt.setCustomQFilters(qFilters);
        });
        this.addClickListeners(new String[]{"btnok", "btnexport"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getControl("subentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        switch (btn.getKey()) {
            case "btnok": {
                this.doQA();
            }
        }
    }

    private void doQA() {
        String s = this.getPageCache().get("xlsinfo");
        if (s == null) {
            this.getView().showTipNotification("can't get xls info.");
            return;
        }
        DynamicObject kmformid = (DynamicObject)this.getModel().getValue("kmformid");
        if (kmformid == null) {
            this.getView().showTipNotification(" km  can't empty.");
            return;
        }
        this.getView().getModel().deleteEntryData("entryentity");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
        this.runQA(0);
    }

    private void runQA(int row) {
        String s = this.getPageCache().get("xlsinfo");
        Map map = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
        List<QA> qaList = this.readQAList((String)map.get("url"), (String)map.get("name"));
        if (qaList.size() <= row) {
            return;
        }
        QA qa = qaList.get(row);
        this.getView().showProgressLoading(new LocaleString("test running.... total task:" + qaList.size() + " ,current task :" + row), (row + 1) * 100 / qaList.size());
        QAService qaService = new QAService();
        int top = (Integer)this.getModel().getValue("top");
        qaService.setTopK(top);
        String sesisonId = ID.genStringId();
        DynamicObject kmformid = (DynamicObject)this.getModel().getValue("kmformid");
        try {
            Iterator<QAAnswer> result = qaService.qa(sesisonId, qa.q, Collections.singletonList(kmformid.getString("id")));
            StringBuilder answer = new StringBuilder();
            while (result.hasNext()) {
                answer.append(result.next().getAnswer());
            }
            QAChatHistory qaChatHistory = new QAChatHistory(sesisonId);
            this.logResult(qa, answer.toString(), qaChatHistory);
        }
        catch (Exception ex) {
            this.logResult(qa, "test failed." + ex.getMessage(), null);
        }
        this.getPageCache().put("currentRow", String.valueOf(++row));
        this.getView().hideLoading();
        this.getModel().setValue("progress", (Object)("test running.... total task:" + qaList.size() + " ,finished task :" + row));
        if (row < qaList.size()) {
            this.getModel().setValue("progress", (Object)("test running.... total task:" + qaList.size() + " ,finished task :" + row));
            this.getView().addClientCallBack("runqa", Integer.valueOf(100));
        } else {
            this.getView().showSuccessNotification("qaTest finished.");
            this.getModel().setValue("progress", (Object)("test finished task:" + qaList.size()));
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnok"});
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        int n = Integer.parseInt(this.getPageCache().get("currentRow"));
        this.runQA(n);
    }

    private void logResult(QA qa, String a, QAChatHistory qaChatHistory) {
        int row = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("q", (Object)qa.q, row);
        this.getModel().setValue("a", (Object)a, row);
        this.getModel().setValue("base_a", (Object)qa.a, row);
        if (qaChatHistory == null) {
            return;
        }
        String score = this.getScore(a, qa.a);
        Double d = this.getScoreFromString(score);
        this.getModel().setValue("score", (Object)d, row);
        this.getModel().setValue("reason", (Object)score, row);
        this.getModel().setValue("prompt", (Object)qaChatHistory.getChatMessageList().get(0).getPrompt());
        this.getModel().setEntryCurrentRowIndex("entryentity", row);
        if (!qaChatHistory.getQaChunkList().isEmpty()) {
            this.getModel().batchCreateNewEntryRow("subentryentity", qaChatHistory.getQaChunkList().size());
            List<QAChunk> chunkList = qaChatHistory.getQaChunkList();
            block0: for (int subRow = 0; subRow < chunkList.size(); ++subRow) {
                QAChunk qaChunk = chunkList.get(subRow);
                Long knowledgeId = qaChunk.getKnowledgeId();
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)qaChunk.getFormId());
                Map map = BusinessDataReader.loadFromCache((Object[])new Object[]{knowledgeId}, (DynamicObjectType)dataEntityType);
                if (!map.containsKey(knowledgeId)) continue;
                this.getModel().setValue("chunk", (Object)qaChunk.getContent(), subRow);
                this.getModel().setValue("filename", (Object)((DynamicObject)map.get(knowledgeId)).getString("name"), subRow);
                DynamicObject data = (DynamicObject)map.get(knowledgeId);
                DynamicObjectCollection entryRows = data.getDynamicObjectCollection("segmententity");
                for (DynamicObject entryRow : entryRows) {
                    if (!entryRow.get("id").equals(qaChunk.getId())) continue;
                    this.getModel().setValue("chunkseq", entryRow.get("seq"), subRow);
                    this.getModel().setValue("formid", (Object)qaChunk.getFormId(), subRow);
                    this.getModel().setValue("knowledgeid", (Object)knowledgeId, subRow);
                    continue block0;
                }
            }
        }
    }

    private String getScore(String a, String base_a) {
        String promptTemplate = QAPrompt.getPromptTemplateFromFile("prompt/AnswerScore.md");
        String prompt = promptTemplate.replace("{{a}}", a).replace("{{base_a}}", base_a);
        return AIServiceProxy.invokePromptService((Object)"gptas-default", (String)prompt);
    }

    private Double getScoreFromString(String input) {
        Pattern pattern = Pattern.compile("score:(\\d+(\\.\\d+)?)");
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            double d = Double.parseDouble(matcher.group(1));
            if (d > 100.0) {
                d = 100.0;
            }
            return d;
        }
        return 0.0;
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls == null || urls.length == 0) {
            return;
        }
        Map map = (Map)urls[0];
        this.getPageCache().put("xlsinfo", SerializationUtils.toJsonString((Object)map));
        this.getPageCache().remove("qalist");
        List<QA> qas = this.readQAList((String)map.get("url"), (String)map.get("name"));
        this.getModel().setValue("progress", (Object)("total tasks:" + qas.size() + ", click run task."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<QA> readQAList(String url, String name) {
        String s = this.getPageCache().get("qalist");
        if (s != null) {
            return SerializationUtils.fromJsonStringToList((String)s, QA.class);
        }
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = tempFileCache.getInputStream(url);){
            ArrayList<QA> arrayList;
            Object workBook = name.endsWith("xls") ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
            Sheet sheet = workBook.getSheetAt(0);
            ArrayList<QA> list = new ArrayList<QA>(16);
            DataFormatter dataFormatter = new DataFormatter();
            for (Row row : sheet) {
                QA qa = new QA();
                qa.setQ(dataFormatter.formatCellValue(row.getCell(0)));
                qa.setA(dataFormatter.formatCellValue(row.getCell(1)));
                list.add(qa);
            }
            workBook.close();
            if (list.isEmpty()) {
                this.getView().showTipNotification("no data.");
                arrayList = Collections.emptyList();
                return arrayList;
            }
            list.remove(0);
            this.getView().getPageCache().put("qalist", SerializationUtils.toJsonString(list));
            arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int subRow = hyperLinkClickEvent.getRowIndex();
        String formId = (String)this.getModel().getValue("formid", subRow);
        Object knowledgeId = this.getModel().getValue("knowledgeid", subRow);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.NonModal);
        billShowParameter.setFormId(formId);
        billShowParameter.setPkId(knowledgeId);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    static class QA {
        private String q;
        private String a;

        QA() {
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public String getQ() {
            return this.q;
        }

        public void setQ(String q) {
            this.q = q;
        }
    }
}

