/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.gptas.qa.model.QAChatMessage;
import kd.bos.gptas.qa.model.QAChunk;

public class QAChatHistory {
    private final String chatSessionId;
    private final List<QAChatMessage> qaChatMessageList = new ArrayList<QAChatMessage>(16);
    private List<QAChunk> qaChunkList = new ArrayList<QAChunk>(16);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public List<QAChunk> getQaChunkList() {
        return this.qaChunkList;
    }

    public void addChunkList(List<QAChunk> chunkList) {
        if (this.qaChunkList.size() > 20) {
            this.qaChunkList = new ArrayList<QAChunk>(16);
        }
        HashMap map = new HashMap(16);
        this.qaChunkList.forEach(o -> map.put(o.getId(), o));
        for (QAChunk qaChunk : chunkList) {
            if (map.containsKey(qaChunk.getId())) continue;
            this.qaChunkList.add(qaChunk);
        }
    }

    private String getKey() {
        return CacheKeyUtil.getAcctId() + ".qamulti." + this.chatSessionId;
    }

    public QAChatHistory(String chatSessionId) {
        String chunkString;
        this.chatSessionId = chatSessionId;
        String cacheString = (String)cache.get(this.getKey() + ".chatmessage");
        if (StringUtils.isNotBlank((CharSequence)cacheString)) {
            this.qaChatMessageList.addAll(SerializationUtils.fromJsonStringToList((String)cacheString, QAChatMessage.class));
        }
        if (StringUtils.isNotBlank((CharSequence)(chunkString = (String)cache.get(this.getKey() + ".chunk")))) {
            this.qaChunkList.addAll(SerializationUtils.fromJsonStringToList((String)chunkString, QAChunk.class));
        }
    }

    public List<QAChatMessage> getChatMessageList() {
        return this.qaChatMessageList;
    }

    public void appendAnswer(String answer) {
        QAChatMessage qaChatMessage = this.qaChatMessageList.get(this.qaChatMessageList.size() - 1);
        qaChatMessage.setAnswer(qaChatMessage.getAnswer() + answer);
    }

    public void setCurrentPrompt(String prompt) {
        QAChatMessage qaChatMessage = this.qaChatMessageList.get(this.qaChatMessageList.size() - 1);
        qaChatMessage.setPrompt(prompt);
    }

    public void clearChatMessage() {
        this.qaChatMessageList.clear();
        this.qaChunkList.clear();
    }

    public void save() {
        cache.put(this.getKey() + ".chatmessage", (Object)SerializationUtils.toJsonString(this.getChatMessageList()), 3600);
        cache.put(this.getKey() + ".chunk", (Object)SerializationUtils.toJsonString(this.getQaChunkList()), 3600);
    }
}

