/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.qa.model.QAChunk;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class QAPrompt {
    private static final Log log = LogFactory.getLog(QAPrompt.class);
    private String prompt;
    private List<QAChunk> chunkList;

    public QAPrompt() {
    }

    public QAPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public List<QAChunk> getChunkList() {
        return this.chunkList;
    }

    public void setChunkList(List<QAChunk> chunkList) {
        this.chunkList = chunkList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPromptTemplateFromFile(String filePath, String securityPrompt) {
        try {
            QFilter qFilter = new QFilter("path", "=", (Object)filePath);
            qFilter.or("number", "=", (Object)filePath);
            Optional<String> prompt = QAPrompt.loadPromptTemplateFromSkillCorpus(qFilter);
            if (prompt.isPresent()) {
                return prompt.get();
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        try (InputStream stream = QAPrompt.class.getResourceAsStream("/" + QAPrompt.class.getPackage().getName().replace('.', '/') + "/" + filePath);){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)securityPrompt)) {
                s.append(securityPrompt);
            }
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPromptContentFromFile(String filePath) {
        try (InputStream stream = QAPrompt.class.getResourceAsStream("/" + QAPrompt.class.getPackage().getName().replace('.', '/') + "/" + filePath);){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPromptTemplateFromFile(String filePath) {
        String securityPrompt = QAPrompt.getPromptTemplateFromFile("prompt/SecurityPrompt.md", "");
        return QAPrompt.getPromptTemplateFromFile(filePath, securityPrompt);
    }

    private static Optional<String> loadPromptTemplateFromSkillCorpus(QFilter qFilter) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_skillcorpus", (String)"number, name, inputcontent, inputcontent_tag", (QFilter[])qFilter.and(enableFilter).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String json = dynamicObjects[0].getString("inputcontent_tag");
            return Optional.of(json);
        }
        return Optional.empty();
    }

    private static Optional<String> loadPromptTemplateFromSkillCorpusFormCaChe(QFilter qFilter) {
        Optional first;
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_skillcorpus", (String)"number, name, inputcontent_tag", (QFilter[])qFilter.and(enableFilter).toArray());
        if (objectMap != null && !objectMap.isEmpty() && (first = objectMap.values().stream().findFirst()).isPresent()) {
            String json = ((DynamicObject)first.get()).getString("inputcontent_tag");
            return Optional.of(json);
        }
        return Optional.empty();
    }

    public static String getPromptTemplate(String skillCorpusNumber) {
        try {
            QFilter qFilter = new QFilter("number", "=", (Object)skillCorpusNumber);
            Optional<String> prompt = QAPrompt.loadPromptTemplateFromSkillCorpusFormCaChe(qFilter);
            if (prompt.isPresent()) {
                return prompt.get();
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        return "";
    }
}

