/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.openapi;

import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.gptas.api.km.event.UrlCreateEvent;
import kd.bos.gptas.qa.model.QAAnswer;
import kd.bos.gptas.qa.service.QAService;
import kd.bos.gptas.qa.service.QAUrlService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.msgjet.MsgSendFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.pushservice.WebSocketIdReader;
import kd.bos.threads.ThreadPools;

@ApiController(value="devgptasqa", desc="\u77e5\u8bc6\u95ee\u7b54")
public class QAAPI {
    private static final Log logger = LogFactory.getLog(QAAPI.class);

    @ApiPostMapping(value="qaws")
    public CustomApiResult<String> qa(@ApiParam(value="\u5bf9\u8bddSessionId") @ApiParam(value="\u5bf9\u8bddSessionId") String chatSessionId, @ApiParam(value="\u95ee\u9898") @ApiParam(value="\u95ee\u9898") String question, @ApiParam(value="\u77e5\u8bc6\u5e93") @ApiParam(value="\u77e5\u8bc6\u5e93") List<String> entityIds, @ApiParam(value="\u662f\u5426\u4f7f\u7528\u591a\u8f6e") @ApiParam(value="\u662f\u5426\u4f7f\u7528\u591a\u8f6e") Boolean isMulti) {
        String globalSessionId = RequestContext.get().getGlobalSessionId();
        ThreadPools.executeOnce((String)("qa" + chatSessionId), () -> {
            boolean existsWebSocketIds = false;
            try {
                existsWebSocketIds = this.existsWebSocketIds(chatSessionId);
                for (int count = 0; !existsWebSocketIds && count < 20; ++count) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    existsWebSocketIds = this.existsWebSocketIds(chatSessionId);
                }
                if (!existsWebSocketIds) {
                    logger.info("websocket not connected.");
                    return;
                }
                QAService qaService = new QAService();
                Iterator<QAAnswer> qa = qaService.qa(chatSessionId, question, entityIds);
                while (qa.hasNext()) {
                    QAAnswer next = qa.next();
                    if (!next.isEnd() && !StringUtils.isNotBlank((CharSequence)next.getAnswer())) continue;
                    String jsonString = SerializationUtils.toJsonString((Object)next);
                    this.sendMessage(chatSessionId, jsonString);
                }
            }
            catch (Throwable ex) {
                if (existsWebSocketIds) {
                    QAAnswer qaAnswer = new QAAnswer();
                    qaAnswer.setEnd(true);
                    qaAnswer.setAnswer(ex.getMessage());
                    this.sendMessage(chatSessionId, SerializationUtils.toJsonString((Object)qaAnswer));
                }
                logger.error(ex);
            }
        });
        return CustomApiResult.success((Object)RequestContext.get().getGlobalSessionId());
    }

    private void sendMessage(String chatSessionId, String msg) {
        MsgSendFactory.getSender().send(chatSessionId, msg);
    }

    private boolean existsWebSocketIds(String chatSessionId) {
        List socketIds = WebSocketIdReader.getWebSocketIds((String)RequestContext.get().getAccountId(), (String)RequestContext.get().getGlobalSessionId());
        return socketIds.contains(chatSessionId);
    }

    @ApiPostMapping(value="qaurl")
    public CustomApiResult<String> qaUrl(@ApiParam(value="\u5b9e\u4f53Id") @ApiParam(value="\u5b9e\u4f53Id") String entityId, @ApiParam(value="Id") @ApiParam(value="Id") Long id, @ApiParam(value="\u5206\u5f55Id") @ApiParam(value="\u5206\u5f55Id") Long chunkId) {
        QAUrlService qaUrlService = new QAUrlService();
        return CustomApiResult.success((Object)qaUrlService.getUrl(new UrlCreateEvent(entityId, id, chunkId)));
    }
}

