/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.service;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.Plugin;
import kd.bos.gptas.api.km.KMUrlCreator;
import kd.bos.gptas.api.km.event.UrlCreateEvent;
import kd.bos.gptas.entity.KMEntityType;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.share.ShareUrlService;

public class QAUrlService {
    private final KMUrlCreator defaultUrlCreatort = new DefaultUrlCreator();

    public String getUrl(UrlCreateEvent event) {
        String url;
        KMUrlCreator kmUrlCreator = this.newInstance(event.getEntityId());
        if (kmUrlCreator != null && StringUtils.isNotBlank((CharSequence)(url = kmUrlCreator.getUrl(event)))) {
            return url;
        }
        return this.defaultUrlCreatort.getUrl(event);
    }

    private KMUrlCreator newInstance(String entityId) {
        KMEntityType kmEntityType = (KMEntityType)EntityMetadataCache.getDataEntityType((String)entityId);
        List importPlugins = kmEntityType.getImportPlugins();
        for (Plugin importPlugin : importPlugins) {
            String className = importPlugin.getClassName();
            Object o = TypesContainer.createInstance((String)className);
            if (!(o instanceof KMUrlCreator)) continue;
            return (KMUrlCreator)o;
        }
        return null;
    }

    static class DefaultUrlCreator
    implements KMUrlCreator {
        DefaultUrlCreator() {
        }

        public String getUrl(UrlCreateEvent event) {
            List mapList = AttachmentServiceHelper.getAttachments((String)event.getEntityId(), (Object)event.getId(), (String)"attachmentpanelap");
            if (!mapList.isEmpty()) {
                return (String)((Map)mapList.get(0)).get("previewurl");
            }
            return ShareUrlService.createShareUrl((String)event.getEntityId(), (String)String.valueOf(event.getId()), (int)300, (String)String.valueOf(RequestContext.get().getCurrUserId()), (String)RequestContext.get().getLang().toString(), (String)RequestContext.get().getAccountId());
        }
    }
}

