/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.cache;

import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class LLMDataCache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final int CACHE_TIMEOUT = 3600;
    private final Map<String, String> mapCache;
    private final String reqId;

    public LLMDataCache(String reqId) {
        this.reqId = reqId;
        this.mapCache = cache.getAll(LLMDataCache.getReqRegionKey(reqId));
    }

    public static LLMDataCache getByTaskId(String taskId) {
        String reqId = (String)cache.get(LLMDataCache.getRegionKey(taskId));
        if (StringUtils.isNotBlank((CharSequence)reqId)) {
            return new LLMDataCache(reqId);
        }
        return null;
    }

    public void release() {
        if (this.isExternal()) {
            this.persist();
            return;
        }
        cache.remove(LLMDataCache.getRegionKey(this.getTaskId()));
        cache.remove(LLMDataCache.getReqRegionKey(this.reqId));
        cache.remove(LLMDataCache.getRegionKey(this.getTaskId()) + ".llmdata");
        cache.remove(LLMDataCache.getRegionKey(this.getTaskId()) + ".reserve");
        cache.remove(LLMDataCache.getRegionKey(this.getTaskId()) + ".llmreflist");
    }

    public LLMDataCache persist() {
        cache.put(LLMDataCache.getReqRegionKey(this.reqId), this.mapCache, 3600);
        return this;
    }

    public boolean isStop() {
        return this.mapCache.get("stop") != null && "true".equals(this.mapCache.get("stop"));
    }

    private static String getRegionKey(String taskId) {
        return CacheKeyUtil.getAcctId() + ".qacallback." + taskId;
    }

    private static String getReqRegionKey(String reqId) {
        return CacheKeyUtil.getAcctId() + ".qacallback.req." + reqId;
    }

    public String getTaskId() {
        return this.mapCache.get("taskid");
    }

    public LLMDataCache setTaskId(String taskId) {
        this.mapCache.put("taskid", taskId);
        cache.put(LLMDataCache.getRegionKey(taskId), (Object)this.reqId);
        return this;
    }

    public String popLLMData() {
        String key = LLMDataCache.getRegionKey(this.getTaskId()) + ".llmdata";
        String s = cache.getListObject(key, 0);
        if (s != null) {
            cache.removeListObject(key, 0);
        }
        return s;
    }

    public void pushLLMData(String value) {
        String key = LLMDataCache.getRegionKey(this.getTaskId()) + ".llmdata";
        cache.addList(key, new String[]{value});
    }

    public boolean isExternal() {
        return this.mapCache.containsKey("external");
    }
}

