/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.marker.processor;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Stream;
import kd.bos.gptas.api.llm.Marker;
import kd.bos.gptas.api.llm.MarkerContent;
import kd.bos.gptas.common.llm.marker.processor.SlidingWindowProcessor;
import kd.bos.util.Pair;

public class MarkerProcessor {
    public static final int DEFAULT_SLIDINGWINDOW_TAG_LEN = 10;
    private final SlidingWindowProcessor slidingWindowProcessor;
    private final List<Marker> markers;
    private Marker currentMarker;

    public MarkerProcessor(List<Marker> markers) {
        this.markers = markers;
        int markerMaxLength = markers.stream().flatMap(data -> Stream.of(data.getStartTag(), data.getEndTag())).filter(Objects::nonNull).mapToInt(String::length).max().orElse(10);
        this.slidingWindowProcessor = new SlidingWindowProcessor(markerMaxLength * 2);
    }

    public Queue<MarkerContent> process(String chunk) {
        String content;
        LinkedList<MarkerContent> markerContentQueue = new LinkedList<MarkerContent>();
        this.slidingWindowProcessor.input(chunk);
        while (true) {
            String content2;
            Pair<Integer, Marker> startMatch;
            if (this.currentMarker == null && (startMatch = this.findNextMarkerStart(this.slidingWindowProcessor.getContent())) != null) {
                this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.POINT);
                content2 = this.slidingWindowProcessor.slide((Integer)startMatch.getKey(), ((Marker)startMatch.getValue()).getStartTag().length());
                markerContentQueue.offer(MarkerContent.create((String)content2));
                this.currentMarker = (Marker)startMatch.getValue();
            }
            if (this.currentMarker == null) break;
            int endPos = this.findMarkerEnd(this.currentMarker, this.slidingWindowProcessor.getContent());
            if (endPos >= 0) {
                this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.POINT);
                content2 = this.slidingWindowProcessor.slide(endPos, this.currentMarker.getEndTag().length());
                markerContentQueue.offer(MarkerContent.create((String)content2, (Marker)this.currentMarker, (boolean)true));
                this.currentMarker = null;
                continue;
            }
            Pair<Integer, Marker> nextStart = this.findNextMarkerStart(this.slidingWindowProcessor.getContent());
            if (nextStart == null) break;
            this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.POINT);
            String content3 = this.slidingWindowProcessor.slide((Integer)nextStart.getKey(), ((Marker)nextStart.getValue()).getStartTag().length());
            markerContentQueue.offer(MarkerContent.create((String)content3, (Marker)this.currentMarker, (boolean)true));
            this.currentMarker = (Marker)nextStart.getValue();
        }
        if (this.currentMarker != null) {
            this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.SAFE);
            content = this.slidingWindowProcessor.slide();
            markerContentQueue.offer(MarkerContent.create((String)content, (Marker)this.currentMarker, (boolean)false));
        }
        if (this.currentMarker == null) {
            this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.SAFE);
            content = this.slidingWindowProcessor.slide();
            markerContentQueue.offer(MarkerContent.create((String)content));
        }
        return markerContentQueue;
    }

    public Queue<MarkerContent> lastProcess() {
        String content;
        LinkedList<MarkerContent> markerContentQueue = new LinkedList<MarkerContent>();
        if (this.currentMarker != null) {
            this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.FINISH);
            content = this.slidingWindowProcessor.slide();
            markerContentQueue.offer(MarkerContent.create((String)content, (Marker)this.currentMarker, (boolean)false));
        }
        if (this.currentMarker == null) {
            this.slidingWindowProcessor.setState(SlidingWindowProcessor.SlideModel.FINISH);
            content = this.slidingWindowProcessor.slide();
            markerContentQueue.offer(MarkerContent.create((String)content));
        }
        return markerContentQueue;
    }

    private Pair<Integer, Marker> findNextMarkerStart(String content) {
        Pair bestMatch = null;
        for (Marker marker : this.markers) {
            int pos = content.indexOf(marker.getStartTag());
            if (pos < 0 || bestMatch != null && pos >= (Integer)bestMatch.getKey()) continue;
            bestMatch = new Pair((Object)pos, (Object)marker);
        }
        return bestMatch;
    }

    private int findMarkerEnd(Marker marker, String content) {
        if (marker.getEndTag() == null || marker.getEndTag().isEmpty()) {
            return -1;
        }
        int endPos = content.indexOf(marker.getEndTag());
        if (endPos >= 0) {
            return endPos;
        }
        return -1;
    }
}

