/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.marker.stream;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import kd.bos.gptas.api.llm.MarkedMessageStream;
import kd.bos.gptas.api.llm.MarkerContent;
import kd.bos.gptas.api.llm.MarkerPair;
import org.apache.commons.lang3.StringUtils;

public class StreamHandler {
    private final MarkedMessageStream messageStream;

    public StreamHandler(MarkedMessageStream markerAwareMessageStream) {
        this.messageStream = markerAwareMessageStream;
    }

    public Stream<MarkerPair<String, MarkerContent>> stream() {
        Spliterator<MarkerPair<String, MarkerContent>> spliterator = new Spliterator<MarkerPair<String, MarkerContent>>(){

            @Override
            public boolean tryAdvance(Consumer action) {
                while (StreamHandler.this.messageStream.hasNext()) {
                    MarkerPair markerPair = (MarkerPair)StreamHandler.this.messageStream.next();
                    if (markerPair == null || StringUtils.isBlank((CharSequence)((CharSequence)markerPair.getContent()))) continue;
                    action.accept(markerPair);
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 16;
            }
        };
        return StreamSupport.stream(spliterator, false);
    }
}

