/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.splitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MarkdownHeaderTextSplitter {
    private final List<HeaderConfig> headersToSplitOn;
    private static final Map<String, String> headerPair = new LinkedHashMap<String, String>();
    private static final List<HeaderConfig> headerConfigs;

    public MarkdownHeaderTextSplitter(List<HeaderConfig> headersToSplitOn) {
        this.headersToSplitOn = headersToSplitOn.stream().sorted((a, b) -> b.getSeparator().length() - a.getSeparator().length()).collect(Collectors.toList());
    }

    public MarkdownHeaderTextSplitter() {
        this(headerConfigs);
    }

    public List<Document> splitText(String text) {
        String[] lines = text.split("\n");
        ArrayList<LineWithMetadata> linesWithMetadata = new ArrayList<LineWithMetadata>();
        ArrayList<String> currentContent = new ArrayList<String>();
        HashMap<String, String> currentMetadata = new HashMap<String, String>();
        ArrayList<HeaderInfo> headerStack = new ArrayList<HeaderInfo>();
        HashMap<String, String> initialMetadata = new HashMap<String, String>();
        for (String line : lines) {
            String strippedLine = line.trim();
            boolean isHeader = false;
            for (HeaderConfig headerConfig : this.headersToSplitOn) {
                String sep = headerConfig.getSeparator();
                if (!strippedLine.startsWith(sep) || strippedLine.length() != sep.length() && strippedLine.charAt(sep.length()) != ' ') continue;
                isHeader = true;
                if (headerConfig.getMetadataKey() != null) {
                    int currentHeaderLevel = sep.length();
                    while (!headerStack.isEmpty() && ((HeaderInfo)headerStack.get(headerStack.size() - 1)).getLevel() >= currentHeaderLevel) {
                        HeaderInfo poppedHeader = (HeaderInfo)headerStack.remove(headerStack.size() - 1);
                        initialMetadata.remove(poppedHeader.getName());
                    }
                    HeaderInfo header = new HeaderInfo();
                    header.setLevel(currentHeaderLevel);
                    header.setName(headerConfig.getMetadataKey());
                    header.setData(strippedLine.substring(sep.length()).trim());
                    headerStack.add(header);
                    initialMetadata.put(header.getName(), header.getData());
                }
                if (currentContent.isEmpty()) break;
                LineWithMetadata lineWithMetadata = new LineWithMetadata();
                lineWithMetadata.setContent(String.join((CharSequence)"\n", currentContent));
                lineWithMetadata.setMetadata(new LinkedHashMap<String, String>(currentMetadata));
                linesWithMetadata.add(lineWithMetadata);
                currentContent.clear();
                break;
            }
            if (!isHeader) {
                if (!strippedLine.isEmpty()) {
                    currentContent.add(strippedLine);
                } else if (!currentContent.isEmpty()) {
                    LineWithMetadata lineWithMetadata = new LineWithMetadata();
                    lineWithMetadata.setContent(String.join((CharSequence)"\n", currentContent));
                    lineWithMetadata.setMetadata(new LinkedHashMap<String, String>(currentMetadata));
                    linesWithMetadata.add(lineWithMetadata);
                    currentContent.clear();
                }
            }
            currentMetadata = new HashMap(initialMetadata);
        }
        if (!currentContent.isEmpty()) {
            LineWithMetadata lineWithMetadata = new LineWithMetadata();
            lineWithMetadata.setContent(String.join((CharSequence)"\n", currentContent));
            lineWithMetadata.setMetadata(currentMetadata);
            linesWithMetadata.add(lineWithMetadata);
        }
        return this.aggregateLinesToChunks(linesWithMetadata);
    }

    private List<Document> aggregateLinesToChunks(List<LineWithMetadata> lines) {
        ArrayList<LineWithMetadata> aggregatedChunks = new ArrayList<LineWithMetadata>();
        for (LineWithMetadata line : lines) {
            if (!aggregatedChunks.isEmpty() && ((LineWithMetadata)aggregatedChunks.get(aggregatedChunks.size() - 1)).getMetadata().equals(line.getMetadata())) {
                LineWithMetadata lastChunk = (LineWithMetadata)aggregatedChunks.get(aggregatedChunks.size() - 1);
                lastChunk.setContent(lastChunk.getContent() + "  \n" + line.getContent());
                continue;
            }
            aggregatedChunks.add(line);
        }
        return aggregatedChunks.stream().map(chunk -> new Document(chunk.getContent(), chunk.getMetadata())).collect(Collectors.toList());
    }

    static {
        headerPair.put("#", "header_1");
        headerPair.put("##", "header_2");
        headerPair.put("###", "header_3");
        headerPair.put("####", "header_4");
        headerPair.put("#####", "header_5");
        headerPair.put("######", "header_6");
        headerPair.put("#######", "header_7");
        headerPair.put("########", "header_8");
        headerPair.put("#########", "header_9");
        headerPair.put("##########", "header_10");
        headerConfigs = headerPair.entrySet().stream().map(entry -> new HeaderConfig((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public static class LineWithMetadata {
        private String content;
        private Map<String, String> metadata;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }
    }

    public static class HeaderInfo {
        private int level;
        private String name;
        private String data;

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }

    public static class HeaderConfig {
        private String separator;
        private String metadataKey;

        public HeaderConfig(String separator, String metadataKey) {
            this.separator = separator;
            this.metadataKey = metadataKey;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public String getMetadataKey() {
            return this.metadataKey;
        }

        public void setMetadataKey(String metadataKey) {
            this.metadataKey = metadataKey;
        }
    }

    public static class Document {
        private String pageContent;
        private Map<String, String> metadata;

        public Document(String pageContent, Map<String, String> metadata) {
            this.pageContent = pageContent;
            this.metadata = metadata;
        }

        public String getPageContent() {
            return this.pageContent;
        }

        public void setPageContent(String pageContent) {
            this.pageContent = pageContent;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        public String toString() {
            return this.getTitle() + '\n' + this.pageContent;
        }

        private String getTitle() {
            String preTitle = "";
            String curTitle = "";
            for (String headerKey : headerPair.values()) {
                String title = this.metadata.get(headerKey);
                if (!StringUtils.isNotBlank((CharSequence)title)) continue;
                preTitle = curTitle;
                curTitle = title;
            }
            return preTitle + " " + curTitle;
        }
    }
}

