/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.vectordb;

import java.util.List;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.common.ServiceLoaderUtil;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.gptas.utils.SystemPropertyUtils;

public interface VectorStoreFactory {
    public static final String VECTORSTORE_FACTORYNAME_VDB = "vdb";
    public static final String VECTORSTORE_FACTORYNAME_MILVUS = "milvus";

    public static VectorStoreService create(EmbeddingModel embeddingModel) {
        VectorStoreFactory vectorStoreProvider = ServiceLoaderUtil.getFirstService(VectorStoreFactory.class);
        List<VectorStoreFactory> vectorStoreFactories = ServiceLoaderUtil.loadAllServices(VectorStoreFactory.class);
        if (Boolean.TRUE.toString().equals(SystemPropertyUtils.getPropertyByTenant("ai.vdb.enable"))) {
            for (VectorStoreFactory vectorStoreFactory : vectorStoreFactories) {
                if (!vectorStoreFactory.getName().equals(VECTORSTORE_FACTORYNAME_VDB)) continue;
                vectorStoreProvider = vectorStoreFactory;
                break;
            }
        }
        return vectorStoreProvider.getVectorStore(embeddingModel.getDimension(), embeddingModel.getModelName());
    }

    public String getName();

    public VectorStoreService getVectorStore(int var1, String var2);
}

