/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.vectordb.exception;

import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.GptasException;

public class VectorException
extends GptasException {
    private static final long serialVersionUID = 1L;

    public VectorException(GptasErrorCode errorCode) {
        super(errorCode);
    }

    public VectorException(GptasErrorCode errorCode, String errorDetail) {
        super(errorCode, errorDetail);
    }

    public VectorException(GptasErrorCode errorCode, String errorDetail, Throwable cause) {
        super(errorCode, errorDetail, cause);
    }

    public static VectorException connectionError(String detail) {
        return new VectorException(GptasErrorCode.VECTOR_STORE_CONNECTION_ERROR, detail);
    }

    public static VectorException writeError(String detail) {
        return new VectorException(GptasErrorCode.VECTOR_STORE_WRITE_ERROR, detail);
    }

    public static VectorException readError(String detail) {
        return new VectorException(GptasErrorCode.VECTOR_STORE_READ_ERROR, detail);
    }

    public static VectorException dimensionMismatch(int expected, int actual) {
        String detail = String.format("Expected dimension: %d, actual dimension: %d", expected, actual);
        return new VectorException(GptasErrorCode.VECTOR_DIMENSION_MISMATCH, detail);
    }

    public static VectorException idNotFound(String vectorId) {
        return new VectorException(GptasErrorCode.VECTOR_ID_NOT_FOUND, "Vector ID not found: " + vectorId);
    }

    public static VectorException batchError(String detail, Throwable cause) {
        return new VectorException(GptasErrorCode.VECTOR_BATCH_OPERATION_ERROR, detail, cause);
    }

    public static VectorException searchError(String detail) {
        return new VectorException(GptasErrorCode.VECTOR_SEARCH_ERROR, detail);
    }
}

