/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.vectortask;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorTask;
import kd.bos.gptas.api.vector.VectorTaskItem;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.embedding.service.EmbeddingService;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.gptas.common.vectortask.processor.VectorBatchProcessor;
import kd.bos.gptas.common.vectortask.storage.VectorTaskStorage;
import kd.bos.id.ID;

public class VectorTaskManager {
    private final VectorTaskStorage vectorTaskStorage = new VectorTaskStorage();
    protected final Object taskLock;
    private final VectorBatchProcessor processor;
    private Consumer<List<Chunk>> chunkResultCallback;

    public VectorTaskManager(EmbeddingService embeddingService, VectorStoreService vectorStoreService, List<VectorStorePlugin> vectorStorePluginList) {
        this.processor = new VectorBatchProcessor(this, embeddingService, vectorStoreService, this.vectorTaskStorage, vectorStorePluginList);
        this.taskLock = new Object();
    }

    public String submit(List<Chunk> chunks, Consumer<List<Chunk>> resultCallback) {
        String taskId = ID.genStringId();
        VectorTask vectorTask = new VectorTask();
        vectorTask.setTaskId(taskId);
        vectorTask.setStatus(VectorTask.VectorTaskStatus.INIT);
        vectorTask.setTotalChunkCount(chunks.size());
        this.vectorTaskStorage.saveVectorTask(vectorTask);
        this.vectorTaskStorage.saveVectorTaskChunks(taskId, chunks);
        this.chunkResultCallback = resultCallback;
        this.processor.process(taskId, chunks);
        return taskId;
    }

    public static VectorTask getVectorTask(String taskId) {
        return new VectorTaskStorage().getVectorTaskInfo(taskId);
    }

    public static List<VectorTaskItem> getFailedVectorTaskChunks(String taskId) {
        List<VectorTaskItem> vectorTaskItems = new VectorTaskStorage().getVectorTaskChunks(taskId);
        return vectorTaskItems.stream().filter(vectorTaskChunk -> vectorTaskChunk.getStatus() != VectorTaskItem.VectorTaskItemStatus.SUCCESS).collect(Collectors.toList());
    }

    public Consumer<List<Chunk>> getChunkResultCallback() {
        return this.chunkResultCallback;
    }

    public Object getTaskLock() {
        return this.taskLock;
    }
}

