/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.vectortask.storage;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorTask;
import kd.bos.gptas.api.vector.VectorTaskItem;
import kd.bos.gptas.common.vectortask.storage.AbstractVectorTaskStorage;

public class VectorTaskStorage
extends AbstractVectorTaskStorage {
    public void saveVectorTask(VectorTask task) {
        this.validateTask(task);
        cache.put(this.getTaskKey(task.getTaskId()), (Object)JSON.toJSONString((Object)task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVectorTaskStatus(String taskId, VectorTask.VectorTaskStatus status, Object taskThrealLock) {
        Object object = taskThrealLock;
        synchronized (object) {
            VectorTask vectorTask = Optional.ofNullable(this.getVectorTaskInfo(taskId)).orElseThrow(() -> new IllegalArgumentException("Task not found: " + taskId));
            vectorTask.setStatus(status);
            vectorTask.setUpdateTime(System.currentTimeMillis());
            this.saveVectorTask(vectorTask);
        }
    }

    public void saveVectorTaskChunks(String taskId, List<Chunk> chunks) {
        if (chunks == null || chunks.isEmpty()) {
            throw new IllegalArgumentException("Chunks cannot be null or empty");
        }
        Map<String, String> chunkStatusMap = chunks.stream().collect(Collectors.toMap(chunk -> String.valueOf(chunk.getId()), chunk -> JSON.toJSONString((Object)this.createInitialChunkStatus((Chunk)chunk)), (existing, replacement) -> replacement));
        cache.put(this.getChunkKey(taskId), chunkStatusMap);
    }

    public void updateVectorTaskItemStatus(String taskId, List<Chunk> chunks, VectorTaskItem.VectorTaskItemStatus status) {
        this.validateChunksAndStatus(chunks, status);
        String chunksKey = this.getChunkKey(taskId);
        String[] chunkIds = this.getChunkIds(chunks);
        List chunkStates = cache.get(chunksKey, chunkIds);
        Map<String, String> updates = this.processChunkUpdates(chunkStates, status);
        cache.put(chunksKey, updates);
    }

    private Map<String, String> processChunkUpdates(List<String> chunkStates, VectorTaskItem.VectorTaskItemStatus status) {
        return chunkStates.stream().map(state -> (VectorTaskItem)JSON.parseObject((String)state, VectorTaskItem.class)).peek(item -> {
            item.setStatus(status);
            item.setUpdateTime(System.currentTimeMillis());
        }).collect(Collectors.toMap(VectorTaskItem::getChunkId, JSON::toJSONString));
    }

    public void updateVectorTaskItemError(String taskId, List<Chunk> chunks, String traceId) {
        String chunksKey = this.getChunkKey(taskId);
        String[] chunkIds = (String[])chunks.stream().map(chunk -> String.valueOf(chunk.getId())).toArray(String[]::new);
        List chunkStatesArr = cache.get(chunksKey, chunkIds);
        List<VectorTaskItem> vectorTaskItems = chunkStatesArr.stream().map(chunkStateStr -> (VectorTaskItem)JSON.parseObject((String)chunkStateStr, VectorTaskItem.class)).collect(Collectors.toList());
        vectorTaskItems.forEach(vectorTaskChunk -> vectorTaskChunk.setTraceId(traceId));
        Map<String, String> chunkStatusMap = vectorTaskItems.stream().collect(Collectors.toMap(VectorTaskItem::getChunkId, JSON::toJSONString));
        cache.put(chunksKey, chunkStatusMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTaskProcessed(String taskId, int successCount, int failedCount, int completedCount, Object taskLock) {
        Object object = taskLock;
        synchronized (object) {
            VectorTask task = Optional.ofNullable(this.getVectorTaskInfo(taskId)).orElseThrow(() -> new IllegalArgumentException("Task not found: " + taskId));
            task.setSuccessChunkCount(task.getSuccessChunkCount() + successCount);
            task.setFailedChunkCount(task.getFailedChunkCount() + failedCount);
            task.setCompletedChunkCount(task.getCompletedChunkCount() + completedCount);
            task.setUpdateTime(System.currentTimeMillis());
            this.saveVectorTask(task);
        }
    }

    public VectorTask getVectorTaskInfo(String taskId) {
        String taskJson = (String)cache.get(this.getTaskKey(taskId));
        return Optional.ofNullable(taskJson).map(json -> (VectorTask)JSON.parseObject((String)json, VectorTask.class)).orElse(null);
    }

    public List<VectorTaskItem> getVectorTaskChunks(String taskId) {
        Map chunkMap = cache.getAll(this.getChunkKey(taskId));
        return chunkMap.values().stream().map(json -> (VectorTaskItem)JSON.parseObject((String)json, VectorTaskItem.class)).collect(Collectors.toList());
    }
}

