/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class GPTActionUtil {
    private static final Log logger = LogFactory.getLog(GPTActionUtil.class);

    public static JSONObject parseObject(String json) {
        return GPTActionUtil.parseJson(json, JSON::parseObject);
    }

    public static <T> T parseJson(String json, Function<String, T> parseFunc) {
        int start = json.indexOf("{");
        int end = json.lastIndexOf("}");
        json = json.substring(start, end + 1);
        json = json.replaceAll("\\u00A0+", "").replaceAll("\\u3000+", "");
        try {
            return parseFunc.apply(json);
        }
        catch (Exception ex) {
            logger.error("GPTMockUtil.parseObject", (Throwable)ex);
            logger.error("GPTMockUtil.parseObject :DEFAULT_PARSER_FEATURE 989 {}", (Object)JSON.DEFAULT_PARSER_FEATURE);
            if (json.contains("\u201c")) {
                json = json.replaceAll("\u201c", "\"");
            }
            if (json.contains("\u201d")) {
                json = json.replaceAll("\u201d", "\"");
            }
            return parseFunc.apply(json);
        }
    }

    public static void startProcess(String processNumber, String rootPageId, String input) {
        block4: {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)processNumber)};
            DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((String)"gai_process", (QFilter[])filters);
            if (obj == null) {
                String msg = String.format("GaiService.startProcessInSideBar error, %s process not exists.", processNumber);
                logger.error(msg);
                throw new KDBizException(msg);
            }
            long processId = obj.getLong("id");
            HashMap<String, String> startParams = new HashMap<String, String>();
            startParams.put("input", input);
            try {
                DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, rootPageId, startParams, input});
            }
            catch (RuntimeException ex) {
                Throwable cause;
                for (cause = ex.getCause(); cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof NoSuchMethodException)) continue;
                    DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiService", (String)"startProcessInSideBar", (Object[])new Object[]{processId, rootPageId, startParams});
                    break;
                }
                if (cause != null) break block4;
                throw ex;
            }
        }
    }
}

