/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QaUserTrackUtil {
    private static final Logger log = LoggerFactory.getLogger(QaUserTrackUtil.class);
    private static Map<String, List<DynamicObject>> accoutIdDynamics = new ConcurrentHashMap<String, List<DynamicObject>>();
    private static Map<String, RequestContext> accoutIdRequestContextMap = new ConcurrentHashMap<String, RequestContext>();
    private static Timer timer = new Timer();

    public static void recordUserAction(String apiNumber, Integer clientType, String uid, String userType) {
        RequestContext requestContext = RequestContext.get();
        String accoutId = requestContext.getAccountId();
        if (!accoutIdRequestContextMap.containsKey(accoutId)) {
            accoutIdRequestContextMap.put(accoutId, requestContext);
        }
        List dynamicObjectList = accoutIdDynamics.computeIfAbsent(accoutId, k -> new ArrayList());
        DynamicObject dynamicObject = (DynamicObject)EntityMetadataCache.getDataEntityType((String)"bos_qa_userbehavior").createInstance();
        dynamicObject.set("opname", (Object)apiNumber);
        dynamicObject.set("ip", (Object)requestContext.getLoginIP());
        if (StringUtils.isBlank((CharSequence)uid)) {
            uid = String.valueOf(requestContext.getCurrUserId());
        }
        dynamicObject.set("username", (Object)uid);
        dynamicObject.set("traceid", (Object)requestContext.getTraceId());
        dynamicObject.set("opdate", (Object)System.currentTimeMillis());
        dynamicObject.set("clienttype", (Object)clientType);
        dynamicObject.set("usertype", (Object)userType);
        log.info(String.format("record user info, ip is %1$s", requestContext.getLoginIP()));
        dynamicObjectList.add(dynamicObject);
    }

    static {
        long period = 30000L;
        timer.schedule(ThreadLifeCycleManager.wrapTimerTask(() -> {
            try {
                for (Map.Entry<String, List<DynamicObject>> entry : accoutIdDynamics.entrySet()) {
                    String accoutId = entry.getKey();
                    List<DynamicObject> values = entry.getValue();
                    RequestContext requestContext = accoutIdRequestContextMap.get(accoutId);
                    if (requestContext != null) {
                        RequestContext.set((RequestContext)requestContext);
                    }
                    if (values.isEmpty() || RequestContext.get() == null) continue;
                    DynamicObject[] dynamicObjArrays = new DynamicObject[0];
                    OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"bos_qa_userbehavior", (DynamicObject[])values.toArray(dynamicObjArrays), (OperateOption)OperateOption.create());
                    List validateInfo = result.getAllErrorOrValidateInfo();
                    if (!validateInfo.isEmpty()) {
                        log.warn("bos_qa_userbehavior save error.");
                    }
                    values.clear();
                }
            }
            catch (Exception e) {
                log.error(String.format("error occurs in timer : %s", e.getMessage()));
            }
        }), 30000L, period);
    }
}

