/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.webapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.gpt.IGPTAction;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.gptas.webapi.ConversionResult;
import kd.bos.mvc.bill.BillController;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;

public class WebApiDataConvertService
implements IGPTAction {
    private final PermissionService permissionService;

    public WebApiDataConvertService() {
        this.permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
    }

    public WebApiDataConvertService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public ConversionResult convertData(String formId, String appId, Map<String, Object> sourceData) {
        return this.convertData(formId, appId, null, sourceData);
    }

    public ConversionResult convertData(String formId, String appId, String pkId, Map<String, Object> sourceData) {
        boolean isModify = pkId != null && !pkId.isEmpty();
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", formId);
        if (isModify) {
            mapParam.put("pkId", pkId);
        }
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        parameter.setAppId(appId);
        IFormView view = parameter.createViewForWebApi();
        view.initialize(parameter);
        BillController billController = new BillController(view);
        billController.loadData();
        IDataModel model = view.getModel();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        OperateDataConverter converter = this.createConverter(model, formId, appId);
        if (isModify) {
            converter.setModify(true);
            converter.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
        }
        DynamicObject targetObject = view.getModel().getDataEntity();
        converter.filterBasedatas(sourceData, targetObject, 0);
        converter.cacheBasedataPKIds();
        converter.convertComplexProperty(sourceData, targetObject, 0);
        return new ConversionResult(targetObject, converter.getContextErrorInfo());
    }

    private OperateDataConverter createConverter(IDataModel model, String formId, String appId) {
        OperateDataConverter converter = new OperateDataConverter(model, new HashMap(), new HashMap());
        converter.setCheckImportable(true);
        converter.setDataConvertOrder(new ArrayList(1));
        converter.setHasPermResult(this.getHasPermOrgResult(formId, appId));
        return converter;
    }

    private HasPermDimObjResult getHasPermOrgResult(String formId, String appId) {
        return this.permissionService.getHasPermDimObjs(Long.parseLong(RequestContext.get().getUserId()), appId, formId, "47150e89000000ac");
    }

    public Map<String, String> invokeAction(String s, Map<String, String> map) {
        return Collections.emptyMap();
    }
}

