/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.metadata.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DefaultValueAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.entity.KMEntityType;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.entity.BaseEntity;

public class KMEntity
extends BaseEntity {
    private List<Plugin> importPlugins = new ArrayList<Plugin>();
    private int chunkLength = 350;
    private String separator = "\u3002,.";
    private int overLap = 50;

    protected MainEntityType createDataEntityType() {
        return new KMEntityType();
    }

    @CollectionPropertyAttribute(name="ImportPlugins", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getImportPlugins() {
        return this.importPlugins;
    }

    public void setImportPlugins(List<Plugin> ImportPlugins) {
        this.importPlugins = ImportPlugins;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="350")
    public int getChunkLength() {
        return this.chunkLength;
    }

    @SimplePropertyAttribute
    public void setChunkLength(int chunkLength) {
        this.chunkLength = chunkLength;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="\u3002,.")
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @SimplePropertyAttribute
    @DefaultValueAttribute(value="50")
    public int getOverLap() {
        return this.overLap;
    }

    public void setOverLap(int overLap) {
        this.overLap = overLap;
    }

    protected void registerProperties(MainEntityType mdt) {
        super.registerProperties(mdt);
        KMEntityType kmEntityType = (KMEntityType)mdt;
        ArrayList<kd.bos.entity.plugin.Plugin> plugins = new ArrayList<kd.bos.entity.plugin.Plugin>();
        for (Plugin p : this.importPlugins) {
            if (!p.isEnabled()) continue;
            kd.bos.entity.plugin.Plugin pl = new kd.bos.entity.plugin.Plugin();
            pl.setClassName(p.getClassName());
            pl.setType(p.getType());
            pl.setScriptNumber(p.getScriptNumber());
            pl.setRowKey(p.getRowKey());
            plugins.add(pl);
        }
        Collections.sort(plugins, new Comparator<kd.bos.entity.plugin.Plugin>(){

            @Override
            public int compare(kd.bos.entity.plugin.Plugin o1, kd.bos.entity.plugin.Plugin o2) {
                Integer rowkey1 = o1.getRowKey();
                Integer rowkey2 = o2.getRowKey();
                return rowkey1.compareTo(rowkey2);
            }
        });
        kmEntityType.setImportPlugins(plugins);
        kmEntityType.setOverLap(this.getOverLap());
        kmEntityType.setChunkLength(this.getChunkLength());
        kmEntityType.setSeparator(this.getSeparator());
    }
}

