/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.support.util.StringUtils;
import kd.bos.i18n.mservice.utils.AmountConvertResult;
import kd.bos.i18n.mservice.utils.EnCashTransfer;
import kd.bos.i18n.mservice.utils.ThCashTransfer;
import kd.bos.i18n.mservice.utils.VINumberTransfer;
import kd.bos.i18n.mservice.utils.ZhCashTransfer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MoneyConvertUtils {
    private static final Log logger = LogFactory.getLog(MoneyConvertUtils.class);
    private static final String BOS_MSERVICE_I18N = "bos-mservice-i18n";
    private static final String ZH = "ZH";
    private static final String EN = "EN";
    private static final String VI = "VI";
    private static final String TH = "TH";
    private static final String JPY = "JPY";
    private static final Pattern moneyPattern = Pattern.compile("^([+-]?([1-9]{1}\\d*)|[+-]?(0{1}))(\\.\\d{1,2})?$");
    private static final Boolean TRUE = Boolean.TRUE;
    private static final Boolean FALSE = Boolean.FALSE;

    public static AmountConvertResult moneyConvertUppercase(String langAbbrCode, String currencyNumber, String amount, String isTransCurrNum) {
        langAbbrCode = langAbbrCode.toUpperCase();
        currencyNumber = currencyNumber.toUpperCase();
        if (StringUtils.isEmpty((Object)langAbbrCode)) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u8bed\u8a00\u7b80\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MoneyConvertUtils_0", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (!(ZH.equalsIgnoreCase(langAbbrCode) || EN.equalsIgnoreCase(langAbbrCode) || VI.equalsIgnoreCase(langAbbrCode) || TH.equalsIgnoreCase(langAbbrCode))) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u8bed\u8a00\u7b80\u7801\u8f93\u5165\u9519\u8bef\u3002", (String)"MoneyConvertUtils_1", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((Object)currencyNumber)) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u8d27\u5e01\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MoneyConvertUtils_2", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (ZH.equalsIgnoreCase(langAbbrCode)) {
            boolean hasCurrencyNumber = false;
            DynamicObject currencyConfigDy = BusinessDataServiceHelper.loadSingleFromCache((Object)1453710602135519232L, (String)"cts_currency_config");
            for (DynamicObject currEntryDy : currencyConfigDy.getDynamicObjectCollection("cts_currency_config_entry")) {
                if (!currEntryDy.getString("currencynumber").equalsIgnoreCase(currencyNumber)) continue;
                hasCurrencyNumber = true;
                break;
            }
            if (!hasCurrencyNumber) {
                return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadResFormat((String)"\u4e0d\u652f\u6301\u5e01\u79cd%s\u7684\u5927\u5199\u8f6c\u6362\u3002", (String)"MoneyConvertUtils_3", (String)BOS_MSERVICE_I18N, (Object[])new Object[]{currencyNumber}));
            }
        }
        if (StringUtils.isEmpty((Object)amount)) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MoneyConvertUtils_4", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if ("VND".equalsIgnoreCase(currencyNumber) && !amount.matches("^[+-]?(0|[1-9]\\d{0,15})(\\.\\d{1,2})?$")) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u91d1\u989d\u8f93\u5165\u9519\u8bef\u3002", (String)"MoneyConvertUtils_5", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (VI.equalsIgnoreCase(langAbbrCode)) {
            return new AmountConvertResult(TRUE.booleanValue(), "", MoneyConvertUtils.transVI(currencyNumber, amount, isTransCurrNum));
        }
        if (TH.equalsIgnoreCase(langAbbrCode)) {
            return MoneyConvertUtils.transTH(currencyNumber, amount, isTransCurrNum);
        }
        if (!moneyPattern.matcher(amount).matches()) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u91d1\u989d\u8f93\u5165\u9519\u8bef\u3002", (String)"MoneyConvertUtils_5", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        int pointIndex = amount.indexOf(46);
        if (pointIndex == -1 && amount.length() > 15 || pointIndex != -1 && amount.substring(0, pointIndex).length() > 15) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u91d1\u989d\u8f93\u5165\u9519\u8bef\u3002", (String)"MoneyConvertUtils_5", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (ZH.equalsIgnoreCase(langAbbrCode) && JPY.equalsIgnoreCase(currencyNumber) && pointIndex != -1) {
            return new AmountConvertResult(FALSE.booleanValue(), ResManager.loadKDString((String)"\u4e2d\u6587\u5927\u5199\u6570\u5b57\u63a5\u53e3\u4e0d\u652f\u6301\u8f93\u5165\u5c0f\u6570\u65e5\u5143\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MoneyConvertUtils_6", (String)BOS_MSERVICE_I18N, (Object[])new Object[0]));
        }
        if (pointIndex == -1) {
            amount = amount + ".00";
        } else if (pointIndex == amount.length() - 2) {
            amount = amount + "0";
        }
        if (ZH.equalsIgnoreCase(langAbbrCode)) {
            return new AmountConvertResult(TRUE.booleanValue(), "", MoneyConvertUtils.transZh(currencyNumber, amount, isTransCurrNum));
        }
        if (EN.equalsIgnoreCase(langAbbrCode)) {
            return new AmountConvertResult(TRUE.booleanValue(), "", EnCashTransfer.transfer((String)currencyNumber, (String)amount, (String)isTransCurrNum));
        }
        return null;
    }

    private static String transZh(String currencyNumber, String amount, String isTransCurrNum) {
        String intUnit = "";
        String tenthsUnit = "";
        String percentileUnit = "";
        DynamicObject currencyConfigDy = BusinessDataServiceHelper.loadSingleFromCache((Object)1453710602135519232L, (String)"cts_currency_config");
        for (DynamicObject currEntryDy : currencyConfigDy.getDynamicObjectCollection("cts_currency_config_entry")) {
            if (!currEntryDy.getString("currencynumber").equalsIgnoreCase(currencyNumber)) continue;
            intUnit = currEntryDy.getString("currencyname");
            tenthsUnit = currEntryDy.getString("tenthsname");
            percentileUnit = currEntryDy.getString("percentilename");
            break;
        }
        if ("false".equals(isTransCurrNum)) {
            currencyNumber = "";
        }
        return ZhCashTransfer.transfer((String)currencyNumber, (String)intUnit, (String)tenthsUnit, (String)percentileUnit, (String)amount);
    }

    private static String transVI(String currencyNumber, String number, String isTransCurrNum) {
        String convert = VINumberTransfer.convert((String)number);
        return "true".equals(isTransCurrNum) ? currencyNumber + " " + convert : convert;
    }

    private static AmountConvertResult transTH(String currencyNumber, String amount, String isTransCurrNum) {
        try {
            String convertResult = ThCashTransfer.convert(currencyNumber, amount, isTransCurrNum);
            return new AmountConvertResult(TRUE.booleanValue(), "", convertResult);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return new AmountConvertResult(FALSE.booleanValue(), e.getMessage());
        }
    }
}

