/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.i18n.mservice.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import org.apache.commons.lang3.StringUtils;

public class ThCashTransfer {
    private static final String[] THAI_NUMS = new String[]{"\u0e28\u0e39\u0e19\u0e22\u0e4c", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "\u0e2a\u0e2d\u0e07", "\u0e2a\u0e32\u0e21", "\u0e2a\u0e35\u0e48", "\u0e2b\u0e49\u0e32", "\u0e2b\u0e01", "\u0e40\u0e08\u0e47\u0e14", "\u0e41\u0e1b\u0e14", "\u0e40\u0e01\u0e49\u0e32"};
    private static final String[] THAI_UNITS = new String[]{"\u0e41\u0e2a\u0e19", "\u0e2b\u0e21\u0e37\u0e48\u0e19", "\u0e1e\u0e31\u0e19", "\u0e23\u0e49\u0e2d\u0e22", "\u0e2a\u0e34\u0e1a", ""};
    private static final Map<String, String[]> currencyNumberUnits = new HashMap<String, String[]>();

    public static String convert(String currencyNumber, String amountStr, String isTransCurrNum) {
        if ("false".equalsIgnoreCase(isTransCurrNum)) {
            currencyNumber = "";
        }
        if (!"false".equalsIgnoreCase(isTransCurrNum) && !"THB".equals(currencyNumber)) {
            throw new KDException(new ErrorCode("THCASHTRANSFER_PARAMCHECK", String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5e01\u522b\uff1a%s\uff0c\u4ec5\u652f\u6301 THB\u3002", (String)"ThCashTransfer_1", (String)"bos-mservice-i18n", (Object[])new Object[0]), currencyNumber)), new Object[0]);
        }
        if (!Pattern.matches("-?\\d{1,11}(\\.\\d{1,2})?", amountStr)) {
            throw new KDException(new ErrorCode("THCASHTRANSFER_PARAMCHECK", String.format(ResManager.loadKDString((String)"\u91d1\u989d\u683c\u5f0f\u9519\u8bef\uff0c\u6574\u6570\u90e8\u5206\u6700\u591a11\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u6700\u591a2\u4f4d\uff0c\u5f53\u524d\u8f93\u5165\u91d1\u989d\uff1a%s\u3002", (String)"ThCashTransfer_2", (String)"bos-mservice-i18n", (Object[])new Object[0]), amountStr)), new Object[0]);
        }
        BigDecimal amount = new BigDecimal(amountStr).setScale(2, RoundingMode.UNNECESSARY);
        return ThCashTransfer.convertThaiBaht(amount, currencyNumber);
    }

    private static String convertThaiBaht(BigDecimal amount, String currencyNumber) {
        boolean isTransCurrNum = StringUtils.isNotBlank((CharSequence)currencyNumber);
        boolean negative = amount.signum() < 0;
        amount = amount.abs();
        long intPart = amount.longValue();
        int decimalPart = amount.remainder(BigDecimal.ONE).movePointRight(2).intValueExact();
        StringBuilder result = new StringBuilder();
        if (negative) {
            result.append("\u0e25\u0e1a");
        }
        if (intPart == 0L && decimalPart > 0) {
            if (!isTransCurrNum) {
                result.append("\u0e28\u0e39\u0e19\u0e22\u0e4c");
            }
        } else {
            result.append(ThCashTransfer.convertIntegerThai(intPart)).append(currencyNumberUnits.get(currencyNumber)[0]);
        }
        if (decimalPart == 0) {
            if (isTransCurrNum) {
                result.append("\u0e16\u0e49\u0e27\u0e19");
            }
        } else {
            if (!isTransCurrNum) {
                result.append("\u0e08\u0e38\u0e14");
            }
            result.append(ThCashTransfer.convertIntegerThai(decimalPart)).append(currencyNumberUnits.get(currencyNumber)[1]);
        }
        return result.toString();
    }

    private static String convertIntegerThai(long number) {
        if (number == 0L) {
            return "\u0e28\u0e39\u0e19\u0e22\u0e4c";
        }
        StringBuilder result = new StringBuilder();
        String numStr = String.valueOf(number);
        int len = numStr.length();
        int firstGroupLength = len % 6 == 0 ? 6 : len % 6;
        int groups = (len + 5) / 6;
        for (int i = 0; i < groups; ++i) {
            int end;
            int start = i == 0 ? 0 : firstGroupLength + (i - 1) * 6;
            String groupStr = numStr.substring(start, end = i == 0 ? firstGroupLength : start + 6);
            int groupVal = Integer.parseInt(groupStr);
            if (groupVal == 0) continue;
            result.append(ThCashTransfer.convertGroup(groupVal));
            int millionLevel = groups - i - 1;
            if (millionLevel <= 0) continue;
            result.append(ThCashTransfer.createMillionUnits(millionLevel));
        }
        return result.toString();
    }

    private static String createMillionUnits(int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append("\u0e25\u0e49\u0e32\u0e19");
        }
        return sb.toString();
    }

    private static String convertGroup(int number) {
        if (number == 0) {
            return "";
        }
        int tenDigitNumber = 0;
        StringBuilder sb = new StringBuilder();
        int[] units = new int[]{100000, 10000, 1000, 100, 10, 1};
        for (int i = 0; i < units.length; ++i) {
            int unitVal = units[i];
            int digit = number / unitVal;
            number %= unitVal;
            if (digit == 0) continue;
            if (unitVal == 10) {
                tenDigitNumber = digit;
                if (digit == 2) {
                    sb.append("\u0e22\u0e35\u0e48");
                } else if (digit != 1) {
                    sb.append(THAI_NUMS[digit]);
                }
                sb.append("\u0e2a\u0e34\u0e1a");
                continue;
            }
            if (unitVal == 1 && digit == 1 && tenDigitNumber != 0) {
                sb.append("\u0e40\u0e2d\u0e47\u0e14");
                continue;
            }
            sb.append(THAI_NUMS[digit]).append(THAI_UNITS[i]);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[][] testCases = new String[][]{{"-12345678998.76", "THB", "\u0e25\u0e1a\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e2b\u0e01\u0e41\u0e2a\u0e19\u0e40\u0e08\u0e47\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e41\u0e1b\u0e14\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14\u0e1a\u0e32\u0e17\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a\u0e2b\u0e01\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"99999999999.76", "THB", "\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a\u0e2b\u0e01\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"100.50", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e1a\u0e32\u0e17\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"12345678998", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e2b\u0e01\u0e41\u0e2a\u0e19\u0e40\u0e08\u0e47\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e41\u0e1b\u0e14\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"9999999999.99", "THB", "\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"99999999999", "THB", "\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"0.01", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"0.99", "THB", "\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"100.123", "THB", "KDException", "true"}, {"100000000000", "THB", "KDException", "true"}, {"abc", "THB", "KDException", "true"}, {"100", "USD", "KDException", "true"}, {"-254.56", "THB", "\u0e25\u0e1a\u0e2a\u0e2d\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2a\u0e35\u0e48\u0e1a\u0e32\u0e17\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2b\u0e01\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"125.50", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"0.25", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"1001", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"123", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2a\u0e32\u0e21\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"2345", "THB", "\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"654321", "THB", "\u0e2b\u0e01\u0e41\u0e2a\u0e19\u0e2b\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e35\u0e48\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1000000", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e25\u0e49\u0e32\u0e19\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"15", "THB", "\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"25", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"30", "THB", "\u0e2a\u0e32\u0e21\u0e2a\u0e34\u0e1a\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"2", "THB", "\u0e2a\u0e2d\u0e07\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"10", "THB", "\u0e2a\u0e34\u0e1a\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"11", "THB", "\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"20", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"21", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"100", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"101", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1011", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"110", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e34\u0e1a\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"567", "THB", "\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e01\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1000", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1002", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e2d\u0e07\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"12345", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"1234567", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e25\u0e49\u0e32\u0e19\u0e2a\u0e2d\u0e07\u0e41\u0e2a\u0e19\u0e2a\u0e32\u0e21\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e35\u0e48\u0e1e\u0e31\u0e19\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e01\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"0", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"-0", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"-0.0", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"-0.00", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e1a\u0e32\u0e17\u0e16\u0e49\u0e27\u0e19", "true"}, {"55.25", "THB", "\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e1a\u0e32\u0e17\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"0.75", "THB", "\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c", "true"}, {"1", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07", "false"}, {"10", "THB", "\u0e2a\u0e34\u0e1a", "false"}, {"11", "THB", "\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14", "false"}, {"20", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a", "false"}, {"21", "THB", "\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e40\u0e2d\u0e47\u0e14", "false"}, {"100", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22", "false"}, {"101", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e19\u0e36\u0e48\u0e07", "false"}, {"110", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e34\u0e1a", "false"}, {"567", "THB", "\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e01\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14", "false"}, {"1000", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19", "false"}, {"1002", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e2d\u0e07", "false"}, {"12345", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32", "false"}, {"1234567", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e25\u0e49\u0e32\u0e19\u0e2a\u0e2d\u0e07\u0e41\u0e2a\u0e19\u0e2a\u0e32\u0e21\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e35\u0e48\u0e1e\u0e31\u0e19\u0e2b\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e2b\u0e01\u0e2a\u0e34\u0e1a\u0e40\u0e08\u0e47\u0e14", "false"}, {"0", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c", "false"}, {"55.25", "THB", "\u0e2b\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e08\u0e38\u0e14\u0e22\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32", "false"}, {"0.75", "THB", "\u0e28\u0e39\u0e19\u0e22\u0e4c\u0e08\u0e38\u0e14\u0e40\u0e08\u0e47\u0e14\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32", "false"}, {"12345678998", "THB", "\u0e2b\u0e19\u0e36\u0e48\u0e07\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e2a\u0e2d\u0e07\u0e1e\u0e31\u0e19\u0e2a\u0e32\u0e21\u0e23\u0e49\u0e2d\u0e22\u0e2a\u0e35\u0e48\u0e2a\u0e34\u0e1a\u0e2b\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e2b\u0e01\u0e41\u0e2a\u0e19\u0e40\u0e08\u0e47\u0e14\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e41\u0e1b\u0e14\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e41\u0e1b\u0e14", "false"}, {"9999999999.99", "THB", "\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e25\u0e49\u0e32\u0e19\u0e40\u0e01\u0e49\u0e32\u0e41\u0e2a\u0e19\u0e40\u0e01\u0e49\u0e32\u0e2b\u0e21\u0e37\u0e48\u0e19\u0e40\u0e01\u0e49\u0e32\u0e1e\u0e31\u0e19\u0e40\u0e01\u0e49\u0e32\u0e23\u0e49\u0e2d\u0e22\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32\u0e08\u0e38\u0e14\u0e40\u0e01\u0e49\u0e32\u0e2a\u0e34\u0e1a\u0e40\u0e01\u0e49\u0e32", "false"}};
        int passed = 0;
        for (String[] testCase : testCases) {
            String amount = testCase[0];
            String currency = testCase[1];
            String expected = testCase[2];
            String isTransCurrNum = testCase[3];
            try {
                String actual = ThCashTransfer.convert(currency, amount, isTransCurrNum);
                if (actual.equals(expected)) {
                    System.out.printf("\u2705 PASS: %-15s \u2192 %s\n", amount, actual);
                    ++passed;
                    continue;
                }
                System.out.printf("\u274c FAIL: %-15s \u2192 Expected: %s\n", amount, expected);
                System.out.printf("                 Actual: %s\n", actual);
            }
            catch (IllegalArgumentException e) {
                if (expected.contains("KDException")) {
                    System.out.printf("\u2705 PASS: %-15s \u2192 Expected Exception\n", amount);
                    ++passed;
                    continue;
                }
                System.out.printf("\u274c UNEXPECTED EXCEPTION: %-15s \u2192 %s\n", amount, e.getMessage());
            }
        }
        System.out.printf("\nRESULT: %d/%d PASS\n", passed, testCases.length);
    }

    static {
        currencyNumberUnits.put("THB", new String[]{"\u0e1a\u0e32\u0e17", "\u0e2a\u0e15\u0e32\u0e07\u0e04\u0e4c"});
        currencyNumberUnits.put("", new String[]{"", ""});
    }
}

