/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.script.debug.DebugResult;
import kd.bos.web.DispatchServiceHelper;

public class ServerScriptAction {
    private static final String DEBUG_ID = "debugId";
    private static final String BREAK_POINTS = "breakpoints[]";
    private static final String SUCCESS = "success";
    private static final String SCRIPT_NUMBER = "scriptNumber";

    private static <T> T invokeDebugService(String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBOSServiceByAppId((String)"debug", (String)"DebugService", (String)methodName, (Object[])paras);
    }

    private static boolean isStartDebug() {
        return (Boolean)DispatchServiceHelper.invokeBOSService((String)"BizScriptService", (String)"getDebugParameter", (Object[])new Object[0]);
    }

    private void handelError(HttpServletResponse response) throws IOException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(SUCCESS, Boolean.FALSE);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void debug(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String[] scriptInfos = request.getParameterValues(BREAK_POINTS);
        String[] watches = request.getParameterValues("watches[]");
        Map<String, int[]> bmap = this.resetBreakPoint(scriptInfos);
        DebugResult debugResult = (DebugResult)ServerScriptAction.invokeDebugService("start", debugId, bmap, watches);
        String result = SerializationUtils.toJsonString((Object)debugResult.toMap());
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void debugCommand(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String cmd = request.getParameter("command");
        DebugResult debugResult = null;
        switch (cmd) {
            case "stepInto": {
                debugResult = (DebugResult)ServerScriptAction.invokeDebugService("stepInto", debugId);
                break;
            }
            case "stepOver": {
                debugResult = (DebugResult)ServerScriptAction.invokeDebugService("stepOver", debugId);
                break;
            }
            case "stepOut": {
                debugResult = (DebugResult)ServerScriptAction.invokeDebugService("stepOut", debugId);
                break;
            }
            case "stop": {
                debugResult = (DebugResult)ServerScriptAction.invokeDebugService("stop", debugId);
                break;
            }
            case "resume": {
                debugResult = (DebugResult)ServerScriptAction.invokeDebugService("resume", debugId);
                break;
            }
            case "exit": {
                ServerScriptAction.invokeDebugService("exist", debugId);
                debugResult = new DebugResult();
                debugResult.setRunning(false);
                debugResult.setSuccess(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow debug command: " + cmd);
            }
        }
        if (debugResult != null) {
            String result = SerializationUtils.toJsonString((Object)debugResult.toMap());
            ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
        }
    }

    public void updateBreakPoint(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String[] scriptInfos = request.getParameterValues(BREAK_POINTS);
        Map<String, int[]> bmap = this.resetBreakPoint(scriptInfos);
        ServerScriptAction.invokeDebugService("updateBreakPoint", debugId, bmap);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(SUCCESS, Boolean.TRUE);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getAtCurrentBreakPoint(HttpServletRequest request, HttpServletResponse response) throws IOException, InterruptedException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        DebugResult debugResult = (DebugResult)ServerScriptAction.invokeDebugService("getAtCurrentBreakPoint", debugId);
        String result = SerializationUtils.toJsonString((Object)debugResult);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void keepAlive(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        boolean keepAlive = (Boolean)ServerScriptAction.invokeDebugService("keepAlive", debugId);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(SUCCESS, Boolean.TRUE);
        map.put("keepAlive", keepAlive);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void eval(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String expr = request.getParameter("expr");
        DebugResult debugResult = (DebugResult)ServerScriptAction.invokeDebugService("evaluate", debugId, expr);
        String result = SerializationUtils.toJsonString((Object)debugResult);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void addWatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String expr = request.getParameter("expr");
        String scriptNumber = request.getParameter(SCRIPT_NUMBER);
        ServerScriptAction.invokeDebugService("addWatch", debugId, scriptNumber, expr);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put(SUCCESS, Boolean.TRUE);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void removeWatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String expr = request.getParameter("expr");
        String scriptNumber = request.getParameter(SCRIPT_NUMBER);
        ServerScriptAction.invokeDebugService("removeWatch", debugId, scriptNumber, expr);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SUCCESS, Boolean.TRUE);
        map.put(DEBUG_ID, debugId);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getWatches(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        DebugResult debugResult = (DebugResult)ServerScriptAction.invokeDebugService("getWatches", debugId);
        String result = SerializationUtils.toJsonString((Object)debugResult.toMap());
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void addBreakpoint(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String[] breakPointLines = request.getParameterValues(BREAK_POINTS);
        String scriptNumber = request.getParameter(SCRIPT_NUMBER);
        int[] breakpoints = new int[breakPointLines.length];
        for (int i = 0; i < breakPointLines.length; ++i) {
            breakpoints[i] = Integer.parseInt(breakPointLines[i]);
        }
        ServerScriptAction.invokeDebugService("addBreakPoint", debugId, scriptNumber, breakpoints);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SUCCESS, Boolean.TRUE);
        map.put(DEBUG_ID, debugId);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void removeBreakPoint(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter(DEBUG_ID);
        String[] breakPointLines = request.getParameterValues(BREAK_POINTS);
        String scriptNumber = request.getParameter(SCRIPT_NUMBER);
        int[] breakpoints = new int[breakPointLines.length];
        for (int i = 0; i < breakPointLines.length; ++i) {
            breakpoints[i] = Integer.parseInt(breakPointLines[i]);
        }
        ServerScriptAction.invokeDebugService("removeBreakPoint", debugId, scriptNumber, breakpoints);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SUCCESS, Boolean.TRUE);
        map.put(DEBUG_ID, debugId);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void initialize(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String pageId = request.getParameter("pageId");
        Map map = (Map)DispatchServiceHelper.invokeBOSService((String)"DevPortalService", (String)"initScriptDebug", (Object[])new Object[]{pageId});
        String result = SerializationUtils.toJsonString((Object)map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getUUID(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String uuid = UUID.randomUUID().toString();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SUCCESS, Boolean.TRUE);
        map.put("uuid", uuid);
        String result = SerializationUtils.toJsonString(map);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    private Map<String, int[]> resetBreakPoint(String[] scriptInfos) {
        HashMap<String, int[]> bmap = new HashMap<String, int[]>();
        if (scriptInfos != null && scriptInfos.length > 0) {
            for (int i = 0; i < scriptInfos.length; ++i) {
                String[] bps_str;
                String[] scriptInfo = scriptInfos[i].split("&");
                if (scriptInfo == null || scriptInfo.length <= 0) continue;
                String scriptNumber = scriptInfo[0];
                if (scriptInfo[1] == null || (bps_str = scriptInfo[1].split(",")) == null || bps_str.length <= 0) continue;
                int[] bps = new int[bps_str.length];
                for (int j = 0; j < bps_str.length; ++j) {
                    bps[j] = Integer.parseInt(bps_str[j]);
                }
                bmap.put(scriptNumber, bps);
            }
        }
        return bmap;
    }

    public void exit(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String debugId = request.getParameter("debugid");
        ServerScriptAction.invokeDebugService("exist", debugId);
    }

    public void getScriptLogs(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ServerScriptAction.isStartDebug()) {
            this.handelError(response);
        }
        String result = (String)DispatchServiceHelper.invokeBOSService((String)"BizScriptService", (String)"getScriptLogs", (Object[])new Object[0]);
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }

    public void getScript(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = request.getParameter("path");
        String withVersion = request.getParameter("withVersion");
        String result = null;
        result = withVersion != null ? (String)DispatchServiceHelper.invokeBOSService((String)"BizScriptService", (String)"getScriptWithVersion", (Object[])new Object[]{path}) : (String)DispatchServiceHelper.invokeBOSService((String)"BizScriptService", (String)"getScript", (Object[])new Object[]{path});
        ActionUtil.writeResponseJson((ServletResponse)response, (CharSequence)result);
    }
}

