/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.report;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.algo.exception.AlgoExceedAllowMaxRows4SortException;
import kd.bos.algo.exception.AlgoExceedAllowMaxRowsToDiskException;
import kd.bos.bdsync.BDSyncThreadContext;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.splittingread.RW;
import kd.bos.db.splittingread.RWContext;
import kd.bos.db.splittingread.RWScenes;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.JavaTypeParseChecker;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.AbstractReportTreeDataPlugin;
import kd.bos.entity.report.Col2ndFilterOption;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.IReportListDataPlugin;
import kd.bos.entity.report.MulBasedataReportColumn;
import kd.bos.entity.report.ReportBaseDataFilterInfo;
import kd.bos.entity.report.ReportBatchLoadInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportBatchQueryParameter;
import kd.bos.entity.report.ReportBatchQueryResult;
import kd.bos.entity.report.ReportByBatchTaskResult;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportException;
import kd.bos.entity.report.ReportQueryBuilder;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportResultLimit;
import kd.bos.entity.report.ReportServiceProxyPlugin;
import kd.bos.entity.report.ReportSysPublicParameter;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.entity.report.ReportTreeBatchLoadInfo;
import kd.bos.entity.report.ReportTreeByBatchTaskResult;
import kd.bos.entity.report.TreeModel;
import kd.bos.entity.report.ds.DataSource;
import kd.bos.entity.report.queryds.ReportFilterField;
import kd.bos.entity.report.queryds.ReportFilterFieldConfig;
import kd.bos.event.AfterQueryEvent;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.limiter.exception.AcquireFailedException;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.limiter.scene.ConcurrentScene;
import kd.bos.limiter.scene.ConcurrentSceneManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.report.CacheDataFilter;
import kd.bos.mservice.report.ReportProgressRecorder;
import kd.bos.mservice.report.ReportService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportQuery;
import kd.bos.utils.DbTypeConverter;
import kd.bos.utils.LogPrintUtil;
import kd.sdk.kingscript.host.HostObjectUtil;

public class ReportServiceImpl
implements ReportService {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("report-cache-concurrentlimit", new DistributeCacheHAPolicy());
    private static DistributeSessionlessCache pageCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
    private static final Log log = LogFactory.getLog(ReportServiceImpl.class);
    private static final LocaleString width = new LocaleString("60px");
    private static final String BOS_MSERVICE_REPORT = "bos-mservice-report";
    private static final String ROWID = "rowid";
    private static final String SPAN_TYPE = "ReportService";
    private IReportCache reportCache;
    private ReportServiceProxyPlugin reportQueryProxy;
    private RW rw = DB.rw();

    private RWContext createRWContext(String reportName) {
        return this.rw.hasExist() ? null : this.rw.create(RWScenes.report, reportName);
    }

    public void doQuery(String pageId, String ctrlId) {
        ReportTaskParam param = this.getReportCache().getReportTaskParam(pageId, ctrlId);
        ReportQueryParam queryParam = this.getReportCache().getReportQueryParam(pageId);
        RequestContext.get().setLang(queryParam.getMulLang());
        if (param == null) {
            log.info("\u901a\u8fc7pageId\u548cctrId\u83b7\u53d6\u62a5\u8868\u7f13\u5b58\u5bf9\u8c61 param \u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6!pageId={}, ctrId={}", (Object)pageId, (Object)ctrlId);
            throw new KDBizException(ResManager.loadKDString((String)"\u7f13\u5b58\u5931\u6548\u5bfc\u81f4\u65e0\u6cd5\u5c55\u793a\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u6216\u91cd\u65b0\u67e5\u8be2\u3002", (String)"ReportServiceImpl_10", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]));
        }
        try (RWContext rwc = this.createRWContext(param.getReportName());
             BDSyncThreadContext btc = BDSyncThreadContext.create((String)"report");
             EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"doQuery");){
            span.addLocaleTag("pageid", (Object)pageId);
            span.addLocaleTag("ctrlId", (Object)ctrlId);
            if (!this.isOnly2ndFilter(ctrlId, queryParam)) {
                String exportType = (String)pageCache.get(CacheKeyUtil.getAcctId() + ".pagecache." + pageId, "DirectExportExcel");
                if (StringUtils.equals((CharSequence)exportType, (CharSequence)"exportexcel")) {
                    this.doQuery(pageId, ctrlId, param, queryParam);
                } else {
                    String sceneCode = this.getLimitSceneCode(param.getReportName(), queryParam);
                    try (ConcurrencyLimiter limiter = ConcurrencyLimiter.acquire((String)sceneCode, (String)param.getReportName());){
                        if (!limiter.getNoLimit()) {
                            this.recordConcurrencyLimitId(sceneCode, param.getReportName(), limiter.getConcurrentID(), pageId);
                        }
                        ThreadCache.put((Object)"bos_noLimit", (Object)String.valueOf(limiter.getNoLimit()));
                        this.doQuery(pageId, ctrlId, param, queryParam);
                    }
                    catch (AcquireFailedException e) {
                        String msg = ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u652f\u6301\u7684\u5e76\u53d1\u67e5\u8be2\u4efb\u52a1\u5df2\u8fbe\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReportServiceImpl_12", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                        throw new KDBizException(msg);
                    }
                }
            }
            this.col2ndFilter(pageId, ctrlId, param, queryParam);
            this.getReportCache().setReportQueryParam(pageId, queryParam);
        }
        catch (KDBizException e) {
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
            ReportCacheManager.getInstance().getCache().setException(pageId, new ReportException(ReportException.ShowType.SHOW_NOTIFICATION_MSG, e.getMessage()));
            throw e;
        }
        catch (Exception e) {
            String msg = ReportCacheManager.getInstance().getCache().getExcptionMsg(pageId);
            if (StringUtils.isBlank((CharSequence)msg)) {
                ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
                ReportCacheManager.getInstance().getCache().setException(pageId, new ReportException(ReportException.ShowType.SHOW_ERROR_MESSAGE, e.getMessage()));
            }
            throw new RuntimeException(e);
        }
    }

    private void doQuery(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam) {
        if (param.isReportTree()) {
            this.queryTree(pageId, param);
        } else if (this.checkLargeData(pageId, param, queryParam)) {
            this.queryLargeDataList(pageId, ctrlId, param, queryParam);
        } else {
            this.queryList(pageId, ctrlId, param, queryParam);
        }
    }

    private <T> T initReportListDataPlugin(Class<?> reportPluginClass) {
        T reportPlugin = null;
        try {
            reportPlugin = (T)reportPluginClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new KDException((Throwable)e, BosErrorCode.reportPluginInitError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u521d\u59cb\u5316\u5f02\u5e38\uff1a{0}\u3002", (String)"ReportServiceImpl_5", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{reportPluginClass})});
        }
        return reportPlugin;
    }

    private <T> T getReportPlugin(ReportTaskParam param) {
        Class reportPluginClass = TypesContainer.getOrRegister((String)param.getPluginClassName());
        return this.initReportListDataPlugin(reportPluginClass);
    }

    private void setReportColumnProp(List<AbstractReportColumn> acols, MainEntityType entityType) {
        for (AbstractReportColumn acol : acols) {
            if (acol instanceof ReportColumn) {
                DynamicProperty prop;
                ReportColumn col = (ReportColumn)acol;
                String fieldName = col.getFieldKey();
                if (!StringUtils.isNotEmpty((CharSequence)fieldName) || !((prop = entityType.getProperty(fieldName)) instanceof BasedataProp)) continue;
                BasedataProp p = (BasedataProp)prop;
                col.setEntityId(p.getBaseEntityId());
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumnProp(((ReportColumnGroup)acol).getChildren(), entityType);
        }
    }

    private ReportFilterField findDataSourceField(String fieldKey, String entityId, ReportFilterFieldConfig reportFilterFieldConfig) {
        for (ReportFilterField reportFilterField : reportFilterFieldConfig.getReportFilterFields()) {
            if (!fieldKey.equals(reportFilterField.getKey()) || !entityId.equals(reportFilterField.getDataSourceId())) continue;
            return reportFilterField;
        }
        return null;
    }

    private List<Object> getFilterValueList(FilterField filterField, List<Object> valueList) {
        ArrayList<Object> newValueList = new ArrayList<Object>();
        if (filterField.getFieldProp() instanceof DateTimeProp && !(filterField.getFieldProp() instanceof DateProp)) {
            SimpleDateFormat longTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Object value : valueList) {
                newValueList.add(longTimeFormat.format(value));
            }
        } else if (filterField.getFieldProp() instanceof DateTimeProp) {
            SimpleDateFormat shortTimeFormat = new SimpleDateFormat("yyyy-MM-dd");
            for (Object value : valueList) {
                newValueList.add(shortTimeFormat.format(value));
            }
        } else if (filterField.getFieldProp() instanceof MulComboProp) {
            for (Object value : valueList) {
                String[] split = value.toString().split(",");
                newValueList.addAll(Arrays.asList(split));
            }
        } else {
            for (Object value : valueList) {
                newValueList.add(value.toString());
            }
        }
        return newValueList;
    }

    private void setFilterField(FilterItemInfo filterItemInfo, FilterBuilder filterBuilder, MainEntityType entityType, ReportFilterField reportFilterField) {
        String fieldName = reportFilterField.getFieldName();
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
        if (filterField == null) {
            throw new KDBizException(BosErrorCode.fieldNotExist, new Object[]{fieldName});
        }
        String compareTypeId = StringUtils.isNotEmpty((CharSequence)reportFilterField.getCompareTypeId()) ? reportFilterField.getCompareTypeId() : filterItemInfo.getCompareType();
        Object filterVal = filterItemInfo.getValue();
        if (filterVal == null) {
            return;
        }
        if (filterVal instanceof DynamicObject) {
            DynamicObject value = (DynamicObject)filterVal;
            if (filterField.getSrcFieldProp() instanceof ItemClassProp && value.getDataEntityType() instanceof BasedataEntityType) {
                BasedataEntityType dataEntityType = (BasedataEntityType)value.getDataEntityType();
                if (StringUtils.isNotBlank((CharSequence)dataEntityType.getNumberProperty())) {
                    filterVal = value.getString(dataEntityType.getNumberProperty());
                }
            } else {
                filterVal = value.getPkValue();
            }
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add(filterVal.toString());
            filterBuilder.addFilterField(fieldName, compareTypeId, "", "", valueList, "");
        } else if (filterVal instanceof DynamicObjectCollection) {
            ArrayList<String> pkValues = new ArrayList<String>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)filterVal) {
                pkValues.add(dynamicObject.getPkValue().toString());
            }
            filterBuilder.addFilterField(fieldName, CompareTypeEnum.IN.getId(), "", "", pkValues, "");
        } else if (filterVal instanceof String && !StringUtils.isEmpty((CharSequence)((String)filterVal)) || !(filterVal instanceof String)) {
            ArrayList<Object> valueList = new ArrayList<Object>();
            valueList.add(filterVal);
            List<Object> filterValueList = this.getFilterValueList(filterField, valueList);
            filterBuilder.addFilterField(fieldName, compareTypeId, "", "", filterValueList, "");
        }
    }

    private List<QFilter> getQFilter(ReportQueryParam queryParam, MainEntityType entityType, String entityId) {
        ArrayList<QFilter> qfilter = new ArrayList<QFilter>();
        FilterInfo filter = queryParam.getFilter();
        if (filter.getFilterItems().isEmpty()) {
            return qfilter;
        }
        FilterBuilder filterBuilder = new FilterBuilder(entityType);
        for (FilterItemInfo f : filter.getFilterItems()) {
            ReportFilterField reportFilterField = this.findDataSourceField(f.getPropName(), entityId, queryParam.getReportFilterFieldConfig());
            if (reportFilterField == null || StringUtils.isEmpty((CharSequence)reportFilterField.getFieldName())) continue;
            this.setFilterField(f, filterBuilder, entityType, reportFilterField);
        }
        filterBuilder.buildFilter();
        return filterBuilder.getQFilters();
    }

    private List<QFilter> getQueryDataSourceFilter(ReportQueryParam queryParam, String entityId, MainEntityType entityType) {
        List<QFilter> qfilters = this.getQFilter(queryParam, entityType, entityId);
        QFilter commFilter = queryParam.getFilter().getCommFilter(entityId);
        List customFilter = queryParam.getCustomFilter();
        if (commFilter != null) {
            qfilters.add(commFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)customFilter)) {
            qfilters.addAll(customFilter);
        }
        return qfilters;
    }

    private AbstractReportListDataPlugin getHostObject(IReportListDataPlugin reportPlugin) {
        if (!(reportPlugin instanceof Proxy)) {
            return (AbstractReportListDataPlugin)reportPlugin;
        }
        return (AbstractReportListDataPlugin)HostObjectUtil.getHostObject((Object)reportPlugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet doPluginQuery(String pageId, ReportTaskParam param, List<AbstractReportColumn> columns, ReportQueryParam queryParam) {
        Object selectedObj = null;
        IReportListDataPlugin reportPlugin = param.initQueryPlugin();
        try {
            AbstractReportListDataPlugin hostObject = this.getHostObject(reportPlugin);
            this.setProgerssRecorder(pageId, hostObject, AbstractReportListDataPlugin.class);
            this.setQueryParam(queryParam, hostObject);
            selectedObj = this.getSelectObject(pageId, param, hostObject);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new KDException(String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u4e0d\u5b58\u5728\u5c5e\u6027%2$s\u6216%3$s\u6216%4$s", (String)"ReportServiceImpl_1", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]), "AbstractReportListDataPlugin", "progerssRecorder", "queryParam", "selectedObj"));
        }
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"doPluginQuery", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            if (span.isRealtime()) {
                span.addLocaleTag("plugin", (Object)reportPlugin.getClass().getName());
                span.addLocaleTag("taskParam", (Object)param);
                span.addLocaleTag("queryParam", (Object)queryParam);
                span.addLocaleTag("columns", columns);
            }
            if (this.getReportCache().isLargeData(pageId)) {
                this.prepareCurrentBatch(pageId, queryParam, 0);
            }
            this.checkValueScope(param.getColumns(), queryParam);
            DataSet dataSet = reportPlugin.query(queryParam, selectedObj);
            columns.addAll(reportPlugin.getColumns(param.getColumns()));
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        catch (AlgoExceedAllowMaxRowsToDiskException e) {
            log.error("\u6570\u636e\u5199\u5165\u78c1\u76d8\u8d85\u8fc75000w\u884c", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (AlgoExceedAllowMaxRows4SortException e) {
            log.error("\u6392\u5e8f\u6570\u636e\u8d85\u8fc71000\u4e07", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (IllegalArgumentException e) {
            String message = e.getMessage();
            if (message.startsWith("entryentity table name is enpty")) {
                message = ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u67e5\u8be2\u6570\u636e\u6e90\u7684\u5355\u636e\u4f53\u8868\u540d\u4e3a\u7a7a\u3002", (String)"ReportServiceImpl_14", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            throw new KDException((Throwable)e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportServiceImpl_4", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{this.dealStrEnding(e.getMessage())})});
        }
        catch (KDBizException e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            throw new KDBizException((Throwable)e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportServiceImpl_4", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{this.dealStrEnding(e.getMessage())})});
        }
        catch (Throwable e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", e);
            throw new KDException(e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportServiceImpl_4", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{this.dealStrEnding(e.getMessage())})});
        }
    }

    private String dealStrEnding(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        if (str.endsWith("\u3002") || str.endsWith("\uff01") || str.endsWith(".") || str.endsWith("!")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void prepareCurrentBatch(String pageId, ReportQueryParam queryParam, int batchIndex) {
        this.getByBatchInfo(queryParam).setCurrentBatchIndex(batchIndex);
        this.getReportCache().setReportQueryParam(pageId, queryParam);
    }

    private ReportBatchQueryInfo getByBatchInfo(ReportQueryParam queryParam) {
        return (ReportBatchQueryInfo)queryParam.byBatchInfo();
    }

    private DataSet doQueryDataSourceQuery(String pageId, ReportTaskParam param, List<AbstractReportColumn> columns, int limit) {
        ReportQuery reportQuery = new ReportQuery();
        ReportQueryBuilder reportQueryBuilder = new ReportQueryBuilder();
        ReportQueryParam queryParam = this.getReportCache().getReportQueryParam(pageId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityTypeById((String)param.getQueryDataSource());
        List<QFilter> queryDataSourceFilter = this.getQueryDataSourceFilter(queryParam, param.getQueryDataSource(), entityType);
        queryDataSourceFilter = this.doMulBaseDataQfilter(queryDataSourceFilter, entityType);
        reportQueryBuilder.setFilters(queryDataSourceFilter.toArray(new QFilter[0]));
        reportQueryBuilder.setEntityType((IDataEntityType)entityType);
        ArrayList<String> selectFieldsList = new ArrayList<String>();
        HashSet<String> dateIndelxSet = new HashSet<String>(16);
        this.getDateIndex(param.getColumns(), dateIndelxSet);
        DataEntityPropertyCollection collection = entityType.getProperties();
        for (IDataEntityProperty property : collection) {
            if (!(property instanceof EntryProp) || !dateIndelxSet.contains(property.getName())) continue;
            EntryProp entryProp = (EntryProp)property;
            String searchEntryId = entryProp.getName() + ".id";
            selectFieldsList.add(searchEntryId);
        }
        for (AbstractReportColumn abstractReportColumn : param.getColumns()) {
            this.addSelectField(abstractReportColumn, selectFieldsList);
        }
        if (selectFieldsList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u67e5\u8be2\u6570\u636e\u6e90\u5b57\u6bb5\u3002", (String)"ReportServiceImpl_2", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]));
        }
        reportQueryBuilder.setSelectFields(String.join((CharSequence)",", selectFieldsList));
        reportQueryBuilder.setLimit(limit);
        columns.addAll(param.getColumns());
        this.setReportColumnProp(columns, entityType);
        DataSet ds = reportQuery.queryData(reportQueryBuilder);
        ds = this.joinDefaultPermissionFilters(queryParam, param.getQueryDataSource(), entityType, ds);
        ds.range(0, limit);
        int count = 0;
        HashSet<String> stringSet = new HashSet<String>();
        HashSet<String> groupSet = new HashSet<String>();
        for (String string : selectFieldsList) {
            if (string.contains("fbasedataid")) {
                stringSet.add(string);
                ++count;
                continue;
            }
            groupSet.add(string);
        }
        if (CollectionUtils.isEmpty(stringSet)) {
            return ds;
        }
        String[] strings = (String[])stringSet.stream().toArray(String[]::new);
        String[] groupStrs = (String[])groupSet.stream().toArray(String[]::new);
        GroupbyDataSet groupbyDataSet = ds.groupBy(groupStrs);
        for (int i = 0; i < count; ++i) {
            groupbyDataSet = groupbyDataSet.groupConcat(strings[i]);
        }
        ds = groupbyDataSet.finish();
        return ds;
    }

    private void getDateIndex(List<AbstractReportColumn> columnList, Set<String> resSet) {
        for (AbstractReportColumn column : columnList) {
            if (column instanceof ReportColumn) {
                if (((ReportColumn)column).getDateIndex() == null) continue;
                String s = ((ReportColumn)column).getDateIndex().split("\\.")[0];
                resSet.add(s);
                continue;
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            this.getDateIndex(((ReportColumnGroup)column).getChildren(), resSet);
        }
    }

    private List<QFilter> doMulBaseDataQfilter(List<QFilter> queryDataSourceFilter, MainEntityType entityType) {
        ArrayList<QFilter> list = new ArrayList<QFilter>(10);
        list.addAll(queryDataSourceFilter);
        boolean isCommonRpt = false;
        for (QFilter q : queryDataSourceFilter) {
            String pkName;
            int dbType;
            if (q.getValue() != null && "EMPTY".equals(q.getValue().toString()) || StringUtils.equals((CharSequence)"not in", (CharSequence)q.getCP()) || StringUtils.equals((CharSequence)"!=", (CharSequence)q.getCP()) || StringUtils.equals((CharSequence)"not like", (CharSequence)q.getCP())) continue;
            boolean isEntryField = false;
            String basedataKey = "";
            String entryName = "";
            String fieldKey = q.getProperty();
            if (fieldKey.indexOf(".") == -1) {
                if (entityType.findProperty(fieldKey) instanceof MulBasedataProp) {
                    basedataKey = fieldKey;
                    isCommonRpt = true;
                }
            } else {
                String[] array = fieldKey.split("\\.");
                if (entityType.findProperty(array[0]) instanceof MulBasedataProp) {
                    basedataKey = array[0];
                } else if (entityType.getProperty(array[0]) instanceof EntryProp && entityType.findProperty(array[1]) instanceof MulBasedataProp) {
                    basedataKey = array[0] + "." + array[1];
                    isEntryField = true;
                    entryName = array[0];
                    if (array.length == 2) {
                        isCommonRpt = true;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)basedataKey)) continue;
            list.remove(q);
            ArrayList<Object> fidList = new ArrayList<Object>();
            ORM orm = ORM.create();
            QFilter f = q;
            if (isCommonRpt) {
                f = new QFilter(q.getProperty() + ".fbasedataid", q.getCP(), q.getValue());
            }
            DataSet ds = orm.queryDataSet("algoKey", entityType.getName(), basedataKey, f.toArray());
            DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
            if (isEntryField) {
                dbType = ((EntryProp)entityType.getProperty(entryName)).getDynamicCollectionItemPropertyType().getPrimaryKey().getDbType();
                pkName = ((EntryProp)entityType.getProperty(entryName)).getDynamicCollectionItemPropertyType().getPrimaryKey().getName();
            } else {
                dbType = entityType.getPrimaryKey().getDbType();
                pkName = entityType.getPrimaryKey().getName();
            }
            for (DynamicObject dynamicObject : rows) {
                Object obj = DbTypeConverter.safeConvert((int)dbType, (Object)dynamicObject.get(basedataKey));
                fidList.add(obj);
            }
            QFilter filter = new QFilter(basedataKey + "." + pkName, "in", fidList);
            list.add(filter);
        }
        return list;
    }

    private void addSelectField(AbstractReportColumn abstractReportColumn, List<String> selectFieldsList) {
        if (abstractReportColumn instanceof ReportColumn) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            if (StringUtils.isNotEmpty((CharSequence)reportColumn.getDateIndex()) && !selectFieldsList.contains(reportColumn.getDateIndex())) {
                String selectField = reportColumn.getDateIndex();
                if (reportColumn instanceof MulBasedataReportColumn) {
                    selectField = selectField + ".fbasedataid";
                }
                selectFieldsList.add(selectField);
            }
        } else if (abstractReportColumn instanceof ReportColumnGroup) {
            ReportColumnGroup group = (ReportColumnGroup)abstractReportColumn;
            for (AbstractReportColumn column : group.getChildren()) {
                this.addSelectField(column, selectFieldsList);
            }
        }
    }

    private void queryList(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam) {
        ReportCacheManager.getInstance().getCache().setProgress(pageId, 70);
        DataSet dataSet = null;
        DataSet ds = null;
        DataSet orderDs = null;
        DataSet sumDataSet = null;
        int maxQueryLimit = this.getMaxQuerySize(pageId, ctrlId);
        try {
            CachedDataSet cachedDataSet;
            List<Object> columns = new ArrayList<AbstractReportColumn>();
            if (param.existQueryPlugin()) {
                dataSet = this.doPluginQuery(pageId, param, columns, queryParam);
            } else if (StringUtils.isNotEmpty((CharSequence)param.getQueryDataSource())) {
                dataSet = this.doQueryDataSourceQuery(pageId, param, columns, maxQueryLimit + 1);
            } else if (!StringUtils.isEmpty((CharSequence)param.getDataSource())) {
                Object selectedObj = this.getReportCache().getOtherQueryParam(param, pageId);
                DataSource dataSource = param.getDataSource(queryParam, selectedObj);
                dataSet = dataSource.getDataSet();
                columns = dataSource.getColumns(param.getColumns());
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u6570\u636e\u6e90\u63d2\u4ef6\u6216\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u6570\u636e\u6e90\u3002", (String)"ReportServiceImpl_3", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]));
            }
            List pluginList = param.getPluginExtplugins();
            if (!CollectionUtils.isEmpty((Collection)pluginList)) {
                this.reportQueryProxy = new ReportServiceProxyPlugin(pluginList);
                AfterQueryEvent event = new AfterQueryEvent(queryParam, dataSet);
                this.reportQueryProxy.fireAfterQuery(event);
                dataSet = event.getDataSet();
            }
            this.addSeqColumn(columns);
            if (queryParam.isTreeReportList()) {
                this.addTreeReportColumn(columns);
                DataSet copyDs = dataSet.copy();
                LinkedHashMap<String, List<String>> parentData = new LinkedHashMap<String, List<String>>();
                for (Row row : copyDs) {
                    String pid = row.getString("pid");
                    String rid = row.getString(ROWID);
                    if (parentData.containsKey(pid)) {
                        ((List)parentData.get(pid)).add(rid);
                        continue;
                    }
                    ArrayList<String> rowidList = new ArrayList<String>();
                    rowidList.add(rid);
                    parentData.put(pid, rowidList);
                }
                if (copyDs != null) {
                    copyDs.close();
                }
                HashMap<String, Integer> seqMap = new HashMap<String, Integer>();
                AtomicInteger seqIndex = new AtomicInteger();
                seqIndex.set(1);
                if (!parentData.isEmpty()) {
                    List pList = (List)parentData.get("0");
                    this.reSetRowData(parentData, seqMap, pList, seqIndex);
                }
                RowMeta seqRowMeta = this.rowMetaAddField(dataSet.getRowMeta(), "fseq", (DataType)DataType.IntegerType);
                ArrayList<Object[]> seqRows = new ArrayList<Object[]>();
                for (Row row : dataSet) {
                    Row perRow = RowUtil.persist((Row)row);
                    Object[] newRows = this.rowAddField(perRow, seqMap.get(row.getString(ROWID)));
                    seqRows.add(newRows);
                }
                ds = Algo.create((String)this.getClass().getName()).createDataSet(seqRows.iterator(), seqRowMeta);
                orderDs = ds.orderBy(new String[]{"fseq"});
            }
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 80);
            ArrayList<ReportColumn> cols = new ArrayList<ReportColumn>();
            this.setReportColumns(columns, cols);
            List<AbstractReportColumn> summaryColumns = this.getSummaryColumns(cols, param);
            CacheHint aDefault = this.getCacheHint(maxQueryLimit);
            if (queryParam.isTreeReportList() && orderDs != null) {
                if (!param.isAsyncTotal() && !CollectionUtils.isEmpty(summaryColumns)) {
                    sumDataSet = orderDs.copy();
                }
                cachedDataSet = orderDs.cache(aDefault);
            } else {
                if (!param.isAsyncTotal() && !CollectionUtils.isEmpty(summaryColumns)) {
                    sumDataSet = dataSet.copy();
                }
                cachedDataSet = dataSet.cache(aDefault);
            }
            ReportTaskResult rs = new ReportTaskResult(cachedDataSet.getCacheId(), columns);
            this.recordLimitMessage(pageId, ctrlId, cachedDataSet.getRowCount(), maxQueryLimit, queryParam);
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 90);
            if (CollectionUtils.isEmpty(summaryColumns)) {
                rs.setSummaryValueMap(new HashMap(16));
            } else {
                rs.setSummaryValueMap(this.getSummary(summaryColumns, sumDataSet));
            }
            this.setReportTaskResult(param, pageId, ctrlId, rs);
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
        }
        catch (AlgoExceedAllowMaxRowsToDiskException e) {
            log.error("\u6570\u636e\u5199\u5165\u78c1\u76d8\u8d85\u8fc75000w\u884c", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (AlgoExceedAllowMaxRows4SortException e) {
            log.error("\u6392\u5e8f\u6570\u636e\u8d85\u8fc71000\u4e07", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (KDBizException e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            LogPrintUtil.printExceptionMessage((Exception)((Object)e), (String)e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        catch (Exception e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            String message = e.getMessage();
            if (message.startsWith("Cache dataset not found or timed out: ")) {
                message = ResManager.loadKDString((String)"\u754c\u9762\u8bbf\u95ee\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6216\u5237\u65b0\u3002", (String)"ReportServiceImpl_9", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            if (message.startsWith("DataSetCache exceed allow max rows:")) {
                message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            if (message.contains("tables name is empty")) {
                message = ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u67e5\u8be2\u6570\u636e\u6e90\u7684\u5355\u636e\u4f53\u8868\u540d\u4e3a\u7a7a\u3002", (String)"ReportServiceImpl_14", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            if (message.startsWith("the table of the entity") && message.contains("is not exists")) {
                message = ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u67e5\u8be2\u6570\u636e\u6e90\u7684\u5355\u5934\u8868\u540d\u4e3a\u7a7a\u3002", (String)"ReportServiceImpl_16", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(baos));
            String exception = baos.toString();
            LogPrintUtil.printExceptionMessage((Exception)e, (String)e.getMessage());
            ReportCacheManager.getInstance().getCache().setException(pageId, new ReportException(ReportException.ShowType.SHOW_ERROR_MESSAGE, exception));
            throw new KDException((Throwable)e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportServiceImpl_4", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{this.dealStrEnding(e.getMessage())})});
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (ds != null) {
                ds.close();
            }
            if (orderDs != null) {
                orderDs.close();
            }
            if (sumDataSet != null) {
                sumDataSet.close();
            }
        }
    }

    private void setReportColumns(List<AbstractReportColumn> acols, List<ReportColumn> cols) {
        for (AbstractReportColumn acol : acols) {
            if (acol instanceof ReportColumn) {
                cols.add((ReportColumn)acol);
                continue;
            }
            if (!(acol instanceof ReportColumnGroup)) continue;
            this.setReportColumns(((ReportColumnGroup)acol).getChildren(), cols);
        }
    }

    private void checkValueScope(List<AbstractReportColumn> columns, ReportQueryParam queryParam) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (AbstractReportColumn column : columns) {
            if (!(column instanceof ReportColumn)) continue;
            String fieldType = ((ReportColumn)column).getFieldType();
            String fieldKey = ((ReportColumn)column).getFieldKey();
            map.put(fieldKey, fieldType);
        }
        List tableHeadFilterItems = queryParam.getFilter().getTableHeadFilterItems();
        for (FilterItemInfo itemInfo : tableHeadFilterItems) {
            String val = (String)map.get(itemInfo.getPropName());
            if (!StringUtils.isNotBlank((CharSequence)val)) continue;
            switch (val) {
                case "bigint": {
                    JavaTypeParseChecker.parseLong((String)itemInfo.getValue().toString());
                    break;
                }
                case "integer": {
                    JavaTypeParseChecker.parseInt((String)itemInfo.getValue().toString());
                    break;
                }
                case "price": 
                case "amount": 
                case "qty": 
                case "decimal": 
                case "baseunitqty": {
                    JavaTypeParseChecker.parseBigDecimal((String)itemInfo.getValue().toString());
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkLargeData(String pageId, ReportTaskParam param, ReportQueryParam queryParam) {
        try (DataSet batchBy = null;){
            if (!param.existQueryPlugin()) {
                boolean bl = false;
                return bl;
            }
            IReportListDataPlugin reportPlugin = param.initQueryPlugin();
            batchBy = reportPlugin.queryBatchBy(queryParam);
            if (batchBy == null) {
                boolean bl = false;
                return bl;
            }
            CachedDataSet cachedBatchBy = batchBy.cache(CacheHint.getDefault());
            ReportBatchQueryInfo queryByBatchInfo = this.getByBatchInfo(queryParam);
            this.getReportCache().setLargeData(pageId, true);
            queryByBatchInfo.setLargeData(true);
            queryByBatchInfo.setBatchByDataSetCacheId(cachedBatchBy.getCacheId());
            if (queryByBatchInfo.getCountPerBatch() == -1) {
                int rowCount = cachedBatchBy.getRowCount();
                int countPerBatch = 10;
                if (rowCount > 100000) {
                    countPerBatch = 10000;
                } else if (rowCount > 10000) {
                    countPerBatch = 1000;
                } else if (rowCount > 1000) {
                    countPerBatch = 100;
                }
                queryByBatchInfo.setCountPerBatch(countPerBatch);
            }
            this.getReportCache().setReportQueryParam(pageId, queryParam);
            boolean bl = true;
            return bl;
        }
    }

    private void queryLargeDataList(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam) {
        ReportCacheManager.getInstance().getCache().setProgress(pageId, 70);
        try (DataSet dataSet = null;){
            ReportByBatchTaskResult rs;
            ArrayList<AbstractReportColumn> columns = new ArrayList<AbstractReportColumn>();
            if (!param.existQueryPlugin()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u6570\u636e\u6e90\u63d2\u4ef6\u6216\u6ca1\u6709\u8bbe\u7f6e\u62a5\u8868\u6570\u636e\u6e90\u3002", (String)"ReportServiceImpl_3", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]));
            }
            dataSet = this.doPluginQuery(pageId, param, columns, queryParam);
            this.addSeqColumn(columns);
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 80);
            ReportBatchQueryInfo byBatchInfo = this.getByBatchInfo(queryParam);
            CacheHint aDefault = CacheHint.getDefault();
            if (queryParam.isTreeReportList()) {
                this.addTreeReportColumn(columns);
                ReportTreeBatchLoadInfo batchLoadInfo = new ReportTreeBatchLoadInfo();
                Tuple<DataSet, AtomicInteger> data = this.addSeqData(dataSet, 1);
                CachedDataSet cachedDataSet = ((DataSet)data.item1).cache(aDefault);
                ((DataSet)data.item1).close();
                batchLoadInfo.getBatchIndex2RootRowCount().put(0, ((AtomicInteger)data.item2).get());
                rs = new ReportTreeByBatchTaskResult(pageId, cachedDataSet.getCacheId(), columns, byBatchInfo, batchLoadInfo);
            } else {
                CachedDataSet cachedDataSet = dataSet.cache(aDefault);
                rs = new ReportByBatchTaskResult(pageId, cachedDataSet.getCacheId(), columns, byBatchInfo);
            }
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 90);
            rs.setSummaryValueMap(new HashMap(16));
            this.setReportTaskResult(param, pageId, ctrlId, (ReportTaskResult)rs);
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
        }
    }

    private Map<String, Object> getSummary(List<AbstractReportColumn> summaryColumns, DataSet sumDataSet) {
        HashMap<String, Object> summaryValueMap;
        block4: {
            block3: {
                summaryValueMap = new HashMap<String, Object>(summaryColumns.size());
                if (sumDataSet != null) break block3;
                for (AbstractReportColumn summaryColumn : summaryColumns) {
                    summaryValueMap.put(((DecimalReportColumn)summaryColumn).getFieldKey(), null);
                }
                break block4;
            }
            HashMap<String, String> fieldKeyMap = new HashMap<String, String>(16);
            GroupbyDataSet gDataSet = sumDataSet.groupBy(null);
            for (AbstractReportColumn summaryColumn : summaryColumns) {
                String sumKey;
                String string = sumKey = ((DecimalReportColumn)summaryColumn).getDateIndex() == null ? ((DecimalReportColumn)summaryColumn).getFieldKey() : ((DecimalReportColumn)summaryColumn).getDateIndex();
                kd.bos.algo.Field field = sumDataSet.getRowMeta().getField(sumKey, false);
                if (field == null) continue;
                fieldKeyMap.put(sumKey, ((DecimalReportColumn)summaryColumn).getFieldKey());
                gDataSet = gDataSet.sum(sumKey);
            }
            sumDataSet = gDataSet.finish();
            if (!sumDataSet.hasNext()) break block4;
            int count = sumDataSet.getRowMeta().getFieldCount();
            kd.bos.algo.Field[] fields = sumDataSet.getRowMeta().getFields();
            Row next = sumDataSet.next();
            for (int i = 0; i < count; ++i) {
                summaryValueMap.put((String)fieldKeyMap.get(fields[i].getAlias()), next.get(i));
            }
        }
        return summaryValueMap;
    }

    private List<AbstractReportColumn> getSummaryColumns(List<ReportColumn> columns, ReportTaskParam param) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)param.getReportName());
        ArrayList<AbstractReportColumn> summaryColumns = new ArrayList<AbstractReportColumn>(16);
        for (AbstractReportColumn abstractReportColumn : columns) {
            DynamicProperty prop;
            int summary = 0;
            if (!(abstractReportColumn instanceof DecimalReportColumn) || (summary = ((DecimalReportColumn)abstractReportColumn).getSummary()) == 0) continue;
            if (entityType != null && (PrivacyCenterUtils.isDesensitizeField((IDataEntityProperty)(prop = entityType.getProperty(((DecimalReportColumn)abstractReportColumn).getFieldKey())), (String)Lang.get().toString(), (String)"FORM", null) || PrivacyCenterUtils.isEncryptField((IDataEntityProperty)prop))) {
                log.info("\u52a0\u5bc6\u548c\u8131\u654f\u5b57\u6bb5\u4e0d\u53c2\u4e0e\u5408\u8ba1\uff0cprop is {}", (Object)prop.getName());
                continue;
            }
            summaryColumns.add(abstractReportColumn);
        }
        return summaryColumns;
    }

    private ReportQueryParam setQueryParam(ReportQueryParam queryParam, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field queryParamField = AbstractReportListDataPlugin.class.getDeclaredField("queryParam");
        queryParamField.setAccessible(true);
        queryParamField.set(reportPlugin, queryParam);
        return queryParam;
    }

    private <T> void setProgerssRecorder(String pageId, T instancePlugin, Class<?> reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field recorderField = reportPlugin.getDeclaredField("progerssRecorder");
        recorderField.setAccessible(true);
        ReportProgressRecorder progressRecorder = new ReportProgressRecorder(pageId);
        recorderField.set(instancePlugin, progressRecorder);
    }

    private Object getSelectObject(String pageId, ReportTaskParam param, AbstractReportListDataPlugin reportPlugin) throws NoSuchFieldException, IllegalAccessException {
        Field selectedObjField = AbstractReportListDataPlugin.class.getDeclaredField("selectedObj");
        selectedObjField.setAccessible(true);
        Object selectedObj = this.getReportCache().getOtherQueryParam(param, pageId);
        if (selectedObj != null) {
            selectedObjField.set(reportPlugin, selectedObj);
        }
        return selectedObj;
    }

    private void addSeqColumn(List<AbstractReportColumn> columns) {
        ReportColumn seqCol = new ReportColumn();
        seqCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ReportServiceImpl_0", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0])));
        seqCol.setWidth(width);
        seqCol.setFieldKey("fseq");
        seqCol.setFreeze(true);
        seqCol.setFieldType("integer");
        columns.add(0, (AbstractReportColumn)seqCol);
    }

    private void queryTree(String pageId, ReportTaskParam param) {
        if (StringUtils.isEmpty((CharSequence)param.getPluginClassName())) {
            throw new KDException(BosErrorCode.reportPluginNotFound, new Object[]{ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u3002", (String)"ReportServiceImpl_6", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0])});
        }
        try {
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 50);
            AbstractReportTreeDataPlugin reportPlugin = (AbstractReportTreeDataPlugin)this.getReportPlugin(param);
            this.setProgerssRecorder(pageId, reportPlugin, AbstractReportTreeDataPlugin.class);
            List treeNodes = reportPlugin.query(this.getReportCache().getReportQueryParam(pageId), (String)param.getOtherParam());
            this.getReportCache().setReportTreeModel(pageId, new TreeModel(treeNodes));
            ReportCacheManager.getInstance().getCache().setProgress(pageId, 100);
        }
        catch (AlgoExceedAllowMaxRowsToDiskException e) {
            log.error("\u6570\u636e\u5199\u5165\u78c1\u76d8\u8d85\u8fc75000w\u884c", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (AlgoExceedAllowMaxRows4SortException e) {
            log.error("\u6392\u5e8f\u6570\u636e\u8d85\u8fc71000\u4e07", (Throwable)e);
            String message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        catch (AlgoException e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", (Throwable)e);
            String message = e.getMessage();
            if (message.startsWith("Cache dataset not found or timed out: ")) {
                message = ResManager.loadKDString((String)"\u754c\u9762\u8bbf\u95ee\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u6216\u5237\u65b0\u3002", (String)"ReportServiceImpl_9", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
            }
            throw new KDBizException(message);
        }
        catch (Throwable e) {
            log.error("\u62a5\u8868\u67e5\u8be2\u9519\u8bef", e);
            String message = e.getMessage();
            if (message.startsWith("DataSetCache exceed allow max rows:")) {
                message = ResManager.loadKDString((String)"\u6240\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u4fee\u6539\u67e5\u8be2\u6761\u4ef6\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"ReportServiceImpl_8", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            throw new KDBizException(e, BosErrorCode.reportQueryError, new Object[]{ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u9519\u8bef\uff1a{0}\u3002", (String)"ReportServiceImpl_4", (String)BOS_MSERVICE_REPORT, (Object[])new Object[]{this.dealStrEnding(e.getMessage())})});
        }
    }

    protected IReportCache getReportCache() {
        if (this.reportCache == null) {
            this.reportCache = ReportCacheManager.getInstance().getCache();
        }
        return this.reportCache;
    }

    private void addTreeReportColumn(List<AbstractReportColumn> columns) {
        ReportColumn parentColumn = new ReportColumn();
        parentColumn.setCaption(new LocaleString("pid"));
        parentColumn.setWidth(width);
        parentColumn.setFieldKey("pid");
        parentColumn.setHide(true);
        parentColumn.setFieldType("text");
        columns.add(1, (AbstractReportColumn)parentColumn);
        ReportColumn groupColumn = new ReportColumn();
        groupColumn.setCaption(new LocaleString("isgroupnode"));
        groupColumn.setWidth(width);
        groupColumn.setFieldKey("isgroupnode");
        groupColumn.setHide(true);
        groupColumn.setFieldType("boolean");
        columns.add(2, (AbstractReportColumn)groupColumn);
        ReportColumn currentColumn = new ReportColumn();
        currentColumn.setCaption(new LocaleString(ROWID));
        currentColumn.setWidth(width);
        currentColumn.setFieldKey(ROWID);
        currentColumn.setHide(true);
        currentColumn.setFieldType("text");
        columns.add(3, (AbstractReportColumn)currentColumn);
    }

    private Tuple<DataSet, AtomicInteger> addSeqData(DataSet dataSet, int seq) {
        RowMeta seqRowMeta = this.rowMetaAddField(dataSet.getRowMeta(), "fseq", (DataType)DataType.IntegerType);
        ArrayList<Object[]> seqRows = new ArrayList<Object[]>();
        AtomicInteger rootCounts = new AtomicInteger();
        rootCounts.set(0);
        for (Row row : dataSet) {
            String pid = row.getString("pid");
            Row perRow = RowUtil.persist((Row)row);
            Object[] newRows = this.rowAddField(perRow, seq++);
            seqRows.add(newRows);
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)pid)) continue;
            rootCounts.getAndIncrement();
        }
        DataSet dataSetWithSeq = Algo.create((String)this.getClass().getName()).createDataSet(seqRows.iterator(), seqRowMeta);
        return new Tuple((Object)dataSetWithSeq, (Object)rootCounts);
    }

    private void reSetRowData(Map<String, List<String>> parentData, Map<String, Integer> seqMap, List<String> plist, AtomicInteger seqIndex) {
        if (plist == null) {
            return;
        }
        for (String rowId : plist) {
            seqMap.put(rowId, seqIndex.getAndIncrement());
            if (!parentData.containsKey(rowId)) continue;
            List<String> childList = parentData.get(rowId);
            this.reSetRowData(parentData, seqMap, childList, seqIndex);
        }
    }

    private Object[] rowAddField(Row row, Object fieldValue) {
        Object[] rowValues = RowUtil.toArray((Row)row);
        int len = rowValues.length;
        Object[] newValues = new Object[len + 1];
        System.arraycopy(rowValues, 0, newValues, 0, len);
        newValues[len] = fieldValue;
        return newValues;
    }

    private RowMeta rowMetaAddField(RowMeta rowMeta, String fieldName, DataType fieldType) {
        int count = rowMeta.getFieldCount();
        String[] fieldNames = new String[count + 1];
        DataType[] dataTypes = new DataType[count + 1];
        List dsDataType = rowMeta.getTypes();
        for (int i = 0; i < count; ++i) {
            fieldNames[i] = rowMeta.getFieldName(i);
            dataTypes[i] = (DataType)dsDataType.get(i);
        }
        fieldNames[count] = fieldName;
        dataTypes[count] = fieldType;
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    /*
     * Exception decompiling
     */
    public ReportBatchQueryResult doQueryByBatch(ReportBatchQueryParameter parameter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 72[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String doQueryByBatch(String pageId, String ctrlId, int batchIndex) {
        ReportBatchQueryResult reportBatchQueryResult = this.doQueryByBatch(new ReportBatchQueryParameter(pageId, ctrlId, batchIndex));
        if (reportBatchQueryResult != null) {
            return reportBatchQueryResult.getCacheId();
        }
        return null;
    }

    private CacheHint getCacheHint(int maxQuerySize) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"getCacheHint", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            CacheHint aDefault = CacheHint.getDefault();
            aDefault.setAllowMaxRows(++maxQuerySize);
            aDefault.setThrowExceptionWhenExceedAllowMaxRows(false);
            span.addLocaleTag("maxQuerySize", (Object)maxQuerySize);
            CacheHint cacheHint = aDefault;
            return cacheHint;
        }
    }

    private boolean recordLimitMessage(String pageId, String ctrlId, int totalCount, int maxQuerySize, ReportQueryParam queryParam) {
        ReportResultLimit limit = new ReportResultLimit(maxQuerySize);
        boolean isExceed = limit.isExceedLimitCount(totalCount);
        if (isExceed) {
            int maxQueryLimit = maxQuerySize / 10000;
            log.info("\u672c\u6b21\u67e5\u8be2\u8d85\u884c\u6570\u4e0a\u9650\uff08{}\u4e07\u884c\uff09", (Object)maxQueryLimit);
            String message = queryParam.getMessage();
            message = StringUtils.isNotBlank((CharSequence)message) ? message + "\r\n" + String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8d85\u884c\u6570\u4e0a\u9650\uff08%1$s\u4e07\u884c\uff09\uff0c\r\n%2$s\u4e07\u884c\u5185\u6570\u636e\u67e5\u8be2\u6210\u529f\uff0c\u8d85\u51fa\u90e8\u5206\u672a\u67e5\u8be2\u3002", (String)"ReportServiceImpl_11", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]), maxQueryLimit, maxQueryLimit) : String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8d85\u884c\u6570\u4e0a\u9650\uff08%1$s\u4e07\u884c\uff09\uff0c\r\n%2$s\u4e07\u884c\u5185\u6570\u636e\u67e5\u8be2\u6210\u529f\uff0c\u8d85\u51fa\u90e8\u5206\u672a\u67e5\u8be2\u3002", (String)"ReportServiceImpl_11", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]), maxQueryLimit, maxQueryLimit);
            queryParam.setMessage(message);
            this.getReportCache().setReportResultLimit(pageId, ctrlId, limit);
        }
        return isExceed;
    }

    private boolean isOnly2ndFilter(String ctrlId, ReportQueryParam queryParam) {
        return queryParam.getFilter() != null && queryParam.getFilter().getCol2ndFilterOption(ctrlId) != null && queryParam.getFilter().getCol2ndFilterOption(ctrlId).isOnly2ndFilter();
    }

    private void col2ndFilter(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"col2ndFilter", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            if (queryParam.getFilter() == null) {
                return;
            }
            Col2ndFilterOption col2ndFilterOption = queryParam.getFilter().getCol2ndFilterOption(ctrlId);
            if (col2ndFilterOption == null) {
                return;
            }
            col2ndFilterOption.setOnly2ndFilter(false);
            ReportTaskResult result = this.getReportCache().getReportTaskResult(pageId, ctrlId);
            if (result == null) {
                return;
            }
            if (!col2ndFilterOption.isEmpty()) {
                ReportBatchQueryInfo queryByBatchInfo = this.getByBatchInfo(queryParam);
                if (queryByBatchInfo.isLargeData() && result instanceof ReportByBatchTaskResult) {
                    this.col2ndFilterLarge(pageId, ctrlId, param, queryParam, (ReportByBatchTaskResult)result, col2ndFilterOption);
                } else {
                    this.col2ndFilterNormal(pageId, ctrlId, param, queryParam, result, col2ndFilterOption);
                }
            } else {
                result.setFilter2ndResult(null, 0, null);
                this.getReportCache().setReportTaskResult(pageId, ctrlId, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void col2ndFilterNormal(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam, ReportTaskResult result, Col2ndFilterOption col2ndFilterOption) {
        String datasetCacheId = result.getFilter2ndResultId();
        if (StringUtils.isBlank((CharSequence)datasetCacheId) || !col2ndFilterOption.isBaseCol2FilterResult()) {
            datasetCacheId = result.getBeforeFilterResultId();
        }
        if (StringUtils.isBlank((CharSequence)datasetCacheId)) {
            return;
        }
        try (DataSet col2ndFilterDataSet = null;
             EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"col2ndFilterNormal", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            List cols = result.getReportColumnList();
            MainEntityType rptEntityType = EntityMetadataCache.getDataEntityType((String)param.getReportName());
            CacheDataFilter cacheDataFilter = new CacheDataFilter();
            col2ndFilterDataSet = cacheDataFilter.filterAndSort(datasetCacheId, rptEntityType, cols, col2ndFilterOption.getFilterItemInfos(), col2ndFilterOption.getOrderbys());
            if (col2ndFilterDataSet != null) {
                Map<Object, Object> summaryResultMap = null;
                List<AbstractReportColumn> sumCols = this.getSummaryColumns(cols, param);
                if (!sumCols.isEmpty()) {
                    DataSet sumDataSet = col2ndFilterDataSet.copy();
                    summaryResultMap = this.getSummary(sumCols, sumDataSet);
                } else {
                    summaryResultMap = new HashMap(0);
                }
                CachedDataSet cachedDataSet = col2ndFilterDataSet.cache(this.getCacheHint(this.getMaxQuerySize(pageId, ctrlId)));
                result.setFilter2ndResult(cachedDataSet.getCacheId(), cachedDataSet.getRowCount(), summaryResultMap);
            } else {
                result.setFilter2ndResult(null, 0, null);
            }
            this.getReportCache().setReportTaskResult(pageId, ctrlId, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void col2ndFilterLarge(String pageId, String ctrlId, ReportTaskParam param, ReportQueryParam queryParam, ReportByBatchTaskResult result, Col2ndFilterOption col2ndFilterOption) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"col2ndFilterLarge", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            ReportBatchLoadInfo batchLoadInfo = result.getBatchLoadInfo();
            if (!result.getBatchLoadInfo().isAllBatchLoaded()) {
                int batchIndex = -1;
                for (Map.Entry entry : batchLoadInfo.getBatchIndex2RowCounts().entrySet()) {
                    if ((Integer)entry.getKey() <= batchIndex) continue;
                    batchIndex = (Integer)entry.getKey();
                }
                ReportBatchQueryInfo batchQueryInfo = this.getByBatchInfo(queryParam);
                for (int count = 0; !result.getBatchLoadInfo().isAllBatchLoaded() && result.getBatchLoadInfo().getLoadedRowCount() < batchQueryInfo.getMaxRowCountCached() && count < 100; ++count) {
                    String cacheId = this.doQueryByBatch(pageId, ctrlId, ++batchIndex);
                    int n = batchIndex * batchQueryInfo.getCountPerBatch();
                    int length = batchQueryInfo.getCountPerBatch();
                    result.addBatchData(n, length, batchIndex, cacheId);
                    this.getReportCache().setReportTaskResult(pageId, ctrlId, (ReportTaskResult)result);
                }
            }
            DataSet srcDataSet = null;
            DataSet col2ndFilterDataSet = null;
            Algo algo = Algo.create((String)(this.getClass().getName() + "#col2ndFilterLarge"));
            try {
                if (col2ndFilterOption.isBaseCol2FilterResult() && StringUtils.isNotBlank((CharSequence)result.getFilter2ndResultId())) {
                    CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)result.getFilter2ndResultId());
                    srcDataSet = cachedDataSet.toDataSet(algo, false);
                } else {
                    for (Map.Entry entry : batchLoadInfo.getBatchIndex2CachedDataSetIds().entrySet()) {
                        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)((String)entry.getValue()));
                        if (srcDataSet == null) {
                            srcDataSet = cachedDataSet.toDataSet(algo, false);
                            continue;
                        }
                        srcDataSet = srcDataSet.union(cachedDataSet.toDataSet(algo, false));
                    }
                }
                List cols = result.getReportColumnList();
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)param.getReportName());
                CacheDataFilter cacheDataFilter = new CacheDataFilter();
                col2ndFilterDataSet = cacheDataFilter.filterAndSort(srcDataSet, mainEntityType, cols, col2ndFilterOption.getFilterItemInfos(), col2ndFilterOption.getOrderbys());
                if (col2ndFilterDataSet != null) {
                    HashMap summaryResultMap = new HashMap(0);
                    CachedDataSet cachedDataSet = col2ndFilterDataSet.cache(this.getCacheHint(this.getMaxQuerySize(pageId, ctrlId)));
                    result.setFilter2ndResult(cachedDataSet.getCacheId(), cachedDataSet.getRowCount(), summaryResultMap);
                } else {
                    result.setFilter2ndResult(null, 0, null);
                }
                this.getReportCache().setReportTaskResult(pageId, ctrlId, (ReportTaskResult)result);
            }
            finally {
                if (srcDataSet != null) {
                    srcDataSet.close();
                }
                if (col2ndFilterDataSet != null) {
                    col2ndFilterDataSet.close();
                }
            }
        }
    }

    private int getMaxQuerySize(String pageId, String ctrlId) {
        ReportResultLimit limit = this.getReportCache().getReportResultLimit(pageId, ctrlId);
        if (limit == null) {
            return ReportSysPublicParameter.getMaxQueryLimit() * 10000;
        }
        return limit.getLimitCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSet joinDefaultPermissionFilters(ReportQueryParam queryParam, String entityId, MainEntityType entityType, DataSet mainDataSet) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"joinDefaultPermissionFilters", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            List bdRightQFilters = queryParam.getFilter().getBdRightQFilters();
            if (CollectionUtils.isEmpty((Collection)bdRightQFilters)) {
                DataSet dataSet = mainDataSet;
                return dataSet;
            }
            RowMeta rowMeta = mainDataSet.getRowMeta();
            String[] result = new String[rowMeta.getFieldCount()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = rowMeta.getFieldAlias(i);
            }
            Iterator iterator = bdRightQFilters.iterator();
            while (iterator.hasNext()) {
                ReportFilterField reportFilterField;
                ReportBaseDataFilterInfo bdRightQFilter = (ReportBaseDataFilterInfo)iterator.next();
                span.addTag("fileldKey", bdRightQFilter.getFieldKey());
                span.addTag("entityNumber", bdRightQFilter.getEntityNumber());
                span.addLocaleTag("qFilters", (Object)bdRightQFilter.getQFilters());
                if (StringUtils.isBlank((CharSequence)bdRightQFilter.getFieldKey()) || StringUtils.isBlank((CharSequence)bdRightQFilter.getEntityNumber()) || CollectionUtils.isEmpty((Collection)bdRightQFilter.getQFilters()) || (reportFilterField = this.findDataSourceField(bdRightQFilter.getFieldKey(), entityId, queryParam.getReportFilterFieldConfig())) == null) continue;
                String filterFieldName = this.getFilterFieldName(entityType, reportFilterField.getFieldName());
                span.addTag("filterFieldName", filterFieldName);
                if (StringUtils.isBlank((CharSequence)filterFieldName)) continue;
                MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdRightQFilter.getEntityNumber());
                DataSet joinDataSet = ORM.create().queryDataSet(this.getClass().getName() + bdRightQFilter.getEntityNumber(), bdRightQFilter.getEntityNumber(), dataEntityType.getPrimaryKey().getName(), bdRightQFilter.getQFilters().toArray(new QFilter[0]));
                mainDataSet = mainDataSet.join(joinDataSet, JoinType.INNER).on(filterFieldName, dataEntityType.getPrimaryKey().getName()).select(result).finish();
                joinDataSet.close();
            }
            return mainDataSet;
        }
        catch (Exception e) {
            log.error("ReportServiceImpl.joinDefaultPermissionFilters error", (Throwable)e);
        }
        return mainDataSet;
    }

    private String getFilterFieldName(MainEntityType entityType, String fieldName) {
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            String[] split = fieldName.split("\\.");
            IDataEntityProperty property = entityType.findProperty(split[0]);
            if (property instanceof EntryProp && split.length == 2) {
                property = entityType.findProperty(split[1]);
            }
            if (property instanceof BasedataProp) {
                return fieldName;
            }
            if (property instanceof MulBasedataProp) {
                return String.format("%s.fbasedataid", fieldName);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getLimitSceneCode(String entityId, ReportQueryParam queryParam) {
        try (EntityTraceSpan span = EntityTracer.create((String)SPAN_TYPE, (String)"getLimitSceneCode", (EntityTraceHint)EntityTraceHint.getHintDisLinkAPM());){
            if (queryParam != null && !CollectionUtils.isEmpty((Map)queryParam.getCustomParam())) {
                Object queryLimit = queryParam.getCustomParam().get("bos_reportConcurrencyQueryLimit");
                span.addLocaleTag("bos_reportConcurrencyQueryLimit", queryLimit);
                if (queryLimit != null && StringUtils.equals((CharSequence)"false", (CharSequence)queryLimit.toString())) {
                    String string2 = "";
                    return string2;
                }
            }
            Map data = BusinessDataReader.loadFromCache((String)"bos_report_limit_config", (String)"querylimit", (QFilter[])new QFilter[]{new QFilter("entitynumber.number", "=", (Object)entityId)});
            String sceneCode = null;
            if (data != null && data.size() > 0) {
                for (DynamicObject value : data.values()) {
                    sceneCode = value.getString("querylimit");
                }
            }
            if (StringUtils.isBlank(sceneCode)) {
                sceneCode = "REPORT_QUERY_LIMIT";
            }
            span.addLocaleTag("sceneCode", (Object)sceneCode);
            String string = sceneCode;
            return string;
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u62a5\u8868\u9650\u6d41\u914d\u7f6e\u62a5\u9519", (Throwable)e);
            return "REPORT_QUERY_LIMIT";
        }
    }

    private void recordConcurrencyLimitId(String sceneCode, String entityId, String concurrentID, String pageId) {
        try {
            ConcurrentScene scenes = ConcurrentSceneManager.getScene((String)sceneCode);
            if (scenes != null && scenes.isSingleUserLimit1()) {
                HashMap<String, String> data = new HashMap<String, String>(3);
                data.put("concurrentid", concurrentID);
                data.put("pageid", pageId);
                cache.put(String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), RequestContext.get().getUserId(), entityId, "query"), data);
                ThreadCache.put((Object)"concurrentid", (Object)concurrentID);
                log.info("recordConcurrencyLimitId, entityId={}, sceneCode={}, pageId={}, concurrentID={}", new Object[]{entityId, sceneCode, concurrentID, pageId});
            }
        }
        catch (Exception e) {
            log.warn("\u7f13\u5b58\u9650\u6d41\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void setReportTaskResult(ReportTaskParam param, String pageId, String ctrlId, ReportTaskResult result) {
        Map data;
        Object noLimit = ThreadCache.get((Object)"bos_noLimit");
        if ((noLimit == null || StringUtils.equals((CharSequence)"false", (CharSequence)noLimit.toString())) && !CollectionUtils.isEmpty((Map)(data = cache.getAll(String.format("%s.%s.%s.%s", CacheKeyUtil.getAcctId(), RequestContext.get().getUserId(), param.getReportName(), "query"))))) {
            String concurrentID = (String)data.get("concurrentid");
            Object currentID = ThreadCache.get((Object)"concurrentid");
            if (StringUtils.isNotEmpty((CharSequence)concurrentID) && currentID != null && !StringUtils.equals((CharSequence)concurrentID, (CharSequence)currentID.toString())) {
                String currentPageId = (String)data.get("pageid");
                if (result != null) {
                    result.close();
                }
                if (!StringUtils.equals((CharSequence)pageId, (CharSequence)currentPageId)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u62a5\u8868\u8fdb\u884c\u7684\u67e5\u8be2\u4efb\u52a1\u5df2\u7ecf\u88ab\u7ec8\u6b62\u3002", (String)"ReportServiceImpl_13", (String)BOS_MSERVICE_REPORT, (Object[])new Object[0]));
                }
                return;
            }
        }
        this.getReportCache().setReportTaskResult(pageId, ctrlId, result);
    }
}

